/*
 * Copyright (c) 2002,2003 Hamish Rodda <rodda@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <kdebug.h>

#include "tderandrapp.h"
#include "tderandrapp.moc"

#include "tderandrtray.h"

#include <X11/Xlib.h>

KRandRApp::KRandRApp()
	: m_tray(new KRandRSystemTray(0L, "RANDRTray"))
{
	connect(&m_eventMergingTimer, TQ_SIGNAL(timeout()), this, TQ_SLOT(handleX11ConfigChangeEvent()));
	m_tray->show();
}

void KRandRApp::handleX11ConfigChangeEvent()
{
	m_eventMergingTimer.stop();
	m_tray->configChanged();
}

bool KRandRApp::x11EventFilter(XEvent* e)
{
	if (e->type == m_tray->screenChangeNotifyEvent()) {
		m_eventMergingTimer.start(1000, true);
	}
	return TDEApplication::x11EventFilter( e );
}
