/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/



#ifndef OPTIONS_H
#define OPTIONS_H

#include "../config.h"

// Standard Headers
#include <stdio.h>

// TQt Headers
#include <tqdir.h>
#include <tqwidget.h>
#include <tqfiledialog.h>
#include <tqgroupbox.h>

// KDE headers
#include <tdeapplication.h>
#include <tdefiledialog.h>

#include <kpackage.h>

class KURLRequester;


class TQVBoxLayout;
class TQGroupBox;
class TQCheckBox;
class TQPushButton;
class KComboBox;
class TQButtonGroup;
class TQRadioButton;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class Options : public KDialogBase
{
  TQ_OBJECT
  

public:

  Options ( TQWidget *parent = 0);
  ~Options();

  void restore();
  // show window, setting the buttons

  void setValues();
  // set the dialog to match options values

private:

  bool verifyFL;
  bool PkgRead;
  bool fRemote;
  int  DCache, dc, PCache, pc, privCmd, prc;
  TQString CacheDir;

  TQVBoxLayout* vl;

  TQVBoxLayout* vt;
  TQGroupBox *framet;
  TQGroupBox *packageBox[kpinterfaceN];
  TQCheckBox *packageHandle[kpinterfaceN];
  TQPushButton *locate[kpinterfaceN];

  TQGroupBox *hh;
  TQCheckBox *huse;
  KComboBox *hosts;

  TQVBoxLayout* vb;
  TQButtonGroup *bg;
  TQRadioButton *disp[4];

  TQVBoxLayout*  vc;
  TQButtonGroup *bc;
  TQRadioButton *dcache[3];

  TQVBoxLayout*  vp;
  TQButtonGroup *bp;
  TQRadioButton *pcache[3];

  TQVBoxLayout*  vs;
  TQButtonGroup *bs;
  TQRadioButton *privs[3];
  
  KURLRequester *cachedir;

  TQVBoxLayout* vr;
  TQGroupBox *framer;
  TQCheckBox *pkgRead;

  TQVBoxLayout* vf;
  TQGroupBox *framem;
  TQCheckBox *valid;


public slots:
    void scanLocates();
    void apply_slot();
    void cancel_slot();
    void PDCache(int);
    void PPCache(int);
    void PPrivs(int);
  
private slots:
    void insHosts();
    void useRemote();
};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

class Opts
{
public:
  void readSettings(const TQString &initHost = "");
  void writeSettings();

  void readLaterSettings();
  // options to be setup after package interfaces setup

  TQStringList hostList;
  // list of hosts to choose from

  bool VerifyFL;
  // config: verify the file list

  bool PkgRead;
  // read information about uninstalled packages from each RPM file itself

  bool handlePackage[kpinterfaceN];

  enum {INSTALLED, UPDATED, NEW, ALL};
  enum {ALWAYS, SESSION, NEVER};

  int DCache;
  // how much to cache uninstall package directories

  int PCache;
  // how much to cache uninstall packages
  
  int privCmd;
  // which command to use to execute priveliged commands
  enum {SUcmd=0, SUDOcmd=1, SSHcmd=2};

  TQString CacheDir;
  // cache directory

  Opts(const TQString &initHost);
  ~Opts();
};
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#endif
