/*
	This file is part of the KDE libraries
	Copyright (C) 2003 Charles Samuels <charles@kde.org>

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License version 2 as published by the Free Software Foundation.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License
	along with this library; see the file COPYING.LIB.  If not, write to
	the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
	Boston, MA 02110-1301, USA.
*/

#include "kdatacollection.h"

#include <tdeconfig.h>
#include <tdeglobal.h>
#include <tdestandarddirs.h>

#include <tqfile.h>
#include <tqfileinfo.h>


KDataCollection::KDataCollection(
		TDEConfig *config, const TQString &group, const TQString &entry,
		const char *datadir, const TQString &dir
	)
{
	init(config, group, entry, datadir, dir);
}

KDataCollection::KDataCollection(
		TDEConfig *config, const TQString &group, const TQString &entry,
		const TQString &dir
	)
{
	init(config, group, entry, "appdata", dir);
}

KDataCollection::KDataCollection(
		TDEConfig *config, const TQString &group, const TQString &dir
	)
{
	init(config, group, dir, "appdata", dir);
}

KDataCollection::KDataCollection(TDEConfig *config, const TQString &dir)
{
	init(config, "KDataCollection", dir, "appdata", dir);
}

KDataCollection::KDataCollection(const TQString &dir)
{
	init(TDEGlobal::config(), "KDataCollection", dir, "appdata", dir);
}

void KDataCollection::init(
		TDEConfig *config, const TQString &group, const TQString &entry,
		const char *datadir, const TQString &dir
	)
{
	mConfig = config;
	mGroup = group;
	mEntry = entry;
	mDir = dir;
	mDatadir = datadir;
}

TQStringList KDataCollection::names() const
{
	TDEConfigGroup g(mConfig, mGroup);

	// these are the entries I have
	TQStringList n = g.readListEntry(mEntry);
	TQStringList fs = TDEGlobal::dirs()->findAllResources(mDatadir, mDir+"/*", false, true);
	TQStringList total;

	for (TQStringList::Iterator i(fs.begin()); i != fs.end(); ++i)
	{
		TQFileInfo fi(*i);
		TQString name = fi.fileName();
		if (!n.contains(name))
		{
			total.append(name);
		}
	}

	return total;
}

void KDataCollection::remove(const TQString &name)
{
	TDEConfigGroup g(mConfig, mGroup);
	TQString location = file(name);
	if (location.isEmpty()) return;
	if (location == saveFile(name, false))
	{
		TQFile(location).remove();
		// is there a system one too?
		location = file(name, false);
		if (location.isEmpty()) return;
	}

	TQStringList n = g.readListEntry(mEntry);
	if (n.contains(name)) return;
	n.append(name);
	g.writeEntry(mEntry, n);
}

TQString KDataCollection::file(const TQString &name, bool create)
{
	TQString path = ::locate(mDatadir, mDir+"/"+name);

	if (path.isEmpty() && create)
	{
		path = saveFile(name, true);
	}
	return path;
}

TQString KDataCollection::saveFile(const TQString &name, bool create)
{
	if (!TDEGlobal::dirs()->isRestrictedResource(mDatadir, mDir+"/"+name))
	{
		TQString s = TDEGlobal::dirs()->saveLocation(mDatadir, mDir, create);

		if (s.length() && create)
		{
			s += "/" + name;
			TQFile(s).open(IO_ReadWrite); // create it
		}
		return s;
	}
	return TQString();
}


