/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEUNITSDIALOG_H
#define QALCULATEUNITSDIALOG_H

#include <kdialog.h>
#include <tqmap.h>
#include <tqvaluevector.h>

class Unit;
class QalculateEditUnitDialog;
class TDEListView;
class TQListViewItem;
class TQPushButton;
class KLineEdit;
class TQLabel;
class KComboBox;
class TQGroupBox;

/**
@author Niklas Knutsson
*/
class QalculateUnitsDialog : public KDialog {

	TQ_OBJECT

public:

	QalculateUnitsDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateUnitsDialog();

	QalculateEditUnitDialog *unit_edit_dialog;
	TQString selected_category;
	Unit *selected_unit, *selected_to_unit;
	void addUnitTreeItem(Unit *f);
	TQMap<TQListViewItem*, Unit*> unitItems;
	TQMap<TQListViewItem*, TQString> categoryItems;
	TQValueVector<Unit*> comboItems;

	TQGroupBox *convertGroup;
	TDEListView *categoryView;
	TDEListView *unitView;
	TQPushButton *newButton;
	TQPushButton *editButton;
	TQPushButton *deleteButton;
	TQPushButton *deactivateButton;
	TQPushButton *insertButton;
	TQPushButton *helpButton;
	TQPushButton *buttonClose;
	TQPushButton *convertResultButton;
	TQPushButton *convertButton;
	TQLabel *fromLabel, *equalsLabel;
	KLineEdit *toEdit, *fromEdit;
	KComboBox *toCombo;

	bool block_unit_convert;

public slots:

	void updateUnitTree();
	void unitDoubleClicked(TQListViewItem*);
	void unitSelected();
	void categorySelected();
	void insertUnit();
	void deactivateUnit();
	void deleteUnit();
	void editUnit();
	void newUnit();
	void convertResult();
	void convertClicked();
	void convert();
	void convertReversed();
	void toUnitSelected(int);
	
protected slots:
	
	void slotHelp();	

signals:

	void unitsChanged();
	void insertRequest(Unit*);
	void convertRequest(Unit*);
	
protected:

	void keyPressEvent(TQKeyEvent *e);

};

#endif
