#include <tqevent.h>
#include <tqlayout.h>
#include <tqwhatsthis.h>
#include <tqtooltip.h>

#include <kdialog.h>
#include <tdelocale.h>

#include "keypad.h"

CharButton::CharButton(const TQString &text, TQWidget *parent, const char *name)
	: TQPushButton(text, parent, name)
{
	setAutoRepeat(true);
	setAccel(text);
	m_text = text;
	connect(this, TQ_SIGNAL(clicked()), this, TQ_SLOT(emitClicked()));
}

void CharButton::emitClicked()
{
	emit clicked(m_text);
}

MathKeypad::MathKeypad(TQWidget *parent, const char *name)
	: TQWidget(parent, name)
{
	TQVBoxLayout *vlayout = new TQVBoxLayout(this, KDialog::marginHint(), KDialog::spacingHint());

	TQPushButton *focusButton = new TQPushButton(i18n("Press to Focus Keypad"), this);
	connect(focusButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(setFocus()));
	vlayout->addWidget(focusButton);

	TQGridLayout *midBox = new TQGridLayout(vlayout, 5, 4, KDialog::spacingHint());

	TQPushButton *EnterButton = new TQPushButton(i18n("Enter"), this);
	EnterButton->setAccel(Key_Enter);
	TQWhatsThis::add(EnterButton, i18n("Enter expression onto stack"));
	midBox->addMultiCellWidget(EnterButton, 0, 0, 0, 1);
	connect(EnterButton, TQ_SIGNAL(clicked()), this, TQ_SIGNAL(enter()));

	TQPushButton *EEXButton = new TQPushButton("&EEX", this);
	TQWhatsThis::add(EEXButton, i18n("Enters an E into line edit. When evaluated, the number directly before the E (no space on either side of the E) is multiplied by 10 raised to the number directly after the E. Only in Decimal mode."));
	midBox->addWidget(EEXButton, 0, 2);
	connect(EEXButton, TQ_SIGNAL(clicked()), this, TQ_SIGNAL(eex()));
	
	TQPushButton *BackSpaceButton = new TQPushButton("<-", this);
	TQToolTip::add(BackSpaceButton, i18n("Inversed: Clear"));
	BackSpaceButton->setAutoRepeat(true);
	BackSpaceButton->setAccel(Key_Backspace);
	midBox->addWidget(BackSpaceButton, 0, 3);
	connect(BackSpaceButton, TQ_SIGNAL(clicked()), this, TQ_SIGNAL(backspace()));

	CharButton *PeriodButton = new CharButton(".", this);
	PeriodButton->setAccel(Key_Period);
	connect(PeriodButton, TQ_SIGNAL(clicked(const TQString &)), this, TQ_SIGNAL(insertChar(const TQString &)));
	midBox->addWidget(PeriodButton, 4, 2);

	CharButton *SpaceButton = new CharButton(" ", this);
	SpaceButton->setText(i18n("Spc"));
	SpaceButton->setAccel(Key_Space);
	connect(SpaceButton, TQ_SIGNAL(clicked(const TQString &)), this, TQ_SIGNAL(insertChar(const TQString &)));
	midBox->addWidget(SpaceButton, 4, 1);
	
	CharButton *KP0Button = new CharButton(TQString::number(0), this);
	connect(KP0Button, TQ_SIGNAL(clicked(const TQString &)), this, TQ_SIGNAL(insertChar(const TQString &)));
	midBox->addWidget(KP0Button, 4, 0);

	CharButton *KP1Button = new CharButton(TQString::number(1), this);
	connect(KP1Button, TQ_SIGNAL(clicked(const TQString &)), this, TQ_SIGNAL(insertChar(const TQString &)));
	midBox->addWidget(KP1Button, 3, 0);

	CharButton *KP2Button = new CharButton(TQString::number(2), this);
	connect(KP2Button, TQ_SIGNAL(clicked(const TQString &)), this, TQ_SIGNAL(insertChar(const TQString &)));
	midBox->addWidget(KP2Button, 3, 1);

	CharButton *KP3Button = new CharButton(TQString::number(3), this);
	connect(KP3Button, TQ_SIGNAL(clicked(const TQString &)), this, TQ_SIGNAL(insertChar(const TQString &)));
	midBox->addWidget(KP3Button, 3, 2);

	CharButton *KP4Button = new CharButton(TQString::number(4), this);
	connect(KP4Button, TQ_SIGNAL(clicked(const TQString &)), this, TQ_SIGNAL(insertChar(const TQString &)));
	midBox->addWidget(KP4Button, 2, 0);

	CharButton *KP5Button = new CharButton(TQString::number(5), this);
	connect(KP5Button, TQ_SIGNAL(clicked(const TQString &)), this, TQ_SIGNAL(insertChar(const TQString &)));
	midBox->addWidget(KP5Button, 2, 1);

	CharButton *KP6Button = new CharButton(TQString::number(6), this);
	connect(KP6Button, TQ_SIGNAL(clicked(const TQString &)), this, TQ_SIGNAL(insertChar(const TQString &)));
	midBox->addWidget(KP6Button, 2, 2);

	CharButton *KP7Button = new CharButton(TQString::number(7), this);
	connect(KP7Button, TQ_SIGNAL(clicked(const TQString &)), this, TQ_SIGNAL(insertChar(const TQString &)));
	midBox->addWidget(KP7Button, 1, 0);

	CharButton *KP8Button = new CharButton(TQString::number(8), this);
	connect(KP8Button, TQ_SIGNAL(clicked(const TQString &)), this, TQ_SIGNAL(insertChar(const TQString &)));
	midBox->addWidget(KP8Button, 1, 1);

	CharButton *KP9Button = new CharButton(TQString::number(9), this);
	connect(KP9Button, TQ_SIGNAL(clicked(const TQString &)), this, TQ_SIGNAL(insertChar(const TQString &)));
	midBox->addWidget(KP9Button, 1, 2);

	TQPushButton *DivideButton = new TQPushButton("/", this);
	DivideButton->setAccel(Key_Slash);
	connect(DivideButton, TQ_SIGNAL(clicked()), this, TQ_SIGNAL(divide()));
	midBox->addWidget(DivideButton, 1, 3);

	TQPushButton *MultiplyButton = new TQPushButton("*", this);
	MultiplyButton->setAccel(Key_Asterisk);
	connect(MultiplyButton, TQ_SIGNAL(clicked()), this, TQ_SIGNAL(multiply()));
	midBox->addWidget(MultiplyButton, 2, 3);

	TQPushButton *SubtractionButton = new TQPushButton("-", this);
	SubtractionButton->setAccel(Key_Minus);
	connect(SubtractionButton, TQ_SIGNAL(clicked()), this, TQ_SIGNAL(subtract()));
	midBox->addWidget(SubtractionButton, 3, 3);

	TQPushButton *AdditionButton = new TQPushButton("+", this);
	AdditionButton->setAccel(Key_Plus);
	connect(AdditionButton, TQ_SIGNAL(clicked()), this, TQ_SIGNAL(add()));
	midBox->addWidget(AdditionButton, 4, 3);

	setCaption(i18n("Keypad") + " - Mathemagics");
}

void MathKeypad::closeEvent(TQCloseEvent *e)
{
	emit closing();

	e->accept();
}

#include "keypad.moc"
