#ifndef _KVI_PACKAGEFILE_H_
#define _KVI_PACKAGEFILE_H_
//=============================================================================
//
//   File : kvi_packagefile.h
//   Created on Tue 26 Dec 2006 05:33:33 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC Client distribution
//   Copyright (C) 2006 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"
#include "kvi_pointerhashtable.h"
#include "kvi_qcstring.h" // TQByteArray anyway
#include <tqobject.h>
#include "kvi_pointerlist.h"

class KviFile;
class TQProgressDialog;
class TQLabel;
class TQFileInfo;

//
// This class is used for creating KVIrc package files.
// You simply instantiate it, add some info fields, add some files and then call pack().
//

class KVILIB_API KviPackageIOEngine
{
public:
	KviPackageIOEngine();
	virtual ~KviPackageIOEngine();
protected:
	TQString m_szLastError;
	KviPointerHashTable<TQString,TQString> * m_pStringInfoFields;
	KviPointerHashTable<TQString,TQByteArray> * m_pBinaryInfoFields;
	TQProgressDialog * m_pProgressDialog;
	TQLabel * m_pProgressDialogLabel;
public:
	const TQString & lastError(){ return m_szLastError; };
	void setLastError(const TQString &szLastError){ m_szLastError = szLastError; };
	KviPointerHashTable<TQString,TQString> * stringInfoFields(){ return m_pStringInfoFields; };
	KviPointerHashTable<TQString,TQByteArray> * binaryInfoFields(){ return m_pBinaryInfoFields; };
protected:
	void showProgressDialog(const TQString &szCaption,int iTotalSteps);
	void hideProgressDialog();
	bool updateProgress(int iProgress,const TQString &szLabel);
	bool writeError();
	bool readError();
};

#define KVI_PACKAGE_INFOFIELD_TYPE_STRING 1
#define KVI_PACKAGE_INFOFIELD_TYPE_BINARYBUFFER 2

#define KVI_PACKAGE_DATAFIELD_TYPE_FILE 1

#define KVI_PACKAGE_DATAFIELD_FLAG_FILE_DEFLATE 1

class KVILIB_API KviPackageWriter : public KviPackageIOEngine
{
public:
	KviPackageWriter();
	virtual ~KviPackageWriter();
protected:

	class DataField
	{
	public:
		kvi_u32_t m_uType;
		// output length of the field
		kvi_u32_t m_uWrittenFieldLength;
		// data fields for the File DataFieldType
		bool m_bFileAllowCompression;
		TQString m_szFileLocalName;
		TQString m_szFileTargetName;
	};

	KviPointerList<DataField> * m_pDataFields;
	int m_iCurrentProgress;
public:
	// Adds a file to the package. The file must be specified as absolute local
	// path and as target path relative to the KVIrc local directory.
	// ... more ?
	enum AddFileFlags {
		NoCompression = 1,
		FollowSymLinks = 2
	};
	bool addFile(const TQString &szLocalFileName,const TQString &szTargetFileName,kvi_u32_t uAddFileFlags = 0);
	bool addDirectory(const TQString &szLocalDirectoryName,const TQString &szTargetDirectoryPrefix,kvi_u32_t uAddFileFlags = 0);
	// Adds an info field as a name=value pair
	void addInfoField(const TQString &szName,const TQString &szValue);
	void addInfoField(const TQString &szName,TQByteArray * pArray);
	// Attempts to pack everything and store it as the specified file.
	// There is no mandatory extension but you *should* use KVI_FILEEXTENSION_THEMEPACKAGE for themes
	// and KVI_FILEEXTENSION_ADDONPACKAGE for addons. See kvi_fileextension.h
	enum PackFlags {
		NoProgressDialog = 1
	};
	bool pack(const TQString &szFileName,kvi_u32_t uPackFlags = 0);
private:
	bool packInternal(const TQString &szFileName,kvi_u32_t uPackFlags = 0);
	bool packFile(KviFile * pFile,DataField * pDataField);
	bool addFileInternal(const TQFileInfo * fi,const TQString &szLocalFileName,const TQString &szTargetFileName,kvi_u32_t uAddFileFlags = 0);
};

class KVILIB_API KviPackageReader : public KviPackageIOEngine
{
public:
	KviPackageReader();
	virtual ~KviPackageReader();
public:
	bool readHeader(const TQString &szLocalFileName);
	enum UnpackFlags {
		NoProgressDialog = 1
	};
	bool getStringInfoField(const TQString &szName,TQString &szBuffer);
	bool unpack(const TQString &szLocalFileName,const TQString &szUnpackPath,kvi_u32_t uUnpackFlags = 0);
private:
	bool unpackInternal(const TQString &szLocalFileName,const TQString &szUnpackPath,kvi_u32_t uUnpackFlags = 0);
	bool unpackFile(KviFile * pFile,const TQString &szUnpackPath);
	bool readHeaderInternal(KviFile * pFile,const TQString &szLocalFileName);
};



#endif //!_KVI_PACKAGEFILE_H_
