/***************************************************************************
                          sq_dir.cpp  -  description
                             -------------------
    begin                : ??? ??? 20 2004
    copyright            : (C) 2004 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tqstringlist.h>
#include <tqfile.h>
#include <tqdatetime.h>
#include <tqfileinfo.h>

#include <kurl.h>

#include "sq_dir.h"
#include "sq_thumbnailinfo.h"

SQ_Dir::SQ_Dir() : TQDir()
{}

SQ_Dir::SQ_Dir(Prefix p) : TQDir()
{
    switch(p)
    {
        case SQ_Dir::DirectoryBasket:
            setRoot("directorybasket");
        break;
        case SQ_Dir::Basket:
            setRoot("basket");
        break;
        case SQ_Dir::Categories:
            setRoot("categories");
        break;
    }
}

SQ_Dir::~SQ_Dir()
{}

/*
 *  Create relative directory in storage.
 *
 *  For example, if prefix == Thumbnails,
 *  mkdir("/mnt/win_c") will create
 *  ~/.ksquirrel/thumbnails/mnt/win_c.
 */
bool SQ_Dir::mkdir(const TQString &relpath)
{
    TQStringList paths = TQStringList::split('/', TQDir::cleanDirPath(relpath));

    cd(m_root);

    // recursively create directories
    for(TQStringList::iterator it = paths.begin();it != paths.end();++it)
    {
        if(!exists(*it, false))
            if(!TQDir::mkdir(*it))
                return false;

        cd(*it);
    }

    return true;
}

void SQ_Dir::setRoot(const TQString &name)
{
    m_root = TQDir::cleanDirPath(homeDirPath() + TQDir::separator() + TQString::fromLatin1(".ksquirrel"));
    TQDir::mkdir(m_root);

    m_root = TQDir::cleanDirPath(m_root + TQDir::separator() + name);
    TQDir::mkdir(m_root);
}

TQString SQ_Dir::absPath(const KURL &relurl)
{
    return m_root + TQDir::separator() + relurl.path();
}
