/***************************************************************************
                          chessclock.cpp  -  description
                             -------------------
    begin                : Mon Jul 2 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "chessclock.moc"
#include "audio.h"

chessclock::chessclock(TQWidget *parent, const char *name, resource *Rsrc ) : TQWidget(parent,name)
{
	Resource = Rsrc;
	Silent = true;
	WhiteIndex = 0;
	BlackIndex = 0;
	Flag[WHITE] = false;
	Flag[BLACK] = false;
	whiteClock = "  0:00:00  ";
	blackClock = "  0:00:00  ";
}
chessclock::~chessclock()
{
}
///////////////////////////////////////
//
//	chessclock::Set
//
///////////////////////////////////////
void chessclock::Set( const int WhiteSec, const int BlackSec, const bool onMove )
{
  /* these times are in centi seconds */
  White.Seconds = WhiteSec / 10;
  Black.Seconds = BlackSec / 10;
  ArmyOnMove = onMove;
}
///////////////////////////////////////
//
//	chessclock::Reset
//
///////////////////////////////////////
void chessclock::Reset( void )
{
  Pause();
  WhiteIndex = 0;
  BlackIndex = 0;

  White = Resource->TCPWhite[WhiteIndex];
  Black = Resource->TCPBlack[BlackIndex];

  White.Seconds *= 10;
  White.Increment *= 10;
  Black.Seconds *= 10;
  Black.Increment *= 10;

  ArmyOnMove = WHITE;
  External = false;
  UpdateStrings();
}
///////////////////////////////////////
//
//	chessclock::Pause
//
///////////////////////////////////////
void chessclock::Pause( void )
{
	Silent = true;
}
///////////////////////////////////////
//
//	chessclock::Resume
//
///////////////////////////////////////
void chessclock::Resume( void )
{
	Silent = false;
}
///////////////////////////////////////
//
//	chessclock::getCentiseconds
//
///////////////////////////////////////
int chessclock::getCentiseconds( const bool Army )
{
  if( Army == WHITE )
  {
    return White.Seconds * 10;
  }
  return Black.Seconds * 10;
}
///////////////////////////////////////
//
//	chessclock::Moved
//
///////////////////////////////////////
void chessclock::Moved( void )
{
  Pause();
  if( ArmyOnMove == WHITE )
  {
    ArmyOnMove = BLACK;
    White.Moves--;
    White.Seconds += White.Increment;
    if( White.Moves < 1 )
    {
      WhiteIndex++;
      if( WhiteIndex == (signed)Resource->TCPWhite.count() ) WhiteIndex--;
      White = Resource->TCPWhite[WhiteIndex];
      White.Seconds *= 10;
      White.Increment *= 10;
    }
  }
	else
	{
		ArmyOnMove = WHITE;
		Black.Moves--;
		Black.Seconds += Black.Increment;
		if( Black.Moves < 1 )
		{
			BlackIndex++;
			if( BlackIndex == (signed)Resource->TCPBlack.count() ) BlackIndex--;
			Black = Resource->TCPBlack[BlackIndex];
			Black.Seconds *= 10;
			Black.Increment *= 10;
		}
	}
	Resume();
}
///////////////////////////////////////
//
//	chessclock::Tick
//
///////////////////////////////////////
void chessclock::Tick( void )
{
	if( Silent ) return;
	if( ArmyOnMove == WHITE )
	{
		White.Seconds--;
		if( ( White.Seconds < 0 ) && ( Flag[WHITE] == false ) )
		{
			Flag[WHITE] = true;
			emit flagFell( WHITE );
			Resource->play( SND_FLAG );
		}
	}
	else
	{
		Black.Seconds--;
		if( ( Black.Seconds < 0 ) && ( Flag[BLACK] == false ) )
		{
			Flag[BLACK] = true;
			emit flagFell( BLACK );
			Resource->play( SND_FLAG );
		}
	}
	UpdateStrings();
}
///////////////////////////////////////
//
//	chessclock::UpdateStrings
//
///////////////////////////////////////
void chessclock::UpdateStrings( void )
{
	int tmp;
	int h, m, s;
	char sign;

	sign = ' ';
	if( White.Seconds < 0 ) sign = '-';
	tmp = abs(White.Seconds / 10);
	s = ( tmp % 60 );
	m = ( ( tmp / 60 ) % 60 );
	h = ( ( tmp / 60 ) / 60 );
	whiteClock.sprintf( " %c%.1d:%.2d:%.2d  ", sign, h, m, s );

	sign = ' ';
	if( Black.Seconds < 0 ) sign = '-';
	tmp = abs(Black.Seconds / 10);
	s = ( tmp % 60 );
	m = ( ( tmp / 60 ) % 60 );
	h = ( ( tmp / 60 ) / 60 );
	blackClock.sprintf( " %c%.1d:%.2d:%.2d  ", sign, h, m, s );
}
