/*
 *   kioskdata.h
 *
 *   Copyright (C) 2003, 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef _KIOSKDATA_H_
#define _KIOSKDATA_H_

#include <tqdict.h>
#include <tqptrlist.h>
#include <tqstringlist.h>

class  TQDomElement;

class ComponentAction
{
public:
   ComponentAction();
   ~ComponentAction();
   bool load(const TQDomElement &docElem);

private:
   TQString expand(const TQString &);

public:
   TQString caption;
   TQString description;
   typedef enum {ActImmutable, ActRestrict, ActCustom, ActModule, ActConfig, ActResource } ActionType;
   ActionType type;
   TQString file;
   TQString group;
   TQString key;
   TQPtrList<ComponentAction> subActions;
   bool defaultValue;
   
   static TQDict<TQString> *s_stdActionCaptions;
};

class ComponentExecData
{
public:
   void load(const TQDomElement &docElem);
   bool hasOption(const TQString &option) { return options.contains(option); }
public:
   TQString exec;
   TQString dcop;
   TQStringList options;
   TQStringList args;
};

class ComponentData
{
public:
   ComponentData();
   ~ComponentData();
   bool load(const TQDomElement &docElem);
   bool loadActions(const TQDomElement &docElem);

protected:
   void loadSetup(const TQDomElement &docElem);
   
public:
   TQString id;
   TQString caption;
//   TQString description;
   TQString icon;
   TQPtrList<ComponentAction> actions;
   TQStringList mutableFiles;
   TQStringList ignoreFiles;
   ComponentExecData setup;
   ComponentExecData preview;
};

class KioskData
{
public:
   KioskData();
   ~KioskData();

   TQString errorMsg() { return m_errorMsg; }

   bool load();
   
public:
   TQStringList m_componentList;
   TQDict<ComponentData> m_componentData;
   
protected:
   TQString m_errorMsg;   
};

#endif
