/*
 * broadcasteditor.cpp
 *
 * Copyright (C) 2005 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <tqdir.h>
#include <tqvaluelist.h>

#include <kpushbutton.h>
#include <kiconloader.h>
#include <tdelocale.h>

#include "broadcasteditor.h"

BroadcastEditor::BroadcastEditor( TQWidget *parent, TQPtrList<ChannelDesc> *ch, TQPtrList<ChannelDesc> *ret ) : BroadcastEditorUI( parent )
{
	TDEIconLoader *icon = new TDEIconLoader();

	tvPix = icon->loadIcon( "kdvbtv", TDEIcon::Small );
	tvcPix = icon->loadIcon( "kdvbtvc", TDEIcon::Small );
	raPix = icon->loadIcon( "kdvbra", TDEIcon::Small );
	racPix = icon->loadIcon( "kdvbrac", TDEIcon::Small );
	addBtn->setGuiItem( KGuiItem(i18n("Add"), icon->loadIconSet("forward", TDEIcon::Small) ) );
	resetBtn->setGuiItem( KGuiItem(i18n("Reset"), icon->loadIconSet("reload", TDEIcon::Small) ) );
	cancelBtn->setGuiItem( KGuiItem(i18n("Cancel"), icon->loadIconSet("cancel", TDEIcon::Small) ) );
	okBtn->setGuiItem( KGuiItem(i18n("OK"), icon->loadIconSet("ok", TDEIcon::Small) ) );
	
	connect( channelLb, TQ_SIGNAL(doubleClicked(TQListBoxItem*)), this, TQ_SLOT(slotAddChannel(TQListBoxItem*)) );

	chan = ch;
	list = ret;

	resetList();
        delete icon;
}

BroadcastEditor::~BroadcastEditor()
{
}

ChannelDesc* BroadcastEditor::getChannel( const TQString &name )
{
	int i;

	for ( i=0; i<(int)chan->count(); i++ ) {
		if ( chan->at(i)->name==name ) return chan->at(i);
	}
	return 0;
}

void BroadcastEditor::slotAddChannel(TQListBoxItem*)
{
	addToList();
}

void BroadcastEditor::addToList()
{
	int i;
	TQString curName;
	TQValueList<TQListBoxItem*> qvl;
	ChannelDesc *c=0, *d=0;

	for ( i=0; i<(int)channelLb->count(); i++ ) {
		if ( channelLb->isSelected(i) ) {
			curName = channelLb->text(i);
			c = getChannel( curName );
			if ( !c ) continue;
			broadcastLb->insertItem( *channelLb->pixmap(i), channelLb->text(i) );
			list->append( c );
			qvl.append(channelLb->item(i));
		}
	}
	if ( !c ) return;
	for ( i=0; i<(int)qvl.count(); i++ ) channelLb->takeItem( qvl[i] );

	qvl.clear();
	for ( i=0; i<(int)channelLb->count(); i++ ) {
		d = getChannel( channelLb->text(i) );
		if ( !d ) continue;
		if ( d->tp!=c->tp ) qvl.append(channelLb->item(i));
	}
	for ( i=0; i<(int)qvl.count(); i++ ) channelLb->takeItem( qvl[i] );

	channelLb->setSelectionMode( TQListBox::Extended );
}

bool BroadcastEditor::getChannelList()
{
	int i;
	ChannelDesc *c;

	for ( i=0; i<(int)chan->count(); i++ ) {
		c = chan->at(i);
		if ( c->fta ) {
			if ( c->type==1 ) channelLb->insertItem( tvcPix, c->name );
			else channelLb->insertItem( racPix, c->name );
		}
		else {
			if ( c->type==1 ) channelLb->insertItem( tvPix, c->name );
			else channelLb->insertItem( raPix, c->name );
		}
	}
	return true;
}

void BroadcastEditor::resetList()
{
	addBtn->setEnabled( true );
	channelLb->clear();
	broadcastLb->clear();
	list->clear();
	getChannelList();
	channelLb->sort();
	channelLb->setSelectionMode( TQListBox::Single );
}

#include "broadcasteditor.moc"
