/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date  : 2005-01-18
 * Description : a widget class to edit perspective.
 * 
 * Copyright (C) 2005-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright (C) 2006-2007 by Marcel Wiesweg <marcel dot wiesweg at gmx dot de>
 * 
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef PERSPECTIVEWIDGET_H
#define PERSPECTIVEWIDGET_H

// TQt includes.

#include <tqwidget.h>
#include <tqpoint.h>
#include <tqpointarray.h>
#include <tqcolor.h>
#include <tqrect.h>

// Digikam includes.

#include "dimg.h"

// Local includes.

#include "matrix.h"

class TQPixmap;

namespace Digikam
{
class ImageIface;
}

namespace DigikamPerspectiveImagesPlugin
{

class PerspectiveWidget : public TQWidget
{
TQ_OBJECT
  

public:

    PerspectiveWidget(int width, int height, TQWidget *parent=0);
    ~PerspectiveWidget();

    TQRect  getTargetSize(void);
    TQPoint getTopLeftCorner(void);
    TQPoint getTopRightCorner(void);
    TQPoint getBottomLeftCorner(void);
    TQPoint getBottomRightCorner(void);
    void   reset(void);

    float getAngleTopLeft(void);
    float getAngleTopRight(void);
    float getAngleBottomLeft(void);
    float getAngleBottomRight(void);

    void  applyPerspectiveAdjustment(void);

    Digikam::ImageIface* imageIface();

public slots:

    void slotToggleAntiAliasing(bool a);
    void slotToggleDrawWhileMoving(bool draw);
    void slotToggleDrawGrid(bool grid);

    void slotChangeGuideColor(const TQColor &color);
    void slotChangeGuideSize(int size);    

signals:

    void signalPerspectiveChanged( TQRect newSize, float topLeftAngle, float topRightAngle,
                                   float bottomLeftAngle, float bottomRightAngle );   

protected:

    void paintEvent( TQPaintEvent *e );
    void resizeEvent( TQResizeEvent * e );
    void mousePressEvent ( TQMouseEvent * e );
    void mouseReleaseEvent ( TQMouseEvent * e );
    void mouseMoveEvent ( TQMouseEvent * e );

private:  // Widget methods.

    void   updatePixmap(void);

    void   transformAffine(Digikam::DImg *orgImage, Digikam::DImg *destImage,
                           const Matrix &matrix, Digikam::DColor background);

    TQPoint buildPerspective(TQPoint orignTopLeft, TQPoint orignBottomRight,
                            TQPoint transTopLeft, TQPoint transTopRight,
                            TQPoint transBottomLeft, TQPoint transBottomRight,
                            Digikam::DImg *orgImage=0, Digikam::DImg *destImage=0,
                            Digikam::DColor background=Digikam::DColor());

private:

    enum ResizingMode
    {
        ResizingNone = 0,
        ResizingTopLeft,
        ResizingTopRight,
        ResizingBottomLeft,
        ResizingBottomRight
    };

    bool                 m_antiAlias;
    bool                 m_drawWhileMoving;
    bool                 m_drawGrid;

    uint                *m_data;
    int                  m_w;
    int                  m_h;
    int                  m_origW;
    int                  m_origH;

    int                  m_currentResizing;

    int                  m_guideSize;

    TQRect                m_rect;

    // Tranformed center area for mouse position control.

    TQPoint               m_transformedCenter;

    // Draggable local region selection corners.

    TQRect                m_topLeftCorner;
    TQRect                m_topRightCorner;
    TQRect                m_bottomLeftCorner;
    TQRect                m_bottomRightCorner;

    TQPoint               m_topLeftPoint;
    TQPoint               m_topRightPoint;
    TQPoint               m_bottomLeftPoint;
    TQPoint               m_bottomRightPoint;
    TQPoint               m_spot;

    TQColor               m_guideColor;

    // 60 points will be stored to compute a grid of 15x15 lines.
    TQPointArray          m_grid;

    TQPixmap             *m_pixmap;

    Digikam::ImageIface *m_iface;
    Digikam::DImg        m_previewImage;
};

}  // NameSpace DigikamPerspectiveImagesPlugin

#endif /* PERSPECTIVEWIDGET_H */
