/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2007 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#include "cswordtreekey.h"
#include "cswordbookmoduleinfo.h"

#include <tqtextcodec.h>

CSwordTreeKey::CSwordTreeKey( const CSwordTreeKey& k ) : CSwordKey(k), TreeKeyIdx(k) {}

CSwordTreeKey::CSwordTreeKey( const TreeKeyIdx *k, CSwordModuleInfo* module ) : CSwordKey(module), TreeKeyIdx(*k) {}

CSwordTreeKey* CSwordTreeKey::copy() const {
	return new CSwordTreeKey(*this);
}

const TQString CSwordTreeKey::getLocalNameUnicode() const
{
	Q_ASSERT(m_module);
	CSwordTreeKey* nonconst_this = const_cast<CSwordTreeKey*>(this);
	if (!m_module || m_module->isUnicode()) {
		return TQString::fromUtf8(nonconst_this->getLocalName());
	} else {
		TQTextCodec *codec = TQTextCodec::codecForName("CP1252");
		return codec->toUnicode(nonconst_this->getLocalName());
	}
}

/** Returns the key of this instance */
const TQString CSwordTreeKey::key() const {
	Q_ASSERT(m_module);
	if (!m_module || m_module->isUnicode()) {
		return TQString::fromUtf8(getText());
	} else {
		TQTextCodec *codec = TQTextCodec::codecForName("CP1252");
		return codec->toUnicode(getText());
	}
}

/** Returns the raw key for use by Sword */
const char* CSwordTreeKey::rawKey() const {
	return getText();
}

const bool CSwordTreeKey::key( const TQString& newKey ) {
	Q_ASSERT(m_module);
	if (!m_module || m_module->isUnicode()) {
		return key((const char*)newKey.utf8());
	} else {
		TQTextCodec *codec = TQTextCodec::codecForName("CP1252");
		return key((const char*)codec->fromUnicode(newKey));
	}
}

const bool CSwordTreeKey::key( const char* newKey ) {
	Q_ASSERT(newKey);

	if (newKey) {
		TreeKeyIdx::operator = (newKey);
	}
	else {
		root();
	}

	return !Error();
}

CSwordModuleInfo* const CSwordTreeKey::module( CSwordModuleInfo* const newModule ) {
	if (newModule && (newModule != m_module) && (newModule->type() == CSwordModuleInfo::GenericBook) ) {
		m_module = newModule;

		const TQString oldKey = key();

		CSwordBookModuleInfo* newBook = dynamic_cast<CSwordBookModuleInfo*>(newModule);
		copyFrom( *(newBook->tree()) );

		key(oldKey); //try to restore our old key

		//set the key to the root node
		root();
		firstChild();
	}

	return m_module;
}

/** Assignment operator. */
CSwordTreeKey& CSwordTreeKey::operator = (const TQString& keyname ) {
			key(keyname);
			return *this;
		}
