/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CENTRYDISPLAY_H
#define CENTRYDISPLAY_H

//BibleTime includes
#include "config.h"
#include "ctextrendering.h"
#include "cswordmoduleinfo.h"
#include "cswordbackend.h"

#include "util/cpointers.h"

//Sword includes
#include <swdisp.h>

//TQt includes
#include <tqstring.h>

class CSwordModuleInfo;

namespace Rendering {

/**
* The reimplementation of SWDisplay to fit our needs.
* @short Display implementation
* @author The BibleTime team
*/

class CEntryDisplay : public sword::SWDisplay, public CPointers {

public:
	virtual ~CEntryDisplay() {}

	/**
	* Returns the rendered text using the modules in the list and using the key parameter.
	* The displayoptions and filter options are used, too.
	*/
	virtual const TQString text( const ListCSwordModuleInfo& modules, const TQString& key, const CSwordBackend::DisplayOptions displayOptions, const CSwordBackend::FilterOptions filterOptions);

	/** casts a module to a character pointer and displays it to
	* raw output (overriden for different display types and
	* module types if necessary)
	*
	* @param imodule module to display
	* @return error status
	*/
	virtual char display(SWModule &imodule) { return 0; };
};


}

#endif
