/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef WA_NETLISTVIEWITEM_H
#define WA_NETLISTVIEWITEM_H

#include <iostream>

#include <tqpainter.h>

#include <tdelistview.h>
#include <tdemessagebox.h>

class NetListViewItem : public TDEListViewItem
{
public:
        //NetListViewItem(TDEListView *parent) : TDEListViewItem(parent) {}
        //NetListViewItem(TDEListView *parent, TDEListViewItem *after) : TDEListViewItem(parent, after) {}
        //NetListViewItem(TDEListView *parent, TDEListViewItem *after, TQString essid, TQString mode) : TDEListViewItem(parent, after, essid, mode) {}
        NetListViewItem(TDEListView *parent, TQString essid, TQString chan, int quality, bool enc, TQString ap, bool hidden, bool connected = 0 )
                        : TDEListViewItem(parent, TQString(), TQString(), TQString(), TQString(), TQString())
        {
                mEssid = essid;
                mChannel = chan;
                //mMode = mode;
                mQuality = quality;
                mEnc = enc;
                mAP = ap;
                mHidden = hidden;
                mConnected = connected;
                mHeight = height();
		mWpaSettings = TQStringList(); 
        }

        ~NetListViewItem()
        {}

        void setEssid(const TQString& theValue)
        {
                mEssid = theValue;
                setText(mEssidColumn, mEssid);
                //update();
        }
        TQString essid() const
        {
                return mEssid;
        }

        void setChannel(const TQString& theValue)
        {
                if ( mChannel != theValue ) {	//repaint only if difference visible in quality stars
                        mChannel = theValue;
                        repaint();
                }
        }


        TQString channel() const
        {
                return mChannel;
        }

        /*TQString mode() const
        {
                return mMode;
        }*/

        bool enc() const
        {
                return mEnc;
        }

        TQString ap() const
        {
                return mAP;
        }

	void setAp(const TQString& ap) {
		mAP = ap;
		setText(mAPColumn, mAP);
	}

        bool hidden() const
        {
                return mHidden;
        }

        void setConnected(bool theValue)
        {
                mConnected = theValue;
                if (mConnected)
                        mHeight+=10;
                else {
                        mHeight-=10;
                }
                setHeight( mHeight );
                repaint();
        }


        bool isConnected() const
        {
                return mConnected;
        }

        void setQuality(const int& theValue)
        {
                if ( int(mQuality/8) != int(theValue/8) ) {	//repaint only if difference visible in quality stars
                        mQuality = theValue;
                        repaint();
                } else
                        mQuality = theValue;
        }

        int quality() const
        {
                return mQuality;
        }

	void setWpaSettings(const TQStringList& theValue)
	{
	        mWpaSettings = theValue;
	}
	

	TQStringList wpaSettings() const
	{
	        return mWpaSettings;
	}
	




private:
        virtual void paintCell (TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment);
        virtual int width(const TQFontMetrics &fm, const TQListView *lv, int column) const;
        virtual TQString key( int column, bool ascending ) const;

        TQString mEssid;
        TQString mChannel;
        //TQString mMode;
        int mQuality;
        bool mEnc;
        TQString mAP;
        bool mHidden;
        bool mConnected;
        int mHeight;
	TQStringList mWpaSettings;

        static const int mEssidColumn = 0;
        static const int mChanColumn = 1;
        static const int mQualityColumn = 2;
        static const int mEncColumn = 3;
        static const int mAPColumn = 4;

};

#endif // WA_NETLISTVIEWITEM_H
