
#include <tqcstring.h>
#include <tqsocket.h>
#include <tqdatetime.h>
#include <tqbitarray.h>

#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <tdeapplication.h>
#include <kdebug.h>
#include <tdemessagebox.h>
#include <tdeinstance.h>
#include <tdeglobal.h>
#include <kstandarddirs.h>
#include <tdelocale.h>
#include <kurl.h>
#include <ksock.h>

#include "%{APPNAMELC}.h"

using namespace TDEIO;


tdeio_%{APPNAMELC}Protocol::tdeio_%{APPNAMELC}Protocol(const TQCString &pool_socket, const TQCString &app_socket)
    : SlaveBase("tdeio_%{APPNAMELC}", pool_socket, app_socket)
{
    kdDebug() << "tdeio_%{APPNAMELC}Protocol::tdeio_%{APPNAMELC}Protocol()" << endl;
}


tdeio_%{APPNAMELC}Protocol::~tdeio_%{APPNAMELC}Protocol()
{
    kdDebug() << "tdeio_%{APPNAMELC}Protocol::~tdeio_%{APPNAMELC}Protocol()" << endl;
}


void tdeio_%{APPNAMELC}Protocol::get(const KURL& url )
{
    kdDebug() << "tdeio_%{APPNAMELC}::get(const KURL& url)" << endl ;
    
    kdDebug() << "Seconds: " << url.query() << endl;
    TQString remoteServer = url.host();
    int remotePort = url.port();
    kdDebug() << "myURL: " << url.prettyURL() << endl;
    
    infoMessage(i18n("Looking for %1...").arg( remoteServer ) );
    // Send the mimeType as soon as it is known
    mimeType("text/plain");
    // Send the data
    TQString theData = "This is a test of tdeio_%{APPNAMELC}";
    data(TQCString(theData.local8Bit()));
    data(TQByteArray()); // empty array means we're done sending the data
    finished();
}


void tdeio_%{APPNAMELC}Protocol::mimetype(const KURL & /*url*/)
{
    mimeType("text/plain");
    finished();
}


extern "C"
{
    int kdemain(int argc, char **argv)
    {
        TDEInstance instance( "tdeio_%{APPNAMELC}" );
        
        kdDebug(7101) << "*** Starting tdeio_%{APPNAMELC} " << endl;
        
        if (argc != 4) {
            kdDebug(7101) << "Usage: tdeio_%{APPNAMELC}  protocol domain-socket1 domain-socket2" << endl;
            exit(-1);
        }
        
        tdeio_%{APPNAMELC}Protocol slave(argv[2], argv[3]);
        slave.dispatchLoop();
        
        kdDebug(7101) << "*** tdeio_%{APPNAMELC} Done" << endl;
        return 0;
    }
} 
