/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "prectedit.h"

#include <klineedit.h>
#include <tqlayout.h>
#include <tqpainter.h>

namespace PropertyLib{

PRectEdit::PRectEdit(MultiProperty* property, TQWidget* parent, const char* name): PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new KLineEdit(this);
    m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_edit);

    m_edit->setReadOnly(true);
}

TQVariant PRectEdit::value() const
{
    return m_value;
}

void PRectEdit::drawViewer(TQPainter* p, const TQColorGroup& cg, const TQRect& r, const TQVariant& value)
{
    p->setPen(TQt::NoPen);
    p->setBrush(cg.background());
    p->drawRect(r);
    p->drawText(r, TQt::AlignLeft | TQt::AlignVCenter | TQt::SingleLine, TQString("[ %1, %2, %3, %4 ]").arg(value.toRect().x()).arg(value.toRect().y()).arg(value.toRect().width()).arg(value.toRect().height()));
}

void PRectEdit::setValue(const TQVariant& value, bool emitChange)
{
    m_value = value;
    m_edit->setText(TQString("[ %1, %2, %3, %4 ]").arg(value.toRect().x()).arg(value.toRect().y()).arg(value.toRect().width()).arg(value.toRect().height()));

    if (emitChange)
        emit propertyChanged(m_property, value);
}

}

#ifndef PURE_QT
#include "prectedit.moc"
#endif
