/***************************************************************************
 *
 * tdenetman-cellular_device_tray.cpp - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa       <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/// TQt includes
#include <tqwidget.h> // for TQt::WidgetFlags

// TDE includes
#include <kdebug.h>
#include <tdelocale.h>
#include <kiconloader.h>

// TDENM includes
#include "tdenetman-cellular_device_tray.h"
#include "tdenetman-menuitem.h"
#include "tdenetman-menu_subhead.h"

#include "tdenetman-connection_settings_dialog.h"

using namespace ConnectionSettings;

class CellularDeviceTrayPrivate
{
	public:
		CellularDeviceTrayPrivate() {}
		~CellularDeviceTrayPrivate() {}

		TQString dev;
};

void CellularDeviceTray::newConnection()
{
	TDEGlobalNetworkManager* nm = TDEGlobal::networkManager();
	if (!nm)
	{
		return;
	}

	TDENetworkDevice* dev = dynamic_cast<TDENetworkDevice*>(hwdevices->findByUniqueID(d->dev));
	if (!dev)
	{
		return;
	}

	// create an appropriate connection
	TDENetworkConnection* conn = 0;
	TDENetworkConnectionManager* deviceConnMan = dev->connectionManager();
	if (!deviceConnMan)
	{
		return;
	}
	switch (deviceConnMan->deviceType()) {
		case TDENetworkDeviceType::Modem:
			conn = new TDEModemConnection();
			nm->loadConnectionAllowedValues(conn);
			break;

		default:
			break;
	}

	// edit the new connection
	ConnectionSettingsDialogImpl* dlg = new ConnectionSettingsDialogImpl(conn, true, TQByteArray(), tray(), "connect_something", false, TQt::WDestructiveClose);
	dlg->show();
}


void CellularDeviceTray::addMenuItems(TDEPopupMenu* menu)
{
	TDENetworkDevice* dev = dynamic_cast<TDENetworkDevice*>(hwdevices->findByUniqueID(d->dev));
	if (!dev)
	{
		return;
	}

	// device title
	Subhead* subhead = new Subhead (menu, "subhead", dev->deviceNode(), SmallIcon("nm_device_wwan", TQIconSet::Automatic));
	menu->insertItem (subhead, -1, -1);

	TDEGlobalNetworkManager* nm = TDEGlobal::networkManager();
	TDENetworkConnectionManager* deviceConnMan = dev->connectionManager();
	if (!nm || !deviceConnMan || !deviceConnMan->deviceInformation().managed)
	{
		// device is not managed by NM -> do not show any connections
		subhead = new Subhead(menu, "subhead2", i18n("Not managed"), SmallIcon("no", TQIconSet::Automatic));
		menu->insertItem(subhead, -1, -1);
	}
	else {
		TDENetworkConnection* active_conn = NULL;
		if ((!(deviceConnMan->deviceInformation().statusFlags & TDENetworkConnectionStatus::Disconnected))
			&& (!(deviceConnMan->deviceInformation().statusFlags & TDENetworkConnectionStatus::Invalid))) {
			active_conn = nm->findConnectionByUUID(deviceConnMan->deviceInformation().activeConnectionUUID);
		}

		// get all available Connections for cellular devices

		TDENetworkConnectionList* allconmap = nm->connections();
		for (TDENetworkConnectionList::Iterator it = allconmap->begin(); it != allconmap->end(); ++it) {
			TDEModemConnection* conn = dynamic_cast<TDEModemConnection*>(*it);
			if (!conn) {
				continue;
			}

			// lets create a nice name for this connection
			TQString title = conn->friendlyName;
			if (conn->ipConfig.valid) {
				title += TQString(" (%1)").arg((conn->ipConfig.connectionFlags & TDENetworkIPConfigurationFlags::IPV4DHCPIP) ? i18n("DHCP") : i18n("Manual IP config"));
			}

			NetworkMenuItem* item = new NetworkMenuItem(d->dev, conn->UUID, menu);

			int id = menu->insertItem(title, item, TQ_SLOT(slotActivate()));
			menu->setItemChecked(id, ((*it) == active_conn));
		}

		// bring the device down
		TDEAction* deactivate = tray()->actionCollection()->action("deactivate_device");
		if (deactivate) {
			deactivate->plug(menu);
		}
	}
	menu->insertSeparator();
}

CellularDeviceTray::CellularDeviceTray (TQString dev, KSystemTray * parent, const char * name)
	: DeviceTrayComponent (dev, parent, name)
{
	hwdevices = TDEGlobal::hardwareDevices();
	d = new CellularDeviceTrayPrivate();
	d->dev = dev;

	setPixmapForState(TDENetworkConnectionStatus::Connected, "nm_device_wwan");
}

CellularDeviceTray::~CellularDeviceTray ()
{
	delete d;
}


#include "tdenetman-cellular_device_tray.moc"
