###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### net-tools support

if( WITH_NETTOOLS )
    find_program( PATH_IFCONFIG "ifconfig" DOC "Path for the ifconfig program" )
    find_program( PATH_ROUTE    "route"    DOC "Path for the route program"    )
    find_program( PATH_IWCONFIG "iwconfig" DOC "Path for the iwconfig program" )

    if( PATH_IFCONFIG-NOTFOUND )
        tde_message_fatal( "Program ifconfig is required but was not found on your system." )
    endif()
    message( STATUS "Checking for ifconfig - found ${PATH_IFCONFIG}" )

    if( PATH_ROUTE-NOTFOUND )
        message( STATUS "Checking for route    - not found" )
     else()
        message( STATUS "Checking for route    - found ${PATH_ROUTE}" )
    endif()

    if( PATH_IWCONFIG-NOTFOUND )
        message( STATUS "Checking for iwconfig - not found" )
     else()
        message( STATUS "Checking for iwconfig - found ${PATH_IWCONFIG}" )
    endif()
    set( WITH_NETTOOLS 1 )
endif( WITH_NETTOOLS )


##### support for libiw

if( WITH_LIBIW )
  check_include_file( "iwlib.h" IW_HEADER )
  find_library( IW_LIBRARIES NAMES iw )

  if( IW_HEADER AND IW_LIBRARIES )
    set( HAVE_LIBIW 1 )
    else()
      tde_message_fatal( "libiw support is requested but was not found on your system" )
  endif( IW_HEADER AND IW_LIBRARIES )
endif( WITH_LIBIW )
