/***************************************************************************
 * copyright            : (C) 2006 Seb Ruiz <me@sebruiz.net>               *
 **************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ipodheader.h"
#include "ipodexportdialog.h"

#include "tdelocale.h"
#include "kpushbutton.h"

#include "tqlabel.h"
#include "tqlayout.h"

using namespace IpodExport;

IpodHeader::IpodHeader( TQWidget *parent, const char *name, WFlags f )
    : TQFrame( parent, name, f )
{
    TQVBoxLayout *layout = new TQVBoxLayout( this, 10/*margin*/, 5/*spacing*/ );

    setSizePolicy( TQSizePolicy::Expanding, TQSizePolicy::Minimum );

    m_messageLabel = new TQLabel( TQString(), this );
    m_messageLabel->setSizePolicy( TQSizePolicy::Expanding, TQSizePolicy::Minimum );

    TQHBoxLayout *buttonLayout = new TQHBoxLayout;
    m_button = new KPushButton( this );
    m_button->hide();

    buttonLayout->addStretch( 1 );
    buttonLayout->addWidget( m_button );
    buttonLayout->addStretch( 1 );

    layout->addWidget( m_messageLabel );
    layout->addLayout( buttonLayout );
}

void IpodHeader::setViewType( ViewType view )
{
    m_viewType = view;

    switch( view )
    {
        case NoIpod:
            setNoIpod();
            break;

        case IncompatibleIpod:
            setIncompatibleIpod();
            break;

        case ValidIpod:
            setValidIpod();
            break;

        default:
            break;
    }
}

void IpodHeader::setNoIpod()
{
    m_messageLabel->setText( i18n("<p align=\"center\"><b>No iPod was detected</b></p>" ) );

    setPaletteBackgroundColor( TQColor(147,18,18) );
    m_messageLabel->setPaletteBackgroundColor( TQColor(147,18,18) );
    m_messageLabel->setPaletteForegroundColor( TQt::white );

    m_button->setText( i18n( "Refresh" ) );
    m_button->show();

    m_button->disconnect();
    connect( m_button, TQ_SIGNAL( clicked() ), TQ_SIGNAL( refreshDevices() ) );
}

void IpodHeader::setIncompatibleIpod()
{
    const TQString modelType = UploadDialog::instance()->ipodModel();

    m_messageLabel->setText( i18n("<p align=\"center\"><b>Your iPod (%1) does not seem to support artwork.</b></p>" ).arg( modelType ) );

    setPaletteBackgroundColor( TQColor(225,150,0) );
    m_messageLabel->setPaletteBackgroundColor( TQColor(225,150,0)  );
    m_messageLabel->setPaletteForegroundColor( TQt::white );

    m_button->setText( i18n( "Set iPod Model" ) );
//     m_button->show();
    m_button->hide(); // FIXME its not implemented!

    m_button->disconnect();
    connect( m_button, TQ_SIGNAL( clicked() ), TQ_SIGNAL( updateSysInfo() ) );
}


void IpodHeader::setValidIpod()
{
    const TQString modelType  = UploadDialog::instance()->ipodModel();
    const TQString mountPoint = UploadDialog::instance()->mountPoint();

    if( !mountPoint.isEmpty() )
    {
        m_messageLabel->setText( i18n("<p align=\"center\"><b>iPod %1 detected at: %2</b></p>" )
                                 .arg( modelType, mountPoint ) );
    }
    else
    {
        m_messageLabel->setText( i18n("<p align=\"center\"><b>iPod %1 detected</b></p>" )
                                .arg( modelType ) );
    }
    setPaletteBackgroundColor( TQColor(0,98,0) );
    m_messageLabel->setPaletteBackgroundColor( TQColor(0,98,0) );
    m_messageLabel->setPaletteForegroundColor( TQt::white );

    m_button->hide();
}

