/***************************************************************************
*   Copyright (C) 2005 by Alexander Nemish  *
*   atlanter@gmail.com   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BOOKREADER_THEME_H
#define BOOKREADER_THEME_H

#include <tqstring.h>
#include <tqpixmap.h>


class Theme
{
public:
	static Theme * self();
	/// \brief Loads theme with given name. Default is "default". :)
	void loadTheme(const TQString& name = "default");
	const TQPixmap & bgPixmap(TQSize size = TQSize(0,0)) const;
	const TQPixmap & bookmarkPixmap() const { return m_bookmarkPixmap; }
	//const TQFont & font() const {return m_font;}
private:
	static Theme * theme;
	Theme();
	Theme(const Theme &);
	Theme & operator = (const Theme&);
	TQPixmap m_bgPixmap;
	mutable TQPixmap m_bgResizedPixmap;
	TQPixmap	m_bookmarkPixmap;
};

#endif
