// File autogenerated

// declaration include
#include "adapter1Proxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>
#include <tqstringlist.h>

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace org
{
namespace bluez
{

Adapter1Proxy::Adapter1Proxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.bluez.Adapter1");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

}

Adapter1Proxy::~Adapter1Proxy()
{
    delete m_baseProxy;
}

void Adapter1Proxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool Adapter1Proxy::StartDiscovery(TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("StartDiscovery", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool Adapter1Proxy::SetDiscoveryFilter(const TQMap< TQString, TQT_DBusVariant >& properties, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(properties));

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("SetDiscoveryFilter", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool Adapter1Proxy::StopDiscovery(TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("StopDiscovery", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool Adapter1Proxy::RemoveDevice(const TQT_DBusObjectPath& device, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromObjectPath(device);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("RemoveDevice", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

void Adapter1Proxy::setDBusProperty(const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Set");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);
    message << TQT_DBusData::fromVariant(value);

    connection.sendWithReply(message, &error);
}

TQT_DBusVariant Adapter1Proxy::getDBusProperty(const TQString& name, TQT_DBusError& error) const
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Get");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = connection.sendWithReply(message, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return TQT_DBusVariant();
    if (reply.count() != 1) return TQT_DBusVariant();

    bool ok = false;
    TQT_DBusVariant value = reply.front().toVariant(&ok);
    if (!ok) return TQT_DBusVariant();

    return value;
}

TQString Adapter1Proxy::getAddress(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Address", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQString Adapter1Proxy::getName(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Name", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

void Adapter1Proxy::setAlias(const TQString& value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromString(value);
    variant.signature = "s";

    setDBusProperty("Alias", variant, error);
}

TQString Adapter1Proxy::getAlias(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Alias", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 Adapter1Proxy::getClass(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Class", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

void Adapter1Proxy::setPowered(bool value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromBool(value);
    variant.signature = "b";

    setDBusProperty("Powered", variant, error);
}

bool Adapter1Proxy::getPowered(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Powered", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

void Adapter1Proxy::setDiscoverable(bool value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromBool(value);
    variant.signature = "b";

    setDBusProperty("Discoverable", variant, error);
}

bool Adapter1Proxy::getDiscoverable(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Discoverable", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

void Adapter1Proxy::setDiscoverableTimeout(TQ_UINT32 value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromUInt32(value);
    variant.signature = "u";

    setDBusProperty("DiscoverableTimeout", variant, error);
}

TQ_UINT32 Adapter1Proxy::getDiscoverableTimeout(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("DiscoverableTimeout", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

void Adapter1Proxy::setPairable(bool value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromBool(value);
    variant.signature = "b";

    setDBusProperty("Pairable", variant, error);
}

bool Adapter1Proxy::getPairable(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Pairable", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

void Adapter1Proxy::setPairableTimeout(TQ_UINT32 value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromUInt32(value);
    variant.signature = "u";

    setDBusProperty("PairableTimeout", variant, error);
}

TQ_UINT32 Adapter1Proxy::getPairableTimeout(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("PairableTimeout", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

bool Adapter1Proxy::getDiscovering(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Discovering", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

TQStringList Adapter1Proxy::getUUIDs(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("UUIDs", error);

    if (error.isValid()) return TQStringList();

    bool ok = false;

    bool subOK = false;

    TQStringList result =  variant.value.toList(&ok).toTQStringList(&subOK);
    if (!subOK) {}
    if (!ok) {}

    return result;
}

TQString Adapter1Proxy::getModalias(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Modalias", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

}; // namespace bluez

}; // namespace org

#include "adapter1Proxy.moc"

// End of File

