// #### Do not edit: this file is autogenerated !!!

#include "devices/list/device_list.h"
#include "pickit2.h"
#include "pickit2_data.h"
#include "pickit2_prog.h"

namespace Pickit2
{
struct CData {
  const char *name;
  uint family;
  uint support;
  Data data;
};

const CData PIC10F200_DATA = {  "10F200", 0, 2, { 'O', '0', 0, false } };
const CData PIC10F202_DATA = {  "10F202", 0, 2, { 'O', '0', 0, false } };
const CData PIC10F204_DATA = {  "10F204", 0, 2, { 'O', '0', 0, false } };
const CData PIC10F206_DATA = {  "10F206", 0, 2, { 'O', '0', 0, false } };
const CData PIC10F220_DATA = {  "10F220", 0, 1, { 'O', '0', 0, false } };
const CData PIC10F222_DATA = {  "10F222", 0, 1, { 'O', '0', 0, false } };
const CData PIC12F508_DATA = {  "12F508", 0, 2, { 'O', '0', 0, false } };
const CData PIC12F509_DATA = {  "12F509", 0, 2, { 'O', '0', 0, false } };
const CData PIC12F510_DATA = {  "12F510", 0, 2, { 'O', '0', 0, false } };
const CData PIC12F615_DATA = {  "12F615", 1, 2, { 'P', 'n', 1, false } };
const CData PIC12F629_DATA = {  "12F629", 1, 2, { 'P', '1', 0, true } };
const CData PIC12F635_DATA = {  "12F635", 1, 2, { 'P', '4', 0, false } };
const CData PIC12F675_DATA = {  "12F675", 1, 2, { 'P', '1', 0, true } };
const CData PIC12F683_DATA = {  "12F683", 1, 2, { 'P', '4', 0, false } };
const CData PIC16F505_DATA = {  "16F505", 0, 1, { 'O', '0', 0, false } };
const CData PIC16F506_DATA = {  "16F506", 0, 1, { 'O', '0', 0, false } };
const CData PIC16F54_DATA = {  "16F54", 0, 1, { 'O', '0', 0, false } };
const CData PIC16F57_DATA = {  "16F57", 0, 1, { 'O', '0', 0, false } };
const CData PIC16F59_DATA = {  "16F59", 0, 1, { 'O', '0', 0, false } };
const CData PIC16F616_DATA = {  "16F616", 1, 2, { 'P', 'n', 4, false } };
const CData PIC16F627A_DATA = {  "16F627A", 1, 2, { 'P', '1', 0, false } };
const CData PIC16F628A_DATA = {  "16F628A", 1, 2, { 'P', '1', 0, false } };
const CData PIC16F630_DATA = {  "16F630", 1, 2, { 'P', '1', 0, true } };
const CData PIC16F631_DATA = {  "16F631", 1, 2, { 'P', '1', 0, false } };
const CData PIC16F636_DATA = {  "16F636", 1, 2, { 'P', '4', 0, false } };
const CData PIC16F639_DATA = {  "16F639", 1, 2, { 'P', '1', 0, false } };
const CData PIC16F648A_DATA = {  "16F648A", 1, 2, { 'P', '1', 0, false } };
const CData PIC16F676_DATA = {  "16F676", 1, 2, { 'P', '1', 0, true } };
const CData PIC16F677_DATA = {  "16F677", 1, 2, { 'P', '1', 0, false } };
const CData PIC16F684_DATA = {  "16F684", 1, 2, { 'P', '4', 0, false } };
const CData PIC16F685_DATA = {  "16F685", 1, 2, { 'P', '4', 0, false } };
const CData PIC16F687_DATA = {  "16F687", 1, 2, { 'P', '4', 0, false } };
const CData PIC16F688_DATA = {  "16F688", 1, 2, { 'P', '4', 0, false } };
const CData PIC16F689_DATA = {  "16F689", 1, 2, { 'P', '4', 0, false } };
const CData PIC16F690_DATA = {  "16F690", 1, 2, { 'P', '4', 0, false } };
const CData PIC16F716_DATA = {  "16F716", 2, 1, { 'O', '4', 0, false } };
const CData PIC16F73_DATA = {  "16F73", 3, 1, { 'O', 'n', 2, false } };
const CData PIC16F737_DATA = {  "16F737", 3, 1, { 'O', 'n', 2, false } };
const CData PIC16F74_DATA = {  "16F74", 3, 1, { 'O', 'n', 2, false } };
const CData PIC16F747_DATA = {  "16F747", 3, 1, { 'O', 'n', 2, false } };
const CData PIC16F76_DATA = {  "16F76", 3, 1, { 'O', 'n', 2, false } };
const CData PIC16F767_DATA = {  "16F767", 3, 1, { 'O', 'n', 2, false } };
const CData PIC16F77_DATA = {  "16F77", 3, 1, { 'O', 'n', 2, false } };
const CData PIC16F777_DATA = {  "16F777", 3, 1, { 'O', 'n', 2, false } };
const CData PIC16F785_DATA = {  "16F785", 1, 1, { 'P', '4', 0, false } };
const CData PIC16F818_DATA = {  "16F818", 4, 2, { 'O', 'n', 4, false } };
const CData PIC16F819_DATA = {  "16F819", 4, 2, { 'O', 'n', 4, false } };
const CData PIC16F87_DATA = {  "16F87", 4, 1, { 'O', 'n', 4, false } };
const CData PIC16F873_DATA = {  "16F873", 1, 1, { 'O', 'n', 8, false } };
const CData PIC16F873A_DATA = {  "16F873A", 4, 2, { 'O', 'n', 8, false } };
const CData PIC16F874_DATA = {  "16F874", 1, 1, { 'O', 'n', 8, false } };
const CData PIC16F874A_DATA = {  "16F874A", 4, 2, { 'O', 'n', 8, false } };
const CData PIC16F876_DATA = {  "16F876", 1, 1, { 'O', 'n', 8, false } };
const CData PIC16F876A_DATA = {  "16F876A", 4, 2, { 'O', 'n', 8, false } };
const CData PIC16F877_DATA = {  "16F877", 1, 1, { 'O', 'n', 8, false } };
const CData PIC16F877A_DATA = {  "16F877A", 4, 2, { 'O', 'n', 8, false } };
const CData PIC16F88_DATA = {  "16F88", 4, 1, { 'O', 'n', 4, false } };
const CData PIC16F913_DATA = {  "16F913", 1, 2, { 'O', 'n', 4, false } };
const CData PIC16F914_DATA = {  "16F914", 1, 2, { 'O', 'n', 4, false } };
const CData PIC16F916_DATA = {  "16F916", 1, 2, { 'O', 'n', 8, false } };
const CData PIC16F917_DATA = {  "16F917", 1, 2, { 'O', 'n', 8, false } };
const CData PIC16F946_DATA = {  "16F946", 1, 1, { 'O', 'n', 8, false } };
const CData PIC18F1220_DATA = {  "18F1220", 5, 1, { 'O', 'n', 4, false } };
const CData PIC18F1320_DATA = {  "18F1320", 5, 1, { 'O', 'n', 4, false } };
const CData PIC18F2220_DATA = {  "18F2220", 5, 1, { 'P', 'n', 4, false } };
const CData PIC18F2221_DATA = {  "18F2221", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2320_DATA = {  "18F2320", 5, 1, { 'P', 'n', 4, false } };
const CData PIC18F2321_DATA = {  "18F2321", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2410_DATA = {  "18F2410", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2420_DATA = {  "18F2420", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2455_DATA = {  "18F2455", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2480_DATA = {  "18F2480", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2510_DATA = {  "18F2510", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2515_DATA = {  "18F2515", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2520_DATA = {  "18F2520", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2525_DATA = {  "18F2525", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2550_DATA = {  "18F2550", 6, 2, { 'P', 'n', 16, false } };
const CData PIC18F2580_DATA = {  "18F2580", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2585_DATA = {  "18F2585", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2610_DATA = {  "18F2610", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2620_DATA = {  "18F2620", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F2680_DATA = {  "18F2680", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4220_DATA = {  "18F4220", 5, 1, { 'P', 'n', 4, false } };
const CData PIC18F4221_DATA = {  "18F4221", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4320_DATA = {  "18F4320", 5, 1, { 'P', 'n', 4, false } };
const CData PIC18F4321_DATA = {  "18F4321", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4410_DATA = {  "18F4410", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4420_DATA = {  "18F4420", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4455_DATA = {  "18F4455", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4480_DATA = {  "18F4480", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4510_DATA = {  "18F4510", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4515_DATA = {  "18F4515", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4520_DATA = {  "18F4520", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4525_DATA = {  "18F4525", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4550_DATA = {  "18F4550", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4580_DATA = {  "18F4580", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4585_DATA = {  "18F4585", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4610_DATA = {  "18F4610", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4620_DATA = {  "18F4620", 6, 1, { 'P', 'n', 16, false } };
const CData PIC18F4680_DATA = {  "18F4680", 6, 1, { 'P', 'n', 16, false } };

const CData *DATA_LIST[] = {
&PIC10F200_DATA,&PIC10F202_DATA,&PIC10F204_DATA,&PIC10F206_DATA,&PIC10F220_DATA,&PIC10F222_DATA,&PIC12F508_DATA,&PIC12F509_DATA,&PIC12F510_DATA,&PIC12F615_DATA,
&PIC12F629_DATA,&PIC12F635_DATA,&PIC12F675_DATA,&PIC12F683_DATA,&PIC16F505_DATA,&PIC16F506_DATA,&PIC16F54_DATA,&PIC16F57_DATA,&PIC16F59_DATA,&PIC16F616_DATA,
&PIC16F627A_DATA,&PIC16F628A_DATA,&PIC16F630_DATA,&PIC16F631_DATA,&PIC16F636_DATA,&PIC16F639_DATA,&PIC16F648A_DATA,&PIC16F676_DATA,&PIC16F677_DATA,&PIC16F684_DATA,
&PIC16F685_DATA,&PIC16F687_DATA,&PIC16F688_DATA,&PIC16F689_DATA,&PIC16F690_DATA,&PIC16F716_DATA,&PIC16F73_DATA,&PIC16F737_DATA,&PIC16F74_DATA,&PIC16F747_DATA,
&PIC16F76_DATA,&PIC16F767_DATA,&PIC16F77_DATA,&PIC16F777_DATA,&PIC16F785_DATA,&PIC16F818_DATA,&PIC16F819_DATA,&PIC16F87_DATA,&PIC16F873_DATA,&PIC16F873A_DATA,
&PIC16F874_DATA,&PIC16F874A_DATA,&PIC16F876_DATA,&PIC16F876A_DATA,&PIC16F877_DATA,&PIC16F877A_DATA,&PIC16F88_DATA,&PIC16F913_DATA,&PIC16F914_DATA,&PIC16F916_DATA,
&PIC16F917_DATA,&PIC16F946_DATA,&PIC18F1220_DATA,&PIC18F1320_DATA,&PIC18F2220_DATA,&PIC18F2221_DATA,&PIC18F2320_DATA,&PIC18F2321_DATA,&PIC18F2410_DATA,&PIC18F2420_DATA,
&PIC18F2455_DATA,&PIC18F2480_DATA,&PIC18F2510_DATA,&PIC18F2515_DATA,&PIC18F2520_DATA,&PIC18F2525_DATA,&PIC18F2550_DATA,&PIC18F2580_DATA,&PIC18F2585_DATA,&PIC18F2610_DATA,
&PIC18F2620_DATA,&PIC18F2680_DATA,&PIC18F4220_DATA,&PIC18F4221_DATA,&PIC18F4320_DATA,&PIC18F4321_DATA,&PIC18F4410_DATA,&PIC18F4420_DATA,&PIC18F4455_DATA,&PIC18F4480_DATA,
&PIC18F4510_DATA,&PIC18F4515_DATA,&PIC18F4520_DATA,&PIC18F4525_DATA,&PIC18F4550_DATA,&PIC18F4580_DATA,&PIC18F4585_DATA,&PIC18F4610_DATA,&PIC18F4620_DATA,&PIC18F4680_DATA,
0 
};

const CData *cdata(const TQString &device)
{
  for(uint i=0; DATA_LIST[i]; i++)
    if ( device==DATA_LIST[i]->name ) return DATA_LIST[i];
  return 0;
}
bool isSupported(const TQString &device)
{
  return cdata(device);
}
uint family(const TQString &device)
{
  return cdata(device)->family;
}
::Group::Support support(const TQString &device)
{
  return ::Group::Support::Type(cdata(device)->support);
}
const Data &data(const TQString &device)
{
  return cdata(device)->data;
}

void Group::initSupported()
{
  for (uint i=0; DATA_LIST[i]; i++) {
    const Device::Data *data = Device::lister().data(DATA_LIST[i]->name);
    addDevice(data->name(), data, ::Group::Support::Type(DATA_LIST[i]->support));
  }
}

::Programmer::DeviceSpecific *Group::createDeviceSpecific(::Programmer::Base &base) const
{
  uint i = family(static_cast< ::Pickit2::Base &>(base).device()->name());
  switch(i) {
    case 0: return new Baseline(base);
    case 1: return new P16F(base);
    case 2: return new P16F716(base);
    case 3: return new P16F7X(base);
    case 4: return new P16F87XA(base);
    case 5: return new P18F2X20(base);
    case 6: return new P18F(base);
  }
  Q_ASSERT(false);
  return 0;
}

}
