/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.background;

import java.util.Date;
import net.ripe.rpki.rtr.background.DisconnectInactiveClientsJob;
import net.ripe.rpki.rtr.background.ExpireOldDeltasJob;
import net.ripe.rpki.rtr.background.RefreshObjectCacheJob;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackgroundJobs {
    private static final Logger log = LoggerFactory.getLogger(BackgroundJobs.class);
    private final Scheduler scheduler;

    @Autowired
    public BackgroundJobs(Scheduler scheduler) throws SchedulerException {
        this.scheduler = scheduler;
        this.schedule(ExpireOldDeltasJob.class, DateBuilder.futureDate((int)10, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND), (ScheduleBuilder)SimpleScheduleBuilder.repeatMinutelyForever());
        this.schedule(DisconnectInactiveClientsJob.class, DateBuilder.futureDate((int)20, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND), (ScheduleBuilder)SimpleScheduleBuilder.repeatMinutelyForever());
        this.schedule(RefreshObjectCacheJob.class, DateBuilder.futureDate((int)10, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND), (ScheduleBuilder)SimpleScheduleBuilder.repeatMinutelyForever().withMisfireHandlingInstructionIgnoreMisfires());
    }

    private <T extends Trigger> void schedule(Class<? extends Job> jobClass, Date startAt, ScheduleBuilder<T> schedule) throws SchedulerException {
        JobKey jobKey = JobKey.jobKey((String)jobClass.getName());
        if (this.scheduler.checkExists(jobKey)) {
            this.scheduler.deleteJob(jobKey);
        }
        this.scheduler.scheduleJob(JobBuilder.newJob(jobClass).withIdentity(jobKey).build(), TriggerBuilder.newTrigger().withIdentity(jobKey + "-Trigger").startAt(startAt).withSchedule(schedule).build());
        log.info(String.format("Scheduled '%s', starting from '%s'", jobKey, startAt));
    }
}

