/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.adapter.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import java.util.Iterator;
import java.util.stream.Stream;

public class ChunkedStream<T>
implements ChunkedInput<T> {
    private final Iterator<T> items;
    private int progress = 0;

    public ChunkedStream(Stream<T> items) {
        this.items = items.iterator();
    }

    public boolean isEndOfInput() throws Exception {
        return !this.items.hasNext();
    }

    public void close() throws Exception {
    }

    @Deprecated
    public T readChunk(ChannelHandlerContext ctx) throws Exception {
        return (T)this.readChunk(ctx.alloc());
    }

    public T readChunk(ByteBufAllocator allocator) throws Exception {
        if (this.isEndOfInput()) {
            return null;
        }
        ++this.progress;
        return (T)this.items.next();
    }

    public long length() {
        return -1L;
    }

    public long progress() {
        return this.progress;
    }
}

