/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.SocketAddressResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

/*
 * Exception performing whole class analysis ignored.
 */
public class HappyEyeballsResolver
implements SocketAddressResolver {
    private static final Logger log = LoggerFactory.getLogger(HappyEyeballsResolver.class);
    private static final long RESOLUTION_DELAY_MILLIS = 50L;
    private static final long CONNECTION_ATTEMPT_DELAY_MILLIS = 250L;
    public static final long HAPPY_EYEBALLS_TOTAL_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(10L);
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("\\d{1,3}(?:\\.\\d{1,3}){3}");
    private static final Pattern IPV6_ADDRESS_PATTERN = Pattern.compile("( [0-9A-Fa-f:.]+ (?: % [0-9A-Za-z][-0-9A-Za-z_\\ ]*)? )", 4);
    private final HttpClient httpClient;

    public HappyEyeballsResolver(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void resolve(String host, int port, Promise<List<InetSocketAddress>> promise) {
        Optional literalIpAddress = this.isLiteralIpAddress(host);
        if (literalIpAddress.isPresent()) {
            this.completePromise((String)literalIpAddress.get(), port, promise);
        } else {
            this.resolveAsynchronously(host, port, promise);
        }
    }

    Optional<String> isLiteralIpAddress(String host) {
        Matcher matcher;
        if (this.isLiteralV4Address(host)) {
            return Optional.of(host);
        }
        if (host.contains(":") && (matcher = IPV6_ADDRESS_PATTERN.matcher(host)).matches()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    private boolean isLiteralV4Address(String host) {
        return IPV4_ADDRESS_PATTERN.matcher(host).matches();
    }

    private void completePromise(String ipAddress, int port, Promise<List<InetSocketAddress>> promise) {
        try {
            InetAddress inetAddress = InetAddress.getByName(ipAddress);
            InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, port);
            promise.succeeded(Collections.singletonList(socketAddress));
        }
        catch (Exception e) {
            log.error("Error creating socket for " + ipAddress, (Throwable)e);
            promise.failed((Throwable)e);
        }
    }

    private void resolveAsynchronously(String host, int port, Promise<List<InetSocketAddress>> promise) {
        Executor executor = this.httpClient.getExecutor();
        executor.execute(() -> {
            block11: {
                Selector selector = null;
                try {
                    Optional bestAddress;
                    Name hostname = Name.fromString((String)host);
                    ConcurrentLinkedQueue resolvedAddressesV6 = new ConcurrentLinkedQueue();
                    executor.execute(HappyEyeballsResolver.dnsLookupRunnable((Name)hostname, (int)28, resolvedAddressesV6));
                    ConcurrentLinkedQueue resolvedAddressesV4 = new ConcurrentLinkedQueue();
                    executor.execute(HappyEyeballsResolver.dnsLookupRunnable((Name)hostname, (int)1, resolvedAddressesV4));
                    HappyEyeballsResolver.awaitDnsResponses(resolvedAddressesV6, resolvedAddressesV4);
                    if (log.isInfoEnabled()) {
                        log.info("Resolved v6 addresses: {} for host {}", this.joinAddresses(resolvedAddressesV6), (Object)host);
                        log.info("Resolved v4 addresses: {} for host {}", this.joinAddresses(resolvedAddressesV4), (Object)host);
                    }
                    if ((bestAddress = HappyEyeballsResolver.findBestAddress(resolvedAddressesV6, resolvedAddressesV4, (int)port, (Selector)(selector = Selector.open()))).isPresent()) {
                        promise.succeeded(Collections.singletonList((InetSocketAddress)bestAddress.get()));
                    } else {
                        promise.failed((Throwable)new IOException("Could not connect to " + host));
                    }
                    if (selector == null || !selector.isOpen()) break block11;
                }
                catch (Exception e) {
                    log.warn(String.format("Error during lookup in happy eyeballs resolver for %s:%s", host, port), (Throwable)e);
                    promise.failed((Throwable)e);
                    break block11;
                }
                finally {
                    if (selector != null && selector.isOpen()) {
                        for (SelectionKey key : selector.keys()) {
                            HappyEyeballsResolver.closeAnyway((Closeable)key.channel());
                        }
                        HappyEyeballsResolver.closeAnyway((Closeable)selector);
                    }
                }
                for (SelectionKey key : selector.keys()) {
                    HappyEyeballsResolver.closeAnyway((Closeable)key.channel());
                }
                HappyEyeballsResolver.closeAnyway((Closeable)selector);
            }
        });
    }

    private static void closeAnyway(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object joinAddresses(ConcurrentLinkedQueue<Optional<InetAddress>> resolvedAddressesV6) {
        return resolvedAddressesV6.stream().filter(Optional::isPresent).map(Optional::get).map(InetAddress::getHostAddress).collect(Collectors.joining(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<SocketAddress> awaitSuccessfulConnection(Selector selector, long selectTimeout) {
        int count = 0;
        try {
            count = selectTimeout > 0L ? selector.select(selectTimeout) : selector.selectNow();
        }
        catch (IOException e) {
            log.warn("Error awaiting for connect: ", (Throwable)e);
        }
        if (count > 0) {
            Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey key = iterator.next();
                SocketChannel socketChannel = (SocketChannel)key.channel();
                try {
                    if (!socketChannel.finishConnect()) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("Successfully connected to: {}", (Object)socketChannel.getRemoteAddress());
                    }
                    Optional<SocketAddress> optional = Optional.ofNullable(socketChannel.getRemoteAddress());
                    return optional;
                }
                catch (IOException e) {
                    if (log.isTraceEnabled()) {
                        try {
                            log.trace("Error connecting to " + socketChannel.getRemoteAddress(), (Throwable)e);
                        }
                        catch (IOException ex) {
                            log.trace("Error connecting: ", (Throwable)e);
                        }
                    }
                    HappyEyeballsResolver.closeAnyway((Closeable)socketChannel);
                }
                finally {
                    iterator.remove();
                }
            }
        }
        return Optional.empty();
    }

    private static void awaitDnsResponses(ConcurrentLinkedQueue<Optional<InetAddress>> resolvedAddressesV6, ConcurrentLinkedQueue<Optional<InetAddress>> resolvedAddressesV4) {
        long startTime = System.nanoTime();
        long sleepDeadline = startTime + TimeUnit.MILLISECONDS.toNanos(100L);
        boolean keepGoing = true;
        while (resolvedAddressesV6.isEmpty() && keepGoing) {
            if (!resolvedAddressesV4.isEmpty()) {
                long deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(50L);
                while (HappyEyeballsResolver.haveTime((long)deadline) && resolvedAddressesV6.isEmpty()) {
                }
                keepGoing = false;
            }
            if (HappyEyeballsResolver.haveTime((long)sleepDeadline)) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException ignored) {
                keepGoing = false;
            }
        }
    }

    private static boolean haveTime(long nanoDeadline) {
        return System.nanoTime() - nanoDeadline < 0L;
    }

    private static Runnable dnsLookupRunnable(Name hostname, int queryType, Queue<Optional<InetAddress>> resolvedAddresses) {
        return () -> {
            try {
                Lookup lookup = new Lookup(hostname, queryType, 1);
                Record[] records = lookup.run();
                if (records != null) {
                    for (Record record : records) {
                        InetAddress address = null;
                        if (record instanceof AAAARecord) {
                            address = ((AAAARecord)record).getAddress();
                        } else if (record instanceof ARecord) {
                            address = ((ARecord)record).getAddress();
                        }
                        if (address == null) continue;
                        resolvedAddresses.add(Optional.of(address));
                    }
                }
            }
            finally {
                resolvedAddresses.add(Optional.empty());
            }
        };
    }

    private static Optional<SocketAddress> findBestAddress(Queue<Optional<InetAddress>> firstAfAddresses, Queue<Optional<InetAddress>> secondAfAddresses, int port, Selector selector) {
        long startTime = System.nanoTime();
        long deadline = startTime + HAPPY_EYEBALLS_TOTAL_TIMEOUT_NANOS;
        boolean keepGoing = true;
        while (keepGoing && !Thread.currentThread().isInterrupted()) {
            boolean haveMoreAF1 = HappyEyeballsResolver.openConnectionFromQueue(firstAfAddresses, (int)port, (Selector)selector);
            Optional connectedSocket = HappyEyeballsResolver.awaitSuccessfulConnection((Selector)selector, (long)250L);
            if (connectedSocket.isPresent()) {
                return connectedSocket;
            }
            boolean haveMoreAF2 = HappyEyeballsResolver.openConnectionFromQueue(secondAfAddresses, (int)port, (Selector)selector);
            connectedSocket = HappyEyeballsResolver.awaitSuccessfulConnection((Selector)selector, (long)250L);
            if (connectedSocket.isPresent()) {
                return connectedSocket;
            }
            keepGoing = (haveMoreAF1 || haveMoreAF2) && HappyEyeballsResolver.haveTime((long)deadline);
        }
        if (selector.keys().isEmpty()) {
            return Optional.empty();
        }
        long remainingTime = Math.max(0L, deadline - System.nanoTime());
        return HappyEyeballsResolver.awaitSuccessfulConnection((Selector)selector, (long)TimeUnit.NANOSECONDS.toMillis(remainingTime));
    }

    private static boolean openConnectionFromQueue(Queue<Optional<InetAddress>> queue, int port, Selector selector) {
        Optional<InetAddress> addressOptional = queue.poll();
        if (addressOptional != null) {
            if (addressOptional.isPresent()) {
                InetAddress address = addressOptional.get();
                try {
                    if (log.isTraceEnabled()) {
                        log.trace("Connecting to {}", (Object)address);
                    }
                    SocketChannel socketChannel = SocketChannel.open();
                    socketChannel.configureBlocking(false);
                    socketChannel.register(selector, 8);
                    socketChannel.connect(new InetSocketAddress(address, port));
                }
                catch (IOException e) {
                    if (log.isTraceEnabled()) {
                        log.trace("Error connecting to {}", (Object)address);
                    }
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

