/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.stores.impl;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.api.util.InstantWithoutNanos;
import net.ripe.rpki.validator3.storage.IxMap;
import net.ripe.rpki.validator3.storage.MultIxMap;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Base;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.CertificateTreeValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.RpkiRepositoryValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.RrdpRepositoryValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.RsyncRepositoryValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.TrustAnchorValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.ValidationCheck;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.CoderFactory;
import net.ripe.rpki.validator3.storage.stores.RpkiObjects;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import net.ripe.rpki.validator3.storage.stores.impl.SequencesStore;
import net.ripe.rpki.validator3.storage.stores.impl.ValidationRunsStore;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ValidationRunsStore
implements ValidationRuns {
    private static final Logger log = LoggerFactory.getLogger(ValidationRunsStore.class);
    private static final String RPKI_VALIDATION_RUNS = "validation-runs";
    private static final String CT_RPKI_VALIDATION_RUNS = "certificate-tree-validation-runs";
    private static final String RS_RPKI_VALIDATION_RUNS = "rsync-repository-validation-runs";
    private static final String RR_RPKI_VALIDATION_RUNS = "rrdp-repository-validation-runs";
    private static final String TA_RPKI_VALIDATION_RUNS = "trust-anchor-validation-runs";
    private static final String VALIDATION_RUNS_TO_RPKI_OBJECTS = "validation-runs-to-rpki-objects";
    private static final String VALIDATION_RUNS_TO_RPKI_REPOSITORIES = "validation-runs-to-repositories";
    private static final String BY_TA_INDEX = "by-ta";
    private static final String BY_COMPLETED_AT_INDEX = "by-completed-at";
    private MultIxMap<Key> vr2ro;
    private IxMap<Key> vr2repo;
    private IxMap<CertificateTreeValidationRun> ctIxMap;
    private IxMap<RsyncRepositoryValidationRun> rsIxMap;
    private IxMap<RrdpRepositoryValidationRun> rrIxMap;
    private IxMap<TrustAnchorValidationRun> taIxMap;
    private final Map<String, IxMap<? extends ValidationRun>> maps = new HashMap();
    private final RpkiObjects rpkiObjects;
    private final RpkiRepositories rpkiRepositories;
    private final TrustAnchors trustAnchors;
    private final SequencesStore sequences;

    public ValidationRunsStore(RpkiObjects rpkiObjects, @Lazy TrustAnchors trustAnchors, RpkiRepositories rpkiRepositories, SequencesStore sequences, Storage storage) {
        this.rpkiObjects = rpkiObjects;
        this.rpkiRepositories = rpkiRepositories;
        this.trustAnchors = trustAnchors;
        this.sequences = sequences;
        this.ctIxMap = storage.createIxMap(CT_RPKI_VALIDATION_RUNS, (Map)ImmutableMap.of((Object)BY_TA_INDEX, vr -> Key.keys((Key)vr.getTrustAnchor().key()), (Object)BY_COMPLETED_AT_INDEX, arg_0 -> this.completedAtIndexKeys(arg_0)), CertificateTreeValidationRun.class);
        this.taIxMap = storage.createIxMap(TA_RPKI_VALIDATION_RUNS, (Map)ImmutableMap.of((Object)BY_TA_INDEX, vr -> Key.keys((Key)vr.getTrustAnchor().key()), (Object)BY_COMPLETED_AT_INDEX, arg_0 -> this.completedAtIndexKeys(arg_0)), TrustAnchorValidationRun.class);
        this.rsIxMap = storage.createIxMap(RS_RPKI_VALIDATION_RUNS, (Map)ImmutableMap.of((Object)BY_COMPLETED_AT_INDEX, arg_0 -> this.completedAtIndexKeys(arg_0)), RsyncRepositoryValidationRun.class);
        this.rrIxMap = storage.createIxMap(RR_RPKI_VALIDATION_RUNS, (Map)ImmutableMap.of((Object)BY_COMPLETED_AT_INDEX, arg_0 -> this.completedAtIndexKeys(arg_0)), RrdpRepositoryValidationRun.class);
        this.maps.put("certificate-tree-validation-run", this.ctIxMap);
        this.maps.put("trust-anchor-validation-run", this.taIxMap);
        this.maps.put("rsync-repository-validation-run", this.rsIxMap);
        this.maps.put("rrdp-repository-validation-run", this.rrIxMap);
        Coder keyCoder = CoderFactory.keyCoder();
        this.vr2ro = storage.createMultIxMap(VALIDATION_RUNS_TO_RPKI_OBJECTS, keyCoder);
        this.vr2repo = storage.createIxMap(VALIDATION_RUNS_TO_RPKI_REPOSITORIES, Collections.emptyMap(), keyCoder);
        trustAnchors.onDelete((arg_0, arg_1) -> this.removeAllForTrustAnchor(arg_0, arg_1));
        this.maps.values().forEach(ixMap -> ixMap.onDelete((tx, vrKey) -> {
            this.vr2ro.delete(tx, vrKey);
            this.vr2repo.delete(tx, vrKey);
        }));
    }

    private Set<Key> completedAtIndexKeys(ValidationRun vr) {
        InstantWithoutNanos completedAt = vr.getCompletedAt();
        return completedAt != null ? Key.keys((Key)Key.of((long)completedAt.toEpochMilli())) : Collections.emptySet();
    }

    public <T extends ValidationRun> T add(Tx.Write tx, T vr) {
        vr.setId(Key.of((long)this.sequences.next(tx, "validation-runs:pk")));
        this.pickIxMap(vr.getType()).put(tx, vr.key(), vr);
        return vr;
    }

    public <T extends ValidationRun> void update(Tx.Write tx, T vr) {
        vr.setUpdatedAt(InstantWithoutNanos.now());
        this.pickIxMap(vr.getType()).put(tx, vr.key(), vr);
    }

    public <T extends ValidationRun> Optional<T> get(Tx.Read tx, Class<T> type, long id) {
        return this.pickIxMaps(type).stream().map(ixMap -> ixMap.get(tx, Key.of((long)id))).filter(Optional::isPresent).findFirst().map(validationRun -> (ValidationRun)validationRun.get());
    }

    public <T extends ValidationRun> List<T> findAll(Tx.Read tx) {
        ArrayList result = new ArrayList();
        this.maps.values().forEach(ixMap -> ixMap.forEach(tx, (k, bb) -> result.add((ValidationRun)ixMap.toValue(bb))));
        return result;
    }

    public <T extends ValidationRun> List<T> findAll(Tx.Read tx, Class<T> type) {
        ArrayList result = new ArrayList();
        this.pickIxMaps(type).forEach(ixMap -> ixMap.forEach(tx, (k, bb) -> result.add((ValidationRun)ixMap.toValue(bb))));
        return result;
    }

    public <T extends ValidationRun> List<T> findLatestSuccessful(Tx.Read tx, Class<T> type) {
        ArrayList result = new ArrayList();
        List ixMaps = this.pickIxMaps(type);
        ixMaps.forEach(ixMap -> ixMap.getByIdxDescendingWhere(BY_COMPLETED_AT_INDEX, tx, ValidationRun::isSucceeded).forEach((k, v) -> result.add(v)));
        return result;
    }

    public Optional<CertificateTreeValidationRun> findLatestSuccessfulCaTreeValidationRun(Tx.Read tx, TrustAnchor trustAnchor) {
        return this.ctIxMap.getByIdxDescendingWhere(BY_COMPLETED_AT_INDEX, tx, vr -> vr.isSucceeded() && trustAnchor.key().equals((Object)vr.getTrustAnchor().key())).values().stream().findFirst();
    }

    public Optional<TrustAnchorValidationRun> findLatestCompletedForTrustAnchor(Tx.Read tx, TrustAnchor trustAnchor) {
        return this.taIxMap.getByIdxDescendingWhere(BY_COMPLETED_AT_INDEX, tx, vr -> trustAnchor.key().equals((Object)vr.getTrustAnchor().key())).values().stream().findFirst();
    }

    public Optional<CertificateTreeValidationRun> findLatestCompletedCaTreeValidationRun(Tx.Read tx, TrustAnchor trustAnchor) {
        return this.ctIxMap.getByIdxDescendingWhere(BY_COMPLETED_AT_INDEX, tx, vr -> trustAnchor.key().equals((Object)vr.getTrustAnchor().key())).values().stream().findFirst();
    }

    private void removeAllForTrustAnchor(Tx.Write tx, Key trustAnchorKey) {
        Stream.of(this.taIxMap, this.ctIxMap).forEach(ixMap -> ixMap.getPkByIndex(BY_TA_INDEX, (Tx.Read)tx, trustAnchorKey).forEach(pk -> ixMap.delete(tx, pk)));
    }

    public int removeOldValidationRuns(Tx.Write tx, InstantWithoutNanos completedBefore) {
        AtomicInteger count = new AtomicInteger(0);
        Set taKeys = this.trustAnchors.keys((Tx.Read)tx);
        this.maps.forEach((type, ixMap) -> {
            Set latestSuccessfulKeys = taKeys.stream().flatMap(taKey -> ixMap.getByIdxDescendingWhere(BY_COMPLETED_AT_INDEX, (Tx.Read)tx, vr -> {
                if (vr instanceof CertificateTreeValidationRun) {
                    return taKey.equals((Object)((CertificateTreeValidationRun)vr).getTrustAnchor().key()) && vr.isSucceeded();
                }
                if (vr instanceof TrustAnchorValidationRun) {
                    return taKey.equals((Object)((TrustAnchorValidationRun)vr).getTrustAnchor().key()) && vr.isSucceeded();
                }
                return vr.isSucceeded();
            }).keySet().stream()).collect(Collectors.toSet());
            HashSet toDelete = new HashSet();
            ixMap.forEach((Tx.Read)tx, (k, bytes) -> {
                ValidationRun validationRun = (ValidationRun)ixMap.toValue(bytes);
                boolean deleteIt = false;
                if (validationRun.getCompletedAt() != null) {
                    if (validationRun.getCompletedAt().isBefore(completedBefore)) {
                        deleteIt = true;
                    }
                } else if (validationRun.getUpdatedAt() != null && validationRun.getUpdatedAt().isBefore(completedBefore)) {
                    deleteIt = true;
                } else if (validationRun.getCreatedAt().isBefore(completedBefore)) {
                    deleteIt = true;
                }
                if (deleteIt && !latestSuccessfulKeys.contains(k)) {
                    toDelete.add(k);
                }
            });
            toDelete.forEach(pk -> ixMap.delete(tx, pk));
            count.addAndGet(toDelete.size());
        });
        return count.get();
    }

    public int removeOrphanValidationRunAssociations(Tx.Write tx) {
        Set roKeys = this.rpkiObjects.keys((Tx.Read)tx);
        Set repoKeys = this.rpkiRepositories.keys((Tx.Read)tx);
        ArrayList toDelete = new ArrayList();
        this.vr2ro.forEach((Tx.Read)tx, (vrKey, bytes) -> {
            Key roKey = (Key)this.vr2ro.toValue(bytes);
            if (!roKeys.contains(roKey)) {
                toDelete.add(Pair.of((Object)vrKey, (Object)roKey));
            }
        });
        int c1 = toDelete.size();
        this.vr2ro.deleteBatch(tx, toDelete);
        HashSet reposToDelete = new HashSet();
        this.vr2repo.forEach((Tx.Read)tx, (vrKey, bytes) -> {
            Key repoKey = (Key)this.vr2repo.toValue(bytes);
            if (!repoKeys.contains(repoKey)) {
                reposToDelete.add(vrKey);
            }
        });
        reposToDelete.forEach(vrKey -> this.vr2repo.delete(tx, vrKey));
        return c1 + reposToDelete.size();
    }

    public Stream<ValidationCheck> findValidationChecksForValidationRun(Tx.Read tx, long trustAnchorId, Paging paging, SearchTerm searchTerm, Sorting sorting) {
        return this.applyPaging(paging, this.applySorting(sorting, this.applySearchTerm(searchTerm, this.validationCheckForTaStreams(tx, trustAnchorId))));
    }

    public int countValidationChecksForValidationRun(Tx.Read tx, long trustAnchorId, SearchTerm searchTerm) {
        return (int)this.applySearchTerm(searchTerm, this.validationCheckForTaStreams(tx, trustAnchorId)).count();
    }

    private Stream<ValidationCheck> validationCheckForTaStreams(Tx.Read tx, long trustAnchorId) {
        Stream taChecks = this.taIxMap.getByIdxDescendingWhere(BY_COMPLETED_AT_INDEX, tx, vr -> trustAnchorId == vr.getTrustAnchor().key().asLong()).values().stream().findFirst().map(ValidationRun::getValidationChecks).orElse(Collections.emptyList()).stream();
        Stream ctChecks = this.ctIxMap.getByIdxDescendingWhere(BY_COMPLETED_AT_INDEX, tx, vr -> trustAnchorId == vr.getTrustAnchor().key().asLong()).values().stream().findFirst().map(ValidationRun::getValidationChecks).orElse(Collections.emptyList()).stream();
        return Stream.concat(taChecks, ctChecks);
    }

    private Stream<ValidationCheck> applyPaging(Paging paging, Stream<ValidationCheck> validationChecks) {
        if (paging != null) {
            validationChecks = paging.apply(validationChecks);
        }
        return validationChecks;
    }

    private Stream<ValidationCheck> applySearchTerm(SearchTerm searchTerm, Stream<ValidationCheck> validationChecks) {
        if (searchTerm != null) {
            validationChecks = validationChecks.filter(vc -> {
                String term = searchTerm.asString().toLowerCase();
                return vc.getKey().toLowerCase().contains(term) || vc.getStatus().toString().toLowerCase().contains(term) || vc.getParameters().stream().anyMatch(p -> p.toLowerCase().contains(term));
            });
        }
        return validationChecks;
    }

    private Stream<ValidationCheck> applySorting(Sorting sorting, Stream<ValidationCheck> validationChecks) {
        Comparator<ValidationCheck> comparator;
        if (sorting == null) {
            sorting = Sorting.of((Sorting.By)Sorting.By.LOCATION, (Sorting.Direction)Sorting.Direction.ASC);
        }
        switch (1.$SwitchMap$net$ripe$rpki$validator3$api$Sorting$By[sorting.getBy().ordinal()]) {
            case 1: {
                comparator = Comparator.comparing(ValidationCheck::getKey);
                break;
            }
            case 2: {
                comparator = Comparator.comparing(ValidationCheck::getStatus);
                break;
            }
            case 3: {
                comparator = Comparator.comparing(ValidationCheck::getLocation);
                break;
            }
            default: {
                comparator = Comparator.comparing(Base::getCreatedAt);
            }
        }
        return validationChecks.sorted(sorting.getDirection() == Sorting.Direction.DESC ? comparator : comparator.reversed());
    }

    public void associate(Tx.Write tx, RpkiRepositoryValidationRun validationRun, RpkiObject rpkiObject) {
        this.vr2ro.put(tx, validationRun.key(), (Serializable)rpkiObject.key());
    }

    public void associateRpkiObjectKey(Tx.Write tx, CertificateTreeValidationRun validationRun, Key rpkiObjectKey) {
        this.vr2ro.put(tx, validationRun.key(), (Serializable)rpkiObjectKey);
    }

    public void associate(Tx.Write tx, RpkiRepositoryValidationRun validationRun, RpkiRepository rpkiRepository) {
        this.vr2repo.put(tx, validationRun.key(), (Serializable)rpkiRepository.key());
    }

    public Set<Key> findAssociatedPks(Tx.Read tx, CertificateTreeValidationRun validationRun) {
        return new HashSet<Key>(this.vr2ro.get(tx, validationRun.key()));
    }

    public Stream<Pair<CertificateTreeValidationRun, RpkiObject>> findCurrentlyValidated(Tx.Read tx, RpkiObject.Type type) {
        Set byType = this.rpkiObjects.getPkByType(tx, type);
        return this.findLatestSuccessful(tx, CertificateTreeValidationRun.class).stream().flatMap(ct -> this.vr2ro.get(tx, ct.key()).stream().filter(byType::contains).map(roKey -> this.rpkiObjects.get(tx, roKey)).filter(Optional::isPresent).map(Optional::get).filter(ro -> ro.getType() == type).map(ro -> Pair.of((Object)ct, (Object)ro)));
    }

    public void clear(Tx.Write tx) {
        Stream.of(this.vr2ro, this.vr2repo, this.ctIxMap, this.taIxMap, this.rsIxMap, this.rrIxMap).forEach(ixMap -> ixMap.clear(tx));
    }

    public int getObjectCount(Tx.Read tx, ValidationRun validationRun) {
        return this.vr2ro.count(tx, validationRun.key());
    }

    private <T extends ValidationRun> IxMap<T> pickIxMap(String vrType) {
        IxMap ixMap = (IxMap)this.maps.get(vrType);
        if (ixMap == null) {
            throw new RuntimeException("Oops, you are looking for the " + vrType + " which is not here.");
        }
        return ixMap;
    }

    private List<IxMap<? extends ValidationRun>> pickIxMaps(Class<? extends ValidationRun> c) {
        ArrayList<IxMap<? extends ValidationRun>> ixMaps = new ArrayList<IxMap<? extends ValidationRun>>();
        try {
            String validationRunType = FieldUtils.readDeclaredStaticField(c, (String)"TYPE").toString();
            ixMaps.add(this.pickIxMap(validationRunType));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ixMaps.addAll(this.maps.values());
        }
        return ixMaps;
    }
}

