/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.cleanup;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import net.ripe.rpki.validator3.api.util.InstantWithoutNanos;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import net.ripe.rpki.validator3.util.Time;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RpkiRepositoryCleanupService {
    private static final Logger log = LoggerFactory.getLogger(RpkiRepositoryCleanupService.class);
    @Autowired
    private RpkiRepositories rpkiRepositories;
    private final Duration cleanupGraceDuration;
    private final Storage storage;

    public RpkiRepositoryCleanupService(@Value(value="${rpki.validator.rpki.repository.cleanup.grace.duration:P7D}") Duration cleanupGraceDuration, Storage storage) {
        log.info("Configured to remove repositories older than {}", (Object)cleanupGraceDuration);
        this.cleanupGraceDuration = cleanupGraceDuration;
        this.storage = storage;
    }

    public long cleanupRpkiRepositories() {
        InstantWithoutNanos unreferencedSince = InstantWithoutNanos.now().minus((TemporalAmount)this.cleanupGraceDuration);
        Pair deleted = Time.timed(() -> (Long)this.storage.writeTx(tx -> this.rpkiRepositories.deleteUnreferencedRepositories(tx, unreferencedSince)));
        log.info("Removed {} RPKI repositories that have not been referenced since {}, took {}ms", new Object[]{deleted.getLeft(), unreferencedSince, deleted.getRight()});
        return (Long)deleted.getLeft();
    }
}

