/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.bgp;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.validation.constraints.NotNull;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator3.api.bgp.BgpRisDump;
import net.ripe.rpki.validator3.api.bgp.BgpRisEntry;
import net.ripe.rpki.validator3.domain.metrics.HttpClientMetricsService;
import net.ripe.rpki.validator3.util.HttpStreaming;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class BgpRisDownloader {
    private static final Logger log = LoggerFactory.getLogger(BgpRisDownloader.class);
    private final HttpClientMetricsService httpMetrics;
    private HttpClient httpClient;
    private static Pattern regexp = Pattern.compile("^\\s*([0-9]+)\\s+([0-9a-fA-F.:/]+)\\s+([0-9]+)\\s*$");

    @Autowired
    public BgpRisDownloader(HttpClientMetricsService httpMetrics, HttpClient httpClient) {
        this.httpMetrics = httpMetrics;
        this.httpClient = httpClient;
        assert (httpClient.isStarted());
    }

    public <T> BgpRisDump<T> fetch(@NotNull BgpRisDump dump, Function<BgpRisEntry, Stream<T>> mapper) {
        log.info("attempting to download new BGP RIS preview dump from {}", (Object)dump.url);
        long before = System.currentTimeMillis();
        String statusDescription = "200";
        Supplier<Request> requestSupplier = () -> {
            Request request = this.httpClient.newRequest(dump.url);
            if (dump.lastModified != null) {
                log.debug("Adding 'If-Modified-Since' equals to {}", (Object)this.formatAsRFC2616(dump.lastModified));
                request.header("If-Modified-Since", this.formatAsRFC2616(dump.lastModified));
            }
            return request;
        };
        BiFunction<InputStream, Long, BgpRisDump> streamReader = (stream, lastModified) -> {
            try {
                Stream entries = BgpRisDownloader.parse((InputStream)new GZIPInputStream((InputStream)stream));
                ImmutableList.Builder builder = ImmutableList.builder();
                entries.flatMap(mapper).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                return BgpRisDump.of((String)dump.url, (DateTime)new DateTime(lastModified), Optional.of(builder.build()));
            }
            catch (Exception e) {
                log.error("Error downloading RIS dump: " + dump.url);
                return dump;
            }
        };
        try {
            BgpRisDump bgpRisDump = (BgpRisDump)HttpStreaming.readStream(requestSupplier, streamReader);
            return bgpRisDump;
        }
        catch (HttpStreaming.NotModifiedException n) {
            statusDescription = "302";
            BgpRisDump bgpRisDump = dump;
            return bgpRisDump;
        }
        catch (Exception e) {
            statusDescription = HttpClientMetricsService.unwrapExceptionString((Throwable)e);
            throw e;
        }
        finally {
            this.httpMetrics.update(dump.url, statusDescription, System.currentTimeMillis() - before);
        }
    }

    public static Stream<BgpRisEntry> parse(InputStream is) {
        return new BufferedReader(new InputStreamReader(is)).lines().map(s -> {
            try {
                return BgpRisDownloader.parseLine((String)s);
            }
            catch (Exception e) {
                log.error("Unparseable line: " + s);
                return null;
            }
        }).filter(Objects::nonNull);
    }

    private static BgpRisEntry parseLine(String line) {
        Matcher matcher = regexp.matcher(line);
        if (matcher.matches()) {
            Asn asn = Asn.parse((String)matcher.group(1));
            IpRange prefix = IpRange.parse((String)matcher.group(2));
            int visibility = Integer.parseInt(matcher.group(3));
            return BgpRisEntry.of((Asn)asn, (IpRange)prefix, (int)visibility);
        }
        return null;
    }

    private String formatAsRFC2616(DateTime d) {
        return d.toDateTime(DateTimeZone.UTC).toString("EEE, dd MMM yyyy HH:mm:ss ZZZ");
    }
}

