/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api;

import java.beans.ConstructorProperties;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;

public final class Paging {
    private final Long startFrom;
    private final Long pageSize;

    public static <T> Links links(long startFrom, long pageSize, long totalSize, BiFunction<Long, Long, T> linkConstructor) {
        long previous = startFrom - pageSize;
        if (previous < 0L) {
            previous = 0L;
        }
        long next = startFrom + pageSize;
        long realTotal = totalSize - pageSize;
        if (realTotal < 0L) {
            realTotal = 0L;
        }
        if (next > realTotal) {
            next = realTotal;
        }
        return new Links(new Link[]{ControllerLinkBuilder.linkTo(linkConstructor.apply(0L, pageSize)).withRel("first"), ControllerLinkBuilder.linkTo(linkConstructor.apply(previous, pageSize)).withRel("prev"), ControllerLinkBuilder.linkTo(linkConstructor.apply(next, pageSize)).withRel("next"), ControllerLinkBuilder.linkTo(linkConstructor.apply(realTotal, pageSize)).withRel("last")});
    }

    public <T> Stream<T> apply(Stream<T> stream) {
        return stream.skip(this.getStartFrom()).limit(this.getPageSize());
    }

    @ConstructorProperties(value={"startFrom", "pageSize"})
    private Paging(Long startFrom, Long pageSize) {
        this.startFrom = startFrom;
        this.pageSize = pageSize;
    }

    public static Paging of(Long startFrom, Long pageSize) {
        return new Paging(startFrom, pageSize);
    }

    public Long getStartFrom() {
        return this.startFrom;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Paging)) {
            return false;
        }
        Paging other = (Paging)o;
        Long this$startFrom = this.getStartFrom();
        Long other$startFrom = other.getStartFrom();
        if (this$startFrom == null ? other$startFrom != null : !((Object)this$startFrom).equals(other$startFrom)) {
            return false;
        }
        Long this$pageSize = this.getPageSize();
        Long other$pageSize = other.getPageSize();
        return !(this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $startFrom = this.getStartFrom();
        result = result * 59 + ($startFrom == null ? 43 : ((Object)$startFrom).hashCode());
        Long $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        return result;
    }

    public String toString() {
        return "Paging(startFrom=" + this.getStartFrom() + ", pageSize=" + this.getPageSize() + ")";
    }
}

