/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.SocketAddressResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

/*
 * Exception performing whole class analysis ignored.
 */
public class HappyEyeballsResolver
implements SocketAddressResolver {
    private static final Logger log = LoggerFactory.getLogger(HappyEyeballsResolver.class);
    private static final long RESOLUTION_DELAY_MILLIS = 50L;
    private static final long CONNECTION_ATTEMPT_DELAY_MS = 250L;
    private final HttpClient httpClient;
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("\\d{1,3}(?:\\.\\d{1,3}){3}");
    private static final Pattern IPV6_ADDRESS_PATTERN = Pattern.compile("( [0-9A-Fa-f:.]+ (?: % [0-9A-Za-z][-0-9A-Za-z_\\ ]*)? )", 4);

    public HappyEyeballsResolver(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void resolve(String host, int port, Promise<List<InetSocketAddress>> promise) {
        Optional literalIpAddress = this.isLiteralIpAddress(host);
        if (literalIpAddress.isPresent()) {
            this.completePromise((String)literalIpAddress.get(), port, promise);
        } else {
            this.resolveAsynchronously(host, port, promise);
        }
    }

    Optional<String> isLiteralIpAddress(String host) {
        Matcher matcher;
        if (this.isLiteralV4Address(host)) {
            return Optional.of(host);
        }
        if (host.contains(":") && (matcher = IPV6_ADDRESS_PATTERN.matcher(host)).matches()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    private boolean isLiteralV4Address(String host) {
        return IPV4_ADDRESS_PATTERN.matcher(host).matches();
    }

    private void completePromise(String ipAddress, int port, Promise<List<InetSocketAddress>> promise) {
        try {
            InetAddress inetAddress = InetAddress.getByName(ipAddress);
            InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, port);
            promise.succeeded(Collections.singletonList(socketAddress));
        }
        catch (Exception e) {
            log.error("Error creating socket for " + ipAddress, (Throwable)e);
            promise.failed((Throwable)e);
        }
    }

    private void resolveAsynchronously(String host, int port, Promise<List<InetSocketAddress>> promise) {
        Executor executor = this.httpClient.getExecutor();
        executor.execute(() -> {
            ConcurrentLinkedQueue sockets = new ConcurrentLinkedQueue();
            try {
                Name hostname = Name.fromString((String)host);
                ConcurrentLinkedQueue resolvedAddressesV6 = new ConcurrentLinkedQueue();
                executor.execute(HappyEyeballsResolver.dnsLookupRunnable((Name)hostname, (int)28, resolvedAddressesV6));
                ConcurrentLinkedQueue resolvedAddressesV4 = new ConcurrentLinkedQueue();
                executor.execute(HappyEyeballsResolver.dnsLookupRunnable((Name)hostname, (int)1, resolvedAddressesV4));
                HappyEyeballsResolver.awaitDnsResponses(resolvedAddressesV6, resolvedAddressesV4);
                if (log.isDebugEnabled()) {
                    log.debug("Resolved v6 addresses: {} for host {}", this.joinAddresses(resolvedAddressesV6), (Object)host);
                    log.debug("Resolved v4 addresses: {} for host {}", this.joinAddresses(resolvedAddressesV4), (Object)host);
                }
                Thread connectionsThread = new Thread(HappyEyeballsResolver.connectAttemptsRunnable(resolvedAddressesV6, resolvedAddressesV4, sockets, (int)port));
                connectionsThread.start();
                InetSocketAddress bestAddress = (InetSocketAddress)HappyEyeballsResolver.awaitSuccessfulConnection(sockets);
                if (bestAddress == null) {
                    promise.failed((Throwable)new UnknownHostException(host));
                } else {
                    promise.succeeded(Collections.singletonList(bestAddress));
                }
                connectionsThread.interrupt();
                try {
                    connectionsThread.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                log.warn(String.format("Error during lookup in happy eyeballs resolver for %s:%s", host, port), (Throwable)e);
                promise.failed((Throwable)e);
            }
            finally {
                for (Optional channelOptional : sockets) {
                    channelOptional.ifPresent(HappyEyeballsResolver::closeAnyway);
                }
            }
        });
    }

    private static void closeAnyway(SocketChannel channel) {
        try {
            channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object joinAddresses(ConcurrentLinkedQueue<Optional<InetAddress>> resolvedAddressesV6) {
        return resolvedAddressesV6.stream().filter(Optional::isPresent).map(Optional::get).map(InetAddress::getHostAddress).collect(Collectors.joining(","));
    }

    private static SocketAddress awaitSuccessfulConnection(ConcurrentLinkedQueue<Optional<SocketChannel>> sockets) throws IOException {
        long startTime = System.nanoTime();
        long sleepDeadline = startTime + TimeUnit.MILLISECONDS.toNanos(100L);
        long deadline = startTime + TimeUnit.SECONDS.toNanos(10L);
        boolean keepGoing = true;
        while (keepGoing && HappyEyeballsResolver.haveTime((long)deadline)) {
            Iterator<Optional<SocketChannel>> iterator = sockets.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                ++count;
                Optional<SocketChannel> socketChannelOptional = iterator.next();
                if (socketChannelOptional.isPresent()) {
                    SocketChannel socketChannel = socketChannelOptional.get();
                    try {
                        if (!socketChannel.finishConnect()) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("Successfully connected to: {}", (Object)socketChannel.getRemoteAddress());
                        }
                        return socketChannel.getRemoteAddress();
                    }
                    catch (IOException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Error connecting to " + socketChannel.getRemoteAddress(), (Throwable)e);
                        }
                        HappyEyeballsResolver.closeAnyway((SocketChannel)socketChannel);
                        iterator.remove();
                        continue;
                    }
                }
                if (count != 1) break;
                keepGoing = false;
                break;
            }
            if (HappyEyeballsResolver.haveTime((long)sleepDeadline)) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException ignored) {
                keepGoing = false;
            }
        }
        return null;
    }

    private static void awaitDnsResponses(ConcurrentLinkedQueue<Optional<InetAddress>> resolvedAddressesV6, ConcurrentLinkedQueue<Optional<InetAddress>> resolvedAddressesV4) {
        long startTime = System.nanoTime();
        long sleepDeadline = startTime + TimeUnit.MILLISECONDS.toNanos(100L);
        boolean keepGoing = true;
        while (resolvedAddressesV6.isEmpty() && keepGoing) {
            if (!resolvedAddressesV4.isEmpty()) {
                long deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(50L);
                while (HappyEyeballsResolver.haveTime((long)deadline) && resolvedAddressesV6.isEmpty()) {
                }
                keepGoing = false;
            }
            if (HappyEyeballsResolver.haveTime((long)sleepDeadline)) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException ignored) {
                keepGoing = false;
            }
        }
    }

    private static boolean haveTime(long nanoDeadline) {
        return System.nanoTime() - nanoDeadline < 0L;
    }

    private static Runnable dnsLookupRunnable(Name hostname, int queryType, Queue<Optional<InetAddress>> resolvedAddresses) {
        return () -> {
            try {
                Lookup lookup = new Lookup(hostname, queryType, 1);
                Record[] records = lookup.run();
                if (records != null) {
                    for (Record record : records) {
                        InetAddress address = null;
                        if (record instanceof AAAARecord) {
                            address = ((AAAARecord)record).getAddress();
                        } else if (record instanceof ARecord) {
                            address = ((ARecord)record).getAddress();
                        }
                        if (address == null) continue;
                        resolvedAddresses.add(Optional.of(address));
                    }
                }
            }
            finally {
                resolvedAddresses.add(Optional.empty());
            }
        };
    }

    private static Runnable connectAttemptsRunnable(Queue<Optional<InetAddress>> firstAfAddresses, Queue<Optional<InetAddress>> secondAfAddresses, Queue<Optional<SocketChannel>> socketChannels, int port) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

