/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding.custom;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.ripe.rpki.validator3.storage.data.Base;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.custom.BaseCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.Coders;
import net.ripe.rpki.validator3.storage.encoding.custom.Encoded;
import net.ripe.rpki.validator3.storage.encoding.custom.RefCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.Tags;

public class RpkiRepositoryCoder
implements Coder<RpkiRepository> {
    private static final short TYPE_TAG = Tags.unique((int)51);
    private static final short RRDP_NOTIFY_URL_TAG = Tags.unique((int)52);
    private static final short RSYNC_URL_TAG = Tags.unique((int)53);
    private static final short STATUS_TAG = Tags.unique((int)54);
    private static final short RRDP_SERIAL = Tags.unique((int)55);
    private static final short RRDP_SESSION = Tags.unique((int)56);
    private static final short LAST_DOWNLOADED = Tags.unique((int)57);
    private static final short PARENT_REPOSITORY = Tags.unique((int)58);
    private static final short TRUST_ANCHORS = Tags.unique((int)59);
    private static final RefCoder<RpkiRepository> repoRefCoder = new RefCoder();
    private static final RefCoder<TrustAnchor> taRefCoder = new RefCoder();

    public byte[] toBytes(RpkiRepository rpkiRepository) {
        Encoded encoded = new Encoded();
        BaseCoder.toBytes((Base)rpkiRepository, (Encoded)encoded);
        encoded.append(TYPE_TAG, Coders.toBytes((String)rpkiRepository.getType().name()));
        encoded.append(STATUS_TAG, Coders.toBytes((String)rpkiRepository.getStatus().name()));
        encoded.appendNotNull(RRDP_NOTIFY_URL_TAG, (Object)rpkiRepository.getRrdpNotifyUri(), Coders::toBytes);
        encoded.appendNotNull(RSYNC_URL_TAG, (Object)rpkiRepository.getRsyncRepositoryUri(), Coders::toBytes);
        encoded.appendNotNull(RRDP_SESSION, (Object)rpkiRepository.getRrdpSessionId(), Coders::toBytes);
        encoded.appendNotNull(RRDP_SERIAL, (Object)rpkiRepository.getRrdpSerial(), Coders::toBytes);
        encoded.appendNotNull(LAST_DOWNLOADED, (Object)rpkiRepository.getLastDownloadedAt(), Coders::toBytes);
        encoded.appendNotNull(PARENT_REPOSITORY, (Object)rpkiRepository.getParentRepository(), arg_0 -> ((RefCoder)repoRefCoder).toBytes(arg_0));
        if (rpkiRepository.getTrustAnchors() != null && !rpkiRepository.getTrustAnchors().isEmpty()) {
            byte[] taBytes = Coders.toBytes((Collection)rpkiRepository.getTrustAnchors(), arg_0 -> ((RefCoder)taRefCoder).toBytes(arg_0));
            encoded.append(TRUST_ANCHORS, taBytes);
        }
        return encoded.toByteArray();
    }

    public RpkiRepository fromBytes(byte[] bytes) {
        Map content = Encoded.fromByteArray((byte[])bytes).getContent();
        RpkiRepository rpkiRepository = new RpkiRepository();
        BaseCoder.fromBytes((Map)content, (Base)rpkiRepository);
        rpkiRepository.setType(RpkiRepository.Type.valueOf((String)Coders.toString((byte[])((byte[])content.get(TYPE_TAG)))));
        rpkiRepository.setStatus(Coders.toString((byte[])((byte[])content.get(STATUS_TAG))));
        Encoded.field((Map)content, (short)RRDP_NOTIFY_URL_TAG).ifPresent(b -> rpkiRepository.setRrdpNotifyUri(Coders.toString((byte[])b)));
        Encoded.field((Map)content, (short)RSYNC_URL_TAG).ifPresent(b -> rpkiRepository.setRsyncRepositoryUri(Coders.toString((byte[])b)));
        Encoded.field((Map)content, (short)RRDP_SESSION).ifPresent(b -> rpkiRepository.setRrdpSessionId(Coders.toString((byte[])b)));
        Encoded.field((Map)content, (short)RRDP_SERIAL).ifPresent(b -> rpkiRepository.setRrdpSerial(Coders.toBigInteger((byte[])b)));
        Encoded.field((Map)content, (short)LAST_DOWNLOADED).ifPresent(b -> rpkiRepository.setLastDownloadedAt(Coders.toInstant((byte[])b)));
        Encoded.field((Map)content, (short)PARENT_REPOSITORY).ifPresent(b -> rpkiRepository.setParentRepository(repoRefCoder.fromBytes(b)));
        Encoded.field((Map)content, (short)TRUST_ANCHORS).ifPresent(b -> {
            List objects = Coders.fromBytes((byte[])b, arg_0 -> ((RefCoder)taRefCoder).fromBytes(arg_0));
            rpkiRepository.setTrustAnchors(new HashSet(objects));
        });
        return rpkiRepository;
    }
}

