/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.background;

import com.google.common.base.CaseFormat;
import java.util.Date;
import java.util.SortedMap;
import java.util.TreeMap;
import net.ripe.rpki.validator3.background.BackgroundJobs;
import net.ripe.rpki.validator3.background.DownloadBgpRisDumpsJob;
import net.ripe.rpki.validator3.background.RpkiObjectCleanupJob;
import net.ripe.rpki.validator3.background.ValidateRsyncRepositoriesJob;
import net.ripe.rpki.validator3.background.ValidationRunCleanupJob;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.listeners.JobListenerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class BackgroundJobs
extends JobListenerSupport {
    private static final Logger log = LoggerFactory.getLogger(BackgroundJobs.class);
    private final Scheduler scheduler;
    private final TreeMap<String, Execution> backgroundJobStats = new TreeMap();

    @Autowired
    public BackgroundJobs(Scheduler scheduler) throws SchedulerException {
        this.scheduler = scheduler;
        scheduler.getListenerManager().addJobListener((JobListener)this);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void initBackgroundTasks() throws SchedulerException {
        this.schedule(RpkiObjectCleanupJob.class, DateBuilder.futureDate((int)3, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MINUTE), (ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMinutes(10));
        this.schedule(ValidationRunCleanupJob.class, DateBuilder.futureDate((int)4, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MINUTE), (ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMinutes(5));
        this.schedule(ValidateRsyncRepositoriesJob.class, DateBuilder.futureDate((int)10, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND), (ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMinutes(5));
        this.schedule(DownloadBgpRisDumpsJob.class, DateBuilder.futureDate((int)10, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND), (ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMinutes(10));
    }

    private <T extends Trigger> void schedule(Class<? extends Job> jobClass, Date startAt, ScheduleBuilder<T> schedule) throws SchedulerException {
        JobKey jobKey = JobKey.jobKey((String)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, jobClass.getSimpleName()));
        if (this.scheduler.checkExists(jobKey)) {
            this.scheduler.deleteJob(jobKey);
        }
        this.scheduler.scheduleJob(JobBuilder.newJob(jobClass).withIdentity(jobKey).build(), TriggerBuilder.newTrigger().withIdentity(jobKey + "-Trigger").startAt(startAt).withSchedule(schedule).build());
        log.info(String.format("Scheduled '%s', starting from '%s'", jobKey, startAt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobToBeExecuted(JobExecutionContext context) {
        String key = context.getJobDetail().getKey().toString();
        TreeMap treeMap = this.backgroundJobStats;
        synchronized (treeMap) {
            Execution execution = (Execution)this.backgroundJobStats.get(key);
            this.backgroundJobStats.put(key, Execution.again((Execution)execution));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        String key = context.getJobDetail().getKey().toString();
        TreeMap treeMap = this.backgroundJobStats;
        synchronized (treeMap) {
            Execution execution = (Execution)this.backgroundJobStats.get(key);
            if (execution != null) {
                this.backgroundJobStats.put(key, Execution.finish((Execution)execution));
            }
        }
    }

    public String getName() {
        return "Background jobs stat collector";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Execution> getStat() {
        TreeMap treeMap = this.backgroundJobStats;
        synchronized (treeMap) {
            return this.backgroundJobStats;
        }
    }
}

