/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.roas;

import au.com.bytecode.opencsv.CSVWriter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Writer;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import net.ripe.rpki.validator3.api.PublicApiCall;
import net.ripe.rpki.validator3.api.roas.ExportsController;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.stores.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"VRP export"})
@PublicApiCall
@RestController
public class ExportsController {
    private static final Logger log = LoggerFactory.getLogger(ExportsController.class);
    public static final String JSON = "text/json; charset=UTF-8";
    public static final String CSV = "text/csv; charset=UTF-8";
    private final ValidatedRpkiObjects validatedRpkiObjects;
    private final Settings settings;
    private final Storage storage;

    @Autowired
    public ExportsController(ValidatedRpkiObjects validatedRpkiObjects, Settings settings, Storage storage) {
        this.validatedRpkiObjects = validatedRpkiObjects;
        this.settings = settings;
        this.storage = storage;
    }

    @ApiOperation(value="export VRPs (json)")
    @GetMapping(path={"/api/export.json"})
    public JsonExport exportJson(HttpServletResponse response) {
        response.setContentType(JSON);
        if (!((Boolean)this.storage.readTx(arg_0 -> ((Settings)this.settings).isInitialValidationRunCompleted(arg_0))).booleanValue()) {
            response.setStatus(204);
            return null;
        }
        Stream<JsonRoaPrefix> validatedPrefixes = this.validatedRpkiObjects.findCurrentlyValidatedRoaPrefixes().getObjects().map(r -> new JsonRoaPrefix(String.valueOf(r.getAsn()), r.getPrefix().toString(), r.getEffectiveLength(), r.getTrustAnchor().getName())).distinct();
        return new JsonExport(validatedPrefixes);
    }

    @ApiOperation(value="export VRPs (CSV)")
    @GetMapping(path={"/api/export.csv"})
    public void exportCsv(HttpServletResponse response) throws IOException {
        response.setContentType(CSV);
        if (!((Boolean)this.storage.readTx(arg_0 -> ((Settings)this.settings).isInitialValidationRunCompleted(arg_0))).booleanValue()) {
            response.setStatus(204);
            return;
        }
        try (CSVWriter writer = new CSVWriter((Writer)response.getWriter());){
            writer.writeNext(new String[]{"ASN", "IP Prefix", "Max Length", "Trust Anchor"});
            Stream<CsvRoaPrefix> validatedPrefixes = this.validatedRpkiObjects.findCurrentlyValidatedRoaPrefixes().getObjects().map(r -> new CsvRoaPrefix(String.valueOf(r.getAsn()), r.getPrefix().toString(), r.getEffectiveLength(), r.getTrustAnchor().getName())).distinct();
            validatedPrefixes.forEach(prefix -> writer.writeNext(new String[]{prefix.getAsn(), prefix.getPrefix(), String.valueOf(prefix.getMaxLength()), prefix.getTrustAnchorName()}));
        }
    }
}

