/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.cleanup;

import java.time.Duration;
import java.time.Instant;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.stores.RpkiObjects;
import net.ripe.rpki.validator3.util.Time;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RpkiObjectCleanupService {
    private static final Logger log = LoggerFactory.getLogger(RpkiObjectCleanupService.class);
    @Autowired
    private RpkiObjects rpkiObjects;
    private final Duration cleanupGraceDuration;
    private final Storage storage;

    public RpkiObjectCleanupService(@Value(value="${rpki.validator.rpki.object.cleanup.grace.duration}") String cleanupGraceDuration, Storage storage) {
        this.cleanupGraceDuration = Duration.parse(cleanupGraceDuration);
        log.info("Configured to remove objects older than {}", (Object)cleanupGraceDuration);
        this.storage = storage;
    }

    public long cleanupRpkiObjects() throws Exception {
        Instant unreachableSince = Instant.now().minus(this.cleanupGraceDuration);
        Pair deleted = Time.timed(() -> this.rpkiObjects.deleteUnreachableObjects(unreachableSince));
        log.info("Removed {} RPKI objects that have not been marked reachable since {}, took {}ms", new Object[]{deleted.getLeft(), unreachableSince, deleted.getRight()});
        this.storage.gc();
        return (Long)deleted.getLeft();
    }
}

