// Copyright (C) 2022 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#pragma once

#include <utils/environment.h>

#include <QProcessEnvironment>

namespace ProjectExplorer { class BuildSystem; }

namespace QmlDesigner {

enum class PuppetType { Fallback, Kit };

class PuppetEnvironmentBuilder
{
public:
    PuppetEnvironmentBuilder(ProjectExplorer::BuildSystem *buildSystem,
                             const class DesignerSettings &designerSettings,
                             const class Model &model,
                             const Utils::FilePath &qmlPuppetPath)
        : m_buildSystem(buildSystem)
        , m_designerSettings(designerSettings)
        , m_model(model)
        , m_qmlPuppetPath(qmlPuppetPath)
    {}

    QProcessEnvironment processEnvironment() const;

    static QProcessEnvironment createEnvironment(ProjectExplorer::BuildSystem *buildSystem,
                                                 const class DesignerSettings &designerSettings,
                                                 const class Model &model,
                                                 const Utils::FilePath &qmlPuppetPath);

private:
    PuppetType determinePuppetType() const;
    bool usesVirtualKeyboard() const;
    QString getStyleConfigFileName() const;
    void initEnvironment() const;
    void addKit() const;
    void addRendering() const;
    void addControls() const;
    void addPixelRatio() const;
    void addVirtualKeyboard() const;
    void addQuick3D() const;
    void addForceQApplication() const;
    void addMultiLanguageDatatbase() const;
    void addImportPaths() const;
    void addCustomFileSelectors() const;
    void addDisableDeferredProperties() const;
    void addResolveUrlsOnAssignment() const;
    void addMcuItems() const;
    void addMcuFonts() const;

private:
    ProjectExplorer::BuildSystem *m_buildSystem = nullptr;
    const DesignerSettings &m_designerSettings;
    const Model &m_model;
    mutable PuppetType m_availablePuppetType = {};
    mutable Utils::Environment m_environment;
    Utils::FilePath m_qmlPuppetPath;
};

} // namespace QmlDesigner
