// Copyright 2022 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated by `tools/dev/gen-static-roots.py`. Do
// not edit manually.

#ifndef V8_ROOTS_STATIC_ROOTS_H_
#define V8_ROOTS_STATIC_ROOTS_H_

#include "src/common/globals.h"

#if V8_STATIC_ROOTS_BOOL

#include "src/objects/instance-type.h"
#include "src/roots/roots.h"

// Disabling Wasm or Intl invalidates the contents of static-roots.h.
// TODO(olivf): To support static roots for multiple build configurations we
//              will need to generate target specific versions of this file.
static_assert(V8_ENABLE_WEBASSEMBLY);
static_assert(V8_INTL_SUPPORT);

namespace v8 {
namespace internal {

struct StaticReadOnlyRoot {
  static constexpr Tagged_t kMetaMap = 0x61;
  static constexpr Tagged_t kFixedArrayMap = 0x89;
  static constexpr Tagged_t kWeakFixedArrayMap = 0xb1;
  static constexpr Tagged_t kWeakArrayListMap = 0xd9;
  static constexpr Tagged_t kFixedCOWArrayMap = 0x101;
  static constexpr Tagged_t kDescriptorArrayMap = 0x129;
  static constexpr Tagged_t kUndefinedMap = 0x151;
  static constexpr Tagged_t kNullMap = 0x179;
  static constexpr Tagged_t kTheHoleMap = 0x1a1;
  static constexpr Tagged_t kEmptyFixedArray = 0x1c9;
  static constexpr Tagged_t kEmptyWeakFixedArray = 0x1d1;
  static constexpr Tagged_t kEmptyWeakArrayList = 0x1d9;
  static constexpr Tagged_t kNullValue = 0x1e5;
  static constexpr Tagged_t kUndefinedValue = 0x201;
  static constexpr Tagged_t kTheHoleValue = 0x21d;
  static constexpr Tagged_t kPromiseFulfillReactionJobTaskMap = 0x239;
  static constexpr Tagged_t kPromiseRejectReactionJobTaskMap = 0x261;
  static constexpr Tagged_t kCallableTaskMap = 0x289;
  static constexpr Tagged_t kCallbackTaskMap = 0x2b1;
  static constexpr Tagged_t kPromiseResolveThenableJobTaskMap = 0x2d9;
  static constexpr Tagged_t kFunctionTemplateInfoMap = 0x301;
  static constexpr Tagged_t kObjectTemplateInfoMap = 0x329;
  static constexpr Tagged_t kAccessCheckInfoMap = 0x351;
  static constexpr Tagged_t kAccessorPairMap = 0x379;
  static constexpr Tagged_t kAliasedArgumentsEntryMap = 0x3a1;
  static constexpr Tagged_t kAllocationMementoMap = 0x3c9;
  static constexpr Tagged_t kArrayBoilerplateDescriptionMap = 0x3f1;
  static constexpr Tagged_t kAsmWasmDataMap = 0x419;
  static constexpr Tagged_t kAsyncGeneratorRequestMap = 0x441;
  static constexpr Tagged_t kBreakPointMap = 0x469;
  static constexpr Tagged_t kBreakPointInfoMap = 0x491;
  static constexpr Tagged_t kCallSiteInfoMap = 0x4b9;
  static constexpr Tagged_t kClassPositionsMap = 0x4e1;
  static constexpr Tagged_t kDebugInfoMap = 0x509;
  static constexpr Tagged_t kEnumCacheMap = 0x531;
  static constexpr Tagged_t kErrorStackDataMap = 0x559;
  static constexpr Tagged_t kFunctionTemplateRareDataMap = 0x581;
  static constexpr Tagged_t kInterceptorInfoMap = 0x5a9;
  static constexpr Tagged_t kInterpreterDataMap = 0x5d1;
  static constexpr Tagged_t kModuleRequestMap = 0x5f9;
  static constexpr Tagged_t kPromiseCapabilityMap = 0x621;
  static constexpr Tagged_t kPromiseOnStackMap = 0x649;
  static constexpr Tagged_t kPromiseReactionMap = 0x671;
  static constexpr Tagged_t kPropertyDescriptorObjectMap = 0x699;
  static constexpr Tagged_t kPrototypeInfoMap = 0x6c1;
  static constexpr Tagged_t kRegExpBoilerplateDescriptionMap = 0x6e9;
  static constexpr Tagged_t kScriptMap = 0x711;
  static constexpr Tagged_t kScriptOrModuleMap = 0x739;
  static constexpr Tagged_t kSourceTextModuleInfoEntryMap = 0x761;
  static constexpr Tagged_t kStackFrameInfoMap = 0x789;
  static constexpr Tagged_t kTemplateObjectDescriptionMap = 0x7b1;
  static constexpr Tagged_t kTuple2Map = 0x7d9;
  static constexpr Tagged_t kWasmExceptionTagMap = 0x801;
  static constexpr Tagged_t kWasmIndirectFunctionTableMap = 0x829;
  static constexpr Tagged_t kAllocationSiteWithWeakNextMap = 0x851;
  static constexpr Tagged_t kAllocationSiteWithoutWeakNextMap = 0x879;
  static constexpr Tagged_t kLoadHandler1Map = 0x8a1;
  static constexpr Tagged_t kLoadHandler2Map = 0x8c9;
  static constexpr Tagged_t kLoadHandler3Map = 0x8f1;
  static constexpr Tagged_t kStoreHandler0Map = 0x919;
  static constexpr Tagged_t kStoreHandler1Map = 0x941;
  static constexpr Tagged_t kStoreHandler2Map = 0x969;
  static constexpr Tagged_t kStoreHandler3Map = 0x991;
  static constexpr Tagged_t kEmptyEnumCache = 0x9b9;
  static constexpr Tagged_t kEmptyDescriptorArray = 0x9c5;
  static constexpr Tagged_t kScopeInfoMap = 0x9d5;
  static constexpr Tagged_t kModuleInfoMap = 0x9fd;
  static constexpr Tagged_t kClosureFeedbackCellArrayMap = 0xa25;
  static constexpr Tagged_t kFeedbackVectorMap = 0xa4d;
  static constexpr Tagged_t kHeapNumberMap = 0xa75;
  static constexpr Tagged_t kForeignMap = 0xa9d;
  static constexpr Tagged_t kMegaDomHandlerMap = 0xac5;
  static constexpr Tagged_t kBooleanMap = 0xaed;
  static constexpr Tagged_t kUninitializedMap = 0xb15;
  static constexpr Tagged_t kArgumentsMarkerMap = 0xb3d;
  static constexpr Tagged_t kExceptionMap = 0xb65;
  static constexpr Tagged_t kTerminationExceptionMap = 0xb8d;
  static constexpr Tagged_t kOptimizedOutMap = 0xbb5;
  static constexpr Tagged_t kStaleRegisterMap = 0xbdd;
  static constexpr Tagged_t kSelfReferenceMarkerMap = 0xc05;
  static constexpr Tagged_t kBasicBlockCountersMarkerMap = 0xc2d;
  static constexpr Tagged_t kBigIntMap = 0xc55;
  static constexpr Tagged_t kSymbolMap = 0xc7d;
  static constexpr Tagged_t kStringMap = 0xca5;
  static constexpr Tagged_t kOneByteStringMap = 0xccd;
  static constexpr Tagged_t kConsStringMap = 0xcf5;
  static constexpr Tagged_t kConsOneByteStringMap = 0xd1d;
  static constexpr Tagged_t kSlicedStringMap = 0xd45;
  static constexpr Tagged_t kSlicedOneByteStringMap = 0xd6d;
  static constexpr Tagged_t kExternalStringMap = 0xd95;
  static constexpr Tagged_t kExternalOneByteStringMap = 0xdbd;
  static constexpr Tagged_t kUncachedExternalStringMap = 0xde5;
  static constexpr Tagged_t kUncachedExternalOneByteStringMap = 0xe0d;
  static constexpr Tagged_t kInternalizedStringMap = 0xe35;
  static constexpr Tagged_t kOneByteInternalizedStringMap = 0xe5d;
  static constexpr Tagged_t kExternalInternalizedStringMap = 0xe85;
  static constexpr Tagged_t kExternalOneByteInternalizedStringMap = 0xead;
  static constexpr Tagged_t kUncachedExternalInternalizedStringMap = 0xed5;
  static constexpr Tagged_t kUncachedExternalOneByteInternalizedStringMap =
      0xefd;
  static constexpr Tagged_t kThinStringMap = 0xf25;
  static constexpr Tagged_t kSharedStringMap = 0xf4d;
  static constexpr Tagged_t kSharedOneByteStringMap = 0xf75;
  static constexpr Tagged_t kSharedExternalStringMap = 0xf9d;
  static constexpr Tagged_t kSharedExternalOneByteStringMap = 0xfc5;
  static constexpr Tagged_t kSharedUncachedExternalStringMap = 0xfed;
  static constexpr Tagged_t kSharedUncachedExternalOneByteStringMap = 0x1015;
  static constexpr Tagged_t kFixedDoubleArrayMap = 0x103d;
  static constexpr Tagged_t kFeedbackMetadataArrayMap = 0x1065;
  static constexpr Tagged_t kByteArrayMap = 0x108d;
  static constexpr Tagged_t kBytecodeArrayMap = 0x10b5;
  static constexpr Tagged_t kFreeSpaceMap = 0x10dd;
  static constexpr Tagged_t kPropertyArrayMap = 0x1105;
  static constexpr Tagged_t kSmallOrderedHashMapMap = 0x112d;
  static constexpr Tagged_t kSmallOrderedHashSetMap = 0x1155;
  static constexpr Tagged_t kSmallOrderedNameDictionaryMap = 0x117d;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataMap = 0x11a5;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataMap = 0x11cd;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataWithJobMap =
      0x11f5;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataAndJobMap = 0x121d;
  static constexpr Tagged_t kOnHeapBasicBlockProfilerDataMap = 0x1245;
  static constexpr Tagged_t kTurbofanBitsetTypeMap = 0x126d;
  static constexpr Tagged_t kTurbofanUnionTypeMap = 0x1295;
  static constexpr Tagged_t kTurbofanRangeTypeMap = 0x12bd;
  static constexpr Tagged_t kTurbofanHeapConstantTypeMap = 0x12e5;
  static constexpr Tagged_t kTurbofanOtherNumberConstantTypeMap = 0x130d;
  static constexpr Tagged_t kTurboshaftWord32TypeMap = 0x1335;
  static constexpr Tagged_t kTurboshaftWord32RangeTypeMap = 0x135d;
  static constexpr Tagged_t kTurboshaftWord64TypeMap = 0x1385;
  static constexpr Tagged_t kTurboshaftWord64RangeTypeMap = 0x13ad;
  static constexpr Tagged_t kTurboshaftFloat64TypeMap = 0x13d5;
  static constexpr Tagged_t kTurboshaftFloat64RangeTypeMap = 0x13fd;
  static constexpr Tagged_t kInternalClassMap = 0x1425;
  static constexpr Tagged_t kSmiPairMap = 0x144d;
  static constexpr Tagged_t kSmiBoxMap = 0x1475;
  static constexpr Tagged_t kExportedSubClassBaseMap = 0x149d;
  static constexpr Tagged_t kExportedSubClassMap = 0x14c5;
  static constexpr Tagged_t kAbstractInternalClassSubclass1Map = 0x14ed;
  static constexpr Tagged_t kAbstractInternalClassSubclass2Map = 0x1515;
  static constexpr Tagged_t kExportedSubClass2Map = 0x153d;
  static constexpr Tagged_t kSortStateMap = 0x1565;
  static constexpr Tagged_t kWasmStringViewIterMap = 0x158d;
  static constexpr Tagged_t kSloppyArgumentsElementsMap = 0x15b5;
  static constexpr Tagged_t kStrongDescriptorArrayMap = 0x15dd;
  static constexpr Tagged_t kTurboshaftWord32SetTypeMap = 0x1605;
  static constexpr Tagged_t kTurboshaftWord64SetTypeMap = 0x162d;
  static constexpr Tagged_t kTurboshaftFloat64SetTypeMap = 0x1655;
  static constexpr Tagged_t kInternalClassWithSmiElementsMap = 0x167d;
  static constexpr Tagged_t kInternalClassWithStructElementsMap = 0x16a5;
  static constexpr Tagged_t kInstructionStreamMap = 0x16cd;
  static constexpr Tagged_t kCellMap = 0x16f5;
  static constexpr Tagged_t kInvalidPrototypeValidityCell = 0x171d;
  static constexpr Tagged_t kGlobalPropertyCellMap = 0x1725;
  static constexpr Tagged_t kOnePointerFillerMap = 0x174d;
  static constexpr Tagged_t kTwoPointerFillerMap = 0x1775;
  static constexpr Tagged_t kNoClosuresCellMap = 0x179d;
  static constexpr Tagged_t kOneClosureCellMap = 0x17c5;
  static constexpr Tagged_t kManyClosuresCellMap = 0x17ed;
  static constexpr Tagged_t kTransitionArrayMap = 0x1815;
  static constexpr Tagged_t kHashTableMap = 0x183d;
  static constexpr Tagged_t kOrderedHashMapMap = 0x1865;
  static constexpr Tagged_t kOrderedHashSetMap = 0x188d;
  static constexpr Tagged_t kOrderedNameDictionaryMap = 0x18b5;
  static constexpr Tagged_t kNameDictionaryMap = 0x18dd;
  static constexpr Tagged_t kSwissNameDictionaryMap = 0x1905;
  static constexpr Tagged_t kGlobalDictionaryMap = 0x192d;
  static constexpr Tagged_t kNumberDictionaryMap = 0x1955;
  static constexpr Tagged_t kSimpleNumberDictionaryMap = 0x197d;
  static constexpr Tagged_t kNameToIndexHashTableMap = 0x19a5;
  static constexpr Tagged_t kRegisteredSymbolTableMap = 0x19cd;
  static constexpr Tagged_t kEmbedderDataArrayMap = 0x19f5;
  static constexpr Tagged_t kEphemeronHashTableMap = 0x1a1d;
  static constexpr Tagged_t kArrayListMap = 0x1a45;
  static constexpr Tagged_t kScriptContextTableMap = 0x1a6d;
  static constexpr Tagged_t kObjectBoilerplateDescriptionMap = 0x1a95;
  static constexpr Tagged_t kCoverageInfoMap = 0x1abd;
  static constexpr Tagged_t kAccessorInfoMap = 0x1ae5;
  static constexpr Tagged_t kSideEffectCallHandlerInfoMap = 0x1b0d;
  static constexpr Tagged_t kSideEffectFreeCallHandlerInfoMap = 0x1b35;
  static constexpr Tagged_t kNextCallSideEffectFreeCallHandlerInfoMap = 0x1b5d;
  static constexpr Tagged_t kPreparseDataMap = 0x1b85;
  static constexpr Tagged_t kSharedFunctionInfoMap = 0x1bad;
  static constexpr Tagged_t kSourceTextModuleMap = 0x1bd5;
  static constexpr Tagged_t kSyntheticModuleMap = 0x1bfd;
  static constexpr Tagged_t kCodeMap = 0x1c25;
  static constexpr Tagged_t kWasmApiFunctionRefMap = 0x1c4d;
  static constexpr Tagged_t kWasmCapiFunctionDataMap = 0x1c75;
  static constexpr Tagged_t kWasmExportedFunctionDataMap = 0x1c9d;
  static constexpr Tagged_t kWasmInternalFunctionMap = 0x1cc5;
  static constexpr Tagged_t kWasmJSFunctionDataMap = 0x1ced;
  static constexpr Tagged_t kWasmResumeDataMap = 0x1d15;
  static constexpr Tagged_t kWasmTypeInfoMap = 0x1d3d;
  static constexpr Tagged_t kWasmContinuationObjectMap = 0x1d65;
  static constexpr Tagged_t kWasmNullMap = 0x1d8d;
  static constexpr Tagged_t kWeakCellMap = 0x1db5;
  static constexpr Tagged_t kEmptyArrayList = 0x1ddd;
  static constexpr Tagged_t kEmptyScopeInfo = 0x1de9;
  static constexpr Tagged_t kEmptyObjectBoilerplateDescription = 0x1df9;
  static constexpr Tagged_t kEmptyArrayBoilerplateDescription = 0x1e05;
  static constexpr Tagged_t kTrueValue = 0x1e11;
  static constexpr Tagged_t kFalseValue = 0x1e2d;
  static constexpr Tagged_t kEmptyByteArray = 0x1e49;
  static constexpr Tagged_t kEmptyPropertyArray = 0x1e51;
  static constexpr Tagged_t kEmptyClosureFeedbackCellArray = 0x1e59;
  static constexpr Tagged_t kNoOpInterceptorInfo = 0x1e61;
  static constexpr Tagged_t kMinusZeroValue = 0x1e89;
  static constexpr Tagged_t kNanValue = 0x1e95;
  static constexpr Tagged_t kHoleNanValue = 0x1ea1;
  static constexpr Tagged_t kInfinityValue = 0x1ead;
  static constexpr Tagged_t kMinusInfinityValue = 0x1eb9;
  static constexpr Tagged_t kMaxSafeInteger = 0x1ec5;
  static constexpr Tagged_t kMaxUInt32 = 0x1ed1;
  static constexpr Tagged_t kSmiMinValue = 0x1edd;
  static constexpr Tagged_t kSmiMaxValuePlusOne = 0x1ee9;
  static constexpr Tagged_t kHashSeed = 0x1ef5;
  static constexpr Tagged_t kSingleCharacterStringTable = 0x1f05;
  static constexpr Tagged_t kdot_string = 0x25ed;
  static constexpr Tagged_t kzero_string = 0x260d;
  static constexpr Tagged_t kone_string = 0x261d;
  static constexpr Tagged_t kempty_string = 0x330d;
  static constexpr Tagged_t kadoptText_string = 0x3319;
  static constexpr Tagged_t kapproximatelySign_string = 0x3331;
  static constexpr Tagged_t kbaseName_string = 0x3351;
  static constexpr Tagged_t kaccounting_string = 0x3365;
  static constexpr Tagged_t kbreakType_string = 0x337d;
  static constexpr Tagged_t kcalendars_string = 0x3395;
  static constexpr Tagged_t kcardinal_string = 0x33ad;
  static constexpr Tagged_t kcaseFirst_string = 0x33c1;
  static constexpr Tagged_t kceil_string = 0x33d9;
  static constexpr Tagged_t kcompare_string = 0x33e9;
  static constexpr Tagged_t kcollation_string = 0x33fd;
  static constexpr Tagged_t kcollations_string = 0x3415;
  static constexpr Tagged_t kcompact_string = 0x342d;
  static constexpr Tagged_t kcompactDisplay_string = 0x3441;
  static constexpr Tagged_t kcurrency_string = 0x345d;
  static constexpr Tagged_t kcurrencyDisplay_string = 0x3471;
  static constexpr Tagged_t kcurrencySign_string = 0x348d;
  static constexpr Tagged_t kdateStyle_string = 0x34a5;
  static constexpr Tagged_t kdateTimeField_string = 0x34bd;
  static constexpr Tagged_t kdayPeriod_string = 0x34d9;
  static constexpr Tagged_t kdaysDisplay_string = 0x34f1;
  static constexpr Tagged_t kdecimal_string = 0x3509;
  static constexpr Tagged_t kdialect_string = 0x351d;
  static constexpr Tagged_t kdigital_string = 0x3531;
  static constexpr Tagged_t kdirection_string = 0x3545;
  static constexpr Tagged_t kendRange_string = 0x355d;
  static constexpr Tagged_t kengineering_string = 0x3571;
  static constexpr Tagged_t kexceptZero_string = 0x3589;
  static constexpr Tagged_t kexpand_string = 0x35a1;
  static constexpr Tagged_t kexponentInteger_string = 0x35b5;
  static constexpr Tagged_t kexponentMinusSign_string = 0x35d1;
  static constexpr Tagged_t kexponentSeparator_string = 0x35f1;
  static constexpr Tagged_t kfallback_string = 0x3611;
  static constexpr Tagged_t kfirst_string = 0x3625;
  static constexpr Tagged_t kfirstDay_string = 0x3639;
  static constexpr Tagged_t kfloor_string = 0x364d;
  static constexpr Tagged_t kformat_string = 0x3661;
  static constexpr Tagged_t kfraction_string = 0x3675;
  static constexpr Tagged_t kfractionalDigits_string = 0x3689;
  static constexpr Tagged_t kfractionalSecond_string = 0x36a5;
  static constexpr Tagged_t kfull_string = 0x36c1;
  static constexpr Tagged_t kgranularity_string = 0x36d1;
  static constexpr Tagged_t kgrapheme_string = 0x36e9;
  static constexpr Tagged_t kgroup_string = 0x36fd;
  static constexpr Tagged_t kh11_string = 0x3711;
  static constexpr Tagged_t kh12_string = 0x3721;
  static constexpr Tagged_t kh23_string = 0x3731;
  static constexpr Tagged_t kh24_string = 0x3741;
  static constexpr Tagged_t khalfCeil_string = 0x3751;
  static constexpr Tagged_t khalfEven_string = 0x3765;
  static constexpr Tagged_t khalfExpand_string = 0x3779;
  static constexpr Tagged_t khalfFloor_string = 0x3791;
  static constexpr Tagged_t khalfTrunc_string = 0x37a9;
  static constexpr Tagged_t khour12_string = 0x37c1;
  static constexpr Tagged_t khourCycle_string = 0x37d5;
  static constexpr Tagged_t khourCycles_string = 0x37ed;
  static constexpr Tagged_t khoursDisplay_string = 0x3805;
  static constexpr Tagged_t kideo_string = 0x381d;
  static constexpr Tagged_t kignorePunctuation_string = 0x382d;
  static constexpr Tagged_t kInvalid_Date_string = 0x384d;
  static constexpr Tagged_t kinteger_string = 0x3865;
  static constexpr Tagged_t kisWordLike_string = 0x3879;
  static constexpr Tagged_t kkana_string = 0x3891;
  static constexpr Tagged_t klanguage_string = 0x38a1;
  static constexpr Tagged_t klanguageDisplay_string = 0x38b5;
  static constexpr Tagged_t klessPrecision_string = 0x38d1;
  static constexpr Tagged_t kletter_string = 0x38ed;
  static constexpr Tagged_t klist_string = 0x3901;
  static constexpr Tagged_t kliteral_string = 0x3911;
  static constexpr Tagged_t klocale_string = 0x3925;
  static constexpr Tagged_t kloose_string = 0x3939;
  static constexpr Tagged_t klower_string = 0x394d;
  static constexpr Tagged_t kltr_string = 0x3961;
  static constexpr Tagged_t kmaximumFractionDigits_string = 0x3971;
  static constexpr Tagged_t kmaximumSignificantDigits_string = 0x3995;
  static constexpr Tagged_t kmicrosecondsDisplay_string = 0x39b9;
  static constexpr Tagged_t kmillisecondsDisplay_string = 0x39d9;
  static constexpr Tagged_t kmin2_string = 0x39f9;
  static constexpr Tagged_t kminimalDays_string = 0x3a09;
  static constexpr Tagged_t kminimumFractionDigits_string = 0x3a21;
  static constexpr Tagged_t kminimumIntegerDigits_string = 0x3a45;
  static constexpr Tagged_t kminimumSignificantDigits_string = 0x3a65;
  static constexpr Tagged_t kminus_0 = 0x3a89;
  static constexpr Tagged_t kminusSign_string = 0x3a99;
  static constexpr Tagged_t kminutesDisplay_string = 0x3ab1;
  static constexpr Tagged_t kmonthsDisplay_string = 0x3acd;
  static constexpr Tagged_t kmorePrecision_string = 0x3ae9;
  static constexpr Tagged_t knan_string = 0x3b05;
  static constexpr Tagged_t knanosecondsDisplay_string = 0x3b15;
  static constexpr Tagged_t knarrowSymbol_string = 0x3b35;
  static constexpr Tagged_t knegative_string = 0x3b4d;
  static constexpr Tagged_t knever_string = 0x3b61;
  static constexpr Tagged_t knone_string = 0x3b75;
  static constexpr Tagged_t knotation_string = 0x3b85;
  static constexpr Tagged_t knormal_string = 0x3b99;
  static constexpr Tagged_t knumberingSystem_string = 0x3bad;
  static constexpr Tagged_t knumberingSystems_string = 0x3bc9;
  static constexpr Tagged_t knumeric_string = 0x3be5;
  static constexpr Tagged_t kordinal_string = 0x3bf9;
  static constexpr Tagged_t kpercentSign_string = 0x3c0d;
  static constexpr Tagged_t kplusSign_string = 0x3c25;
  static constexpr Tagged_t kquarter_string = 0x3c39;
  static constexpr Tagged_t kregion_string = 0x3c4d;
  static constexpr Tagged_t krelatedYear_string = 0x3c61;
  static constexpr Tagged_t kroundingMode_string = 0x3c79;
  static constexpr Tagged_t kroundingPriority_string = 0x3c91;
  static constexpr Tagged_t krtl_string = 0x3cad;
  static constexpr Tagged_t kscientific_string = 0x3cbd;
  static constexpr Tagged_t ksecondsDisplay_string = 0x3cd5;
  static constexpr Tagged_t ksegment_string = 0x3cf1;
  static constexpr Tagged_t kSegmentIterator_string = 0x3d05;
  static constexpr Tagged_t kSegments_string = 0x3d21;
  static constexpr Tagged_t ksensitivity_string = 0x3d35;
  static constexpr Tagged_t ksep_string = 0x3d4d;
  static constexpr Tagged_t kshared_string = 0x3d5d;
  static constexpr Tagged_t ksignDisplay_string = 0x3d71;
  static constexpr Tagged_t kstandard_string = 0x3d89;
  static constexpr Tagged_t kstartRange_string = 0x3d9d;
  static constexpr Tagged_t kstrict_string = 0x3db5;
  static constexpr Tagged_t kstripIfInteger_string = 0x3dc9;
  static constexpr Tagged_t kstyle_string = 0x3de5;
  static constexpr Tagged_t kterm_string = 0x3df9;
  static constexpr Tagged_t ktextInfo_string = 0x3e09;
  static constexpr Tagged_t ktimeStyle_string = 0x3e1d;
  static constexpr Tagged_t ktimeZones_string = 0x3e35;
  static constexpr Tagged_t ktimeZoneName_string = 0x3e4d;
  static constexpr Tagged_t ktrailingZeroDisplay_string = 0x3e65;
  static constexpr Tagged_t ktrunc_string = 0x3e85;
  static constexpr Tagged_t ktwo_digit_string = 0x3e99;
  static constexpr Tagged_t ktype_string = 0x3ead;
  static constexpr Tagged_t kunknown_string = 0x3ebd;
  static constexpr Tagged_t kupper_string = 0x3ed1;
  static constexpr Tagged_t kusage_string = 0x3ee5;
  static constexpr Tagged_t kuseGrouping_string = 0x3ef9;
  static constexpr Tagged_t kunitDisplay_string = 0x3f11;
  static constexpr Tagged_t kweekday_string = 0x3f29;
  static constexpr Tagged_t kweekend_string = 0x3f3d;
  static constexpr Tagged_t kweeksDisplay_string = 0x3f51;
  static constexpr Tagged_t kweekInfo_string = 0x3f69;
  static constexpr Tagged_t kyearName_string = 0x3f7d;
  static constexpr Tagged_t kyearsDisplay_string = 0x3f91;
  static constexpr Tagged_t kadd_string = 0x3fa9;
  static constexpr Tagged_t kAggregateError_string = 0x3fb9;
  static constexpr Tagged_t kalways_string = 0x3fd5;
  static constexpr Tagged_t kanonymous_function_string = 0x3fe9;
  static constexpr Tagged_t kanonymous_string = 0x4009;
  static constexpr Tagged_t kapply_string = 0x4021;
  static constexpr Tagged_t kArguments_string = 0x4035;
  static constexpr Tagged_t karguments_string = 0x404d;
  static constexpr Tagged_t karguments_to_string = 0x4065;
  static constexpr Tagged_t kArray_string = 0x4085;
  static constexpr Tagged_t karray_to_string = 0x4099;
  static constexpr Tagged_t kArrayBuffer_string = 0x40b5;
  static constexpr Tagged_t kArrayIterator_string = 0x40cd;
  static constexpr Tagged_t kas_string = 0x40e9;
  static constexpr Tagged_t kassert_string = 0x40f9;
  static constexpr Tagged_t kasync_string = 0x410d;
  static constexpr Tagged_t kAtomicsCondition_string = 0x4121;
  static constexpr Tagged_t kAtomicsMutex_string = 0x4141;
  static constexpr Tagged_t kauto_string = 0x415d;
  static constexpr Tagged_t kawait_string = 0x416d;
  static constexpr Tagged_t kBigInt_string = 0x4181;
  static constexpr Tagged_t kbigint_string = 0x4195;
  static constexpr Tagged_t kBigInt64Array_string = 0x41a9;
  static constexpr Tagged_t kBigUint64Array_string = 0x41c5;
  static constexpr Tagged_t kbind_string = 0x41e1;
  static constexpr Tagged_t kblank_string = 0x41f1;
  static constexpr Tagged_t kBoolean_string = 0x4205;
  static constexpr Tagged_t kboolean_string = 0x4219;
  static constexpr Tagged_t kboolean_to_string = 0x422d;
  static constexpr Tagged_t kbound__string = 0x4249;
  static constexpr Tagged_t kbuffer_string = 0x425d;
  static constexpr Tagged_t kbyte_length_string = 0x4271;
  static constexpr Tagged_t kbyte_offset_string = 0x4289;
  static constexpr Tagged_t kCompileError_string = 0x42a1;
  static constexpr Tagged_t kcalendar_string = 0x42b9;
  static constexpr Tagged_t kcallee_string = 0x42cd;
  static constexpr Tagged_t kcaller_string = 0x42e1;
  static constexpr Tagged_t kcause_string = 0x42f5;
  static constexpr Tagged_t kcharacter_string = 0x4309;
  static constexpr Tagged_t kclosure_string = 0x4321;
  static constexpr Tagged_t kcode_string = 0x4339;
  static constexpr Tagged_t kcolumn_string = 0x4349;
  static constexpr Tagged_t kcomputed_string = 0x435d;
  static constexpr Tagged_t kconfigurable_string = 0x4375;
  static constexpr Tagged_t kconjunction_string = 0x438d;
  static constexpr Tagged_t kconsole_string = 0x43a5;
  static constexpr Tagged_t kconstrain_string = 0x43b9;
  static constexpr Tagged_t kconstruct_string = 0x43d1;
  static constexpr Tagged_t kcurrent_string = 0x43e9;
  static constexpr Tagged_t kDate_string = 0x43fd;
  static constexpr Tagged_t kdate_to_string = 0x440d;
  static constexpr Tagged_t kdateAdd_string = 0x4429;
  static constexpr Tagged_t kdateFromFields_string = 0x443d;
  static constexpr Tagged_t kdateUntil_string = 0x4459;
  static constexpr Tagged_t kday_string = 0x4471;
  static constexpr Tagged_t kdayOfWeek_string = 0x4481;
  static constexpr Tagged_t kdayOfYear_string = 0x4499;
  static constexpr Tagged_t kdays_string = 0x44b1;
  static constexpr Tagged_t kdaysInMonth_string = 0x44c1;
  static constexpr Tagged_t kdaysInWeek_string = 0x44d9;
  static constexpr Tagged_t kdaysInYear_string = 0x44f1;
  static constexpr Tagged_t kdefault_string = 0x4509;
  static constexpr Tagged_t kdefineProperty_string = 0x451d;
  static constexpr Tagged_t kdeleteProperty_string = 0x4539;
  static constexpr Tagged_t kdetached_string = 0x4555;
  static constexpr Tagged_t kdisjunction_string = 0x4569;
  static constexpr Tagged_t kdone_string = 0x4581;
  static constexpr Tagged_t kdot_brand_string = 0x4591;
  static constexpr Tagged_t kdot_catch_string = 0x45a5;
  static constexpr Tagged_t kdot_default_string = 0x45b9;
  static constexpr Tagged_t kdot_for_string = 0x45cd;
  static constexpr Tagged_t kdot_generator_object_string = 0x45dd;
  static constexpr Tagged_t kdot_home_object_string = 0x45fd;
  static constexpr Tagged_t kdot_new_target_string = 0x4615;
  static constexpr Tagged_t knew_target_string = 0x4615;
  static constexpr Tagged_t kdot_result_string = 0x462d;
  static constexpr Tagged_t kdot_repl_result_string = 0x4641;
  static constexpr Tagged_t kdot_static_home_object_string = 0x4659;
  static constexpr Tagged_t kdot_switch_tag_string = 0x4679;
  static constexpr Tagged_t kdotAll_string = 0x4691;
  static constexpr Tagged_t kError_string = 0x46a5;
  static constexpr Tagged_t kEvalError_string = 0x46b9;
  static constexpr Tagged_t kenumerable_string = 0x46d1;
  static constexpr Tagged_t kelement_string = 0x46e9;
  static constexpr Tagged_t kepochMicroseconds_string = 0x46fd;
  static constexpr Tagged_t kepochMilliseconds_string = 0x471d;
  static constexpr Tagged_t kepochNanoseconds_string = 0x473d;
  static constexpr Tagged_t kepochSeconds_string = 0x4759;
  static constexpr Tagged_t kera_string = 0x4771;
  static constexpr Tagged_t keraYear_string = 0x4781;
  static constexpr Tagged_t kerrors_string = 0x4795;
  static constexpr Tagged_t kerror_to_string = 0x47a9;
  static constexpr Tagged_t keval_string = 0x47c5;
  static constexpr Tagged_t kexception_string = 0x47d5;
  static constexpr Tagged_t kexec_string = 0x47ed;
  static constexpr Tagged_t kfalse_string = 0x47fd;
  static constexpr Tagged_t kfields_string = 0x4811;
  static constexpr Tagged_t kFinalizationRegistry_string = 0x4825;
  static constexpr Tagged_t kflags_string = 0x4845;
  static constexpr Tagged_t kFloat32Array_string = 0x4859;
  static constexpr Tagged_t kFloat64Array_string = 0x4871;
  static constexpr Tagged_t kfractionalSecondDigits_string = 0x4889;
  static constexpr Tagged_t kfrom_string = 0x48ad;
  static constexpr Tagged_t kFunction_string = 0x48bd;
  static constexpr Tagged_t kfunction_native_code_string = 0x48d1;
  static constexpr Tagged_t kfunction_string = 0x48fd;
  static constexpr Tagged_t kfunction_to_string = 0x4911;
  static constexpr Tagged_t kGenerator_string = 0x4931;
  static constexpr Tagged_t kget_space_string = 0x4949;
  static constexpr Tagged_t kget_string = 0x4959;
  static constexpr Tagged_t kgetOffsetNanosecondsFor_string = 0x4969;
  static constexpr Tagged_t kgetOwnPropertyDescriptor_string = 0x498d;
  static constexpr Tagged_t kgetPossibleInstantsFor_string = 0x49b1;
  static constexpr Tagged_t kgetPrototypeOf_string = 0x49d5;
  static constexpr Tagged_t kglobal_string = 0x49f1;
  static constexpr Tagged_t kglobalThis_string = 0x4a05;
  static constexpr Tagged_t kgroups_string = 0x4a1d;
  static constexpr Tagged_t kgrowable_string = 0x4a31;
  static constexpr Tagged_t khas_string = 0x4a45;
  static constexpr Tagged_t khasIndices_string = 0x4a55;
  static constexpr Tagged_t khour_string = 0x4a6d;
  static constexpr Tagged_t khours_string = 0x4a7d;
  static constexpr Tagged_t khoursInDay_string = 0x4a91;
  static constexpr Tagged_t kignoreCase_string = 0x4aa9;
  static constexpr Tagged_t kid_string = 0x4ac1;
  static constexpr Tagged_t killegal_access_string = 0x4ad1;
  static constexpr Tagged_t killegal_argument_string = 0x4aed;
  static constexpr Tagged_t kinLeapYear_string = 0x4b09;
  static constexpr Tagged_t kindex_string = 0x4b21;
  static constexpr Tagged_t kindices_string = 0x4b35;
  static constexpr Tagged_t kInfinity_string = 0x4b49;
  static constexpr Tagged_t kinfinity_string = 0x4b5d;
  static constexpr Tagged_t kinput_string = 0x4b71;
  static constexpr Tagged_t kInt16Array_string = 0x4b85;
  static constexpr Tagged_t kInt32Array_string = 0x4b9d;
  static constexpr Tagged_t kInt8Array_string = 0x4bb5;
  static constexpr Tagged_t kisExtensible_string = 0x4bcd;
  static constexpr Tagged_t kiso8601_string = 0x4be5;
  static constexpr Tagged_t kisoDay_string = 0x4bf9;
  static constexpr Tagged_t kisoHour_string = 0x4c0d;
  static constexpr Tagged_t kisoMicrosecond_string = 0x4c21;
  static constexpr Tagged_t kisoMillisecond_string = 0x4c3d;
  static constexpr Tagged_t kisoMinute_string = 0x4c59;
  static constexpr Tagged_t kisoMonth_string = 0x4c71;
  static constexpr Tagged_t kisoNanosecond_string = 0x4c85;
  static constexpr Tagged_t kisoSecond_string = 0x4ca1;
  static constexpr Tagged_t kisoYear_string = 0x4cb9;
  static constexpr Tagged_t kjsMemoryEstimate_string = 0x4ccd;
  static constexpr Tagged_t kjsMemoryRange_string = 0x4ce9;
  static constexpr Tagged_t kkeys_string = 0x4d05;
  static constexpr Tagged_t klargestUnit_string = 0x4d15;
  static constexpr Tagged_t klastIndex_string = 0x4d2d;
  static constexpr Tagged_t klength_string = 0x4d45;
  static constexpr Tagged_t klet_string = 0x4d59;
  static constexpr Tagged_t kline_string = 0x4d69;
  static constexpr Tagged_t klinear_string = 0x4d79;
  static constexpr Tagged_t kLinkError_string = 0x4d8d;
  static constexpr Tagged_t klong_string = 0x4da5;
  static constexpr Tagged_t kMap_string = 0x4db5;
  static constexpr Tagged_t kMapIterator_string = 0x4dc5;
  static constexpr Tagged_t kmax_byte_length_string = 0x4ddd;
  static constexpr Tagged_t kmedium_string = 0x4df9;
  static constexpr Tagged_t kmergeFields_string = 0x4e0d;
  static constexpr Tagged_t kmessage_string = 0x4e25;
  static constexpr Tagged_t kmeta_string = 0x4e39;
  static constexpr Tagged_t kminus_Infinity_string = 0x4e49;
  static constexpr Tagged_t kmicrosecond_string = 0x4e61;
  static constexpr Tagged_t kmicroseconds_string = 0x4e79;
  static constexpr Tagged_t kmillisecond_string = 0x4e91;
  static constexpr Tagged_t kmilliseconds_string = 0x4ea9;
  static constexpr Tagged_t kminute_string = 0x4ec1;
  static constexpr Tagged_t kminutes_string = 0x4ed5;
  static constexpr Tagged_t kModule_string = 0x4ee9;
  static constexpr Tagged_t kmonth_string = 0x4efd;
  static constexpr Tagged_t kmonthDayFromFields_string = 0x4f11;
  static constexpr Tagged_t kmonths_string = 0x4f31;
  static constexpr Tagged_t kmonthsInYear_string = 0x4f45;
  static constexpr Tagged_t kmonthCode_string = 0x4f5d;
  static constexpr Tagged_t kmultiline_string = 0x4f75;
  static constexpr Tagged_t kname_string = 0x4f8d;
  static constexpr Tagged_t kNaN_string = 0x4f9d;
  static constexpr Tagged_t knanosecond_string = 0x4fad;
  static constexpr Tagged_t knanoseconds_string = 0x4fc5;
  static constexpr Tagged_t knarrow_string = 0x4fdd;
  static constexpr Tagged_t knative_string = 0x4ff1;
  static constexpr Tagged_t kNFC_string = 0x5005;
  static constexpr Tagged_t kNFD_string = 0x5015;
  static constexpr Tagged_t kNFKC_string = 0x5025;
  static constexpr Tagged_t kNFKD_string = 0x5035;
  static constexpr Tagged_t knot_equal_string = 0x5045;
  static constexpr Tagged_t knull_string = 0x505d;
  static constexpr Tagged_t knull_to_string = 0x506d;
  static constexpr Tagged_t kNumber_string = 0x5089;
  static constexpr Tagged_t knumber_string = 0x509d;
  static constexpr Tagged_t knumber_to_string = 0x50b1;
  static constexpr Tagged_t kObject_string = 0x50cd;
  static constexpr Tagged_t kobject_string = 0x50e1;
  static constexpr Tagged_t kobject_to_string = 0x50f5;
  static constexpr Tagged_t kof_string = 0x5111;
  static constexpr Tagged_t koffset_string = 0x5121;
  static constexpr Tagged_t koffsetNanoseconds_string = 0x5135;
  static constexpr Tagged_t kok_string = 0x5155;
  static constexpr Tagged_t kother_string = 0x5165;
  static constexpr Tagged_t koverflow_string = 0x5179;
  static constexpr Tagged_t kownKeys_string = 0x518d;
  static constexpr Tagged_t kpercent_string = 0x51a1;
  static constexpr Tagged_t kplainDate_string = 0x51b5;
  static constexpr Tagged_t kplainTime_string = 0x51cd;
  static constexpr Tagged_t kposition_string = 0x51e5;
  static constexpr Tagged_t kpreventExtensions_string = 0x51f9;
  static constexpr Tagged_t kprivate_constructor_string = 0x5219;
  static constexpr Tagged_t kPromise_string = 0x5231;
  static constexpr Tagged_t kproto_string = 0x5245;
  static constexpr Tagged_t kprototype_string = 0x525d;
  static constexpr Tagged_t kproxy_string = 0x5275;
  static constexpr Tagged_t kProxy_string = 0x5289;
  static constexpr Tagged_t kquery_colon_string = 0x529d;
  static constexpr Tagged_t kRangeError_string = 0x52ad;
  static constexpr Tagged_t kraw_json_string = 0x52c5;
  static constexpr Tagged_t kraw_string = 0x52d9;
  static constexpr Tagged_t kReferenceError_string = 0x52e9;
  static constexpr Tagged_t kReflectGet_string = 0x5305;
  static constexpr Tagged_t kReflectHas_string = 0x531d;
  static constexpr Tagged_t kRegExp_string = 0x5335;
  static constexpr Tagged_t kregexp_to_string = 0x5349;
  static constexpr Tagged_t kreject_string = 0x5365;
  static constexpr Tagged_t krelativeTo_string = 0x5379;
  static constexpr Tagged_t kresizable_string = 0x5391;
  static constexpr Tagged_t kResizableArrayBuffer_string = 0x53a9;
  static constexpr Tagged_t kreturn_string = 0x53c9;
  static constexpr Tagged_t krevoke_string = 0x53dd;
  static constexpr Tagged_t kroundingIncrement_string = 0x53f1;
  static constexpr Tagged_t kRuntimeError_string = 0x5411;
  static constexpr Tagged_t kWebAssemblyException_string = 0x5429;
  static constexpr Tagged_t kScript_string = 0x544d;
  static constexpr Tagged_t kscript_string = 0x5461;
  static constexpr Tagged_t ksecond_string = 0x5475;
  static constexpr Tagged_t kseconds_string = 0x5489;
  static constexpr Tagged_t kshort_string = 0x549d;
  static constexpr Tagged_t kSet_string = 0x54b1;
  static constexpr Tagged_t ksentence_string = 0x54c1;
  static constexpr Tagged_t kset_space_string = 0x54d5;
  static constexpr Tagged_t kset_string = 0x54e5;
  static constexpr Tagged_t kSetIterator_string = 0x54f5;
  static constexpr Tagged_t ksetPrototypeOf_string = 0x550d;
  static constexpr Tagged_t kShadowRealm_string = 0x5529;
  static constexpr Tagged_t kSharedArray_string = 0x5541;
  static constexpr Tagged_t kSharedArrayBuffer_string = 0x5559;
  static constexpr Tagged_t kSharedStruct_string = 0x5579;
  static constexpr Tagged_t ksign_string = 0x5591;
  static constexpr Tagged_t ksmallestUnit_string = 0x55a1;
  static constexpr Tagged_t ksource_string = 0x55b9;
  static constexpr Tagged_t ksourceText_string = 0x55cd;
  static constexpr Tagged_t kstack_string = 0x55e5;
  static constexpr Tagged_t kstackTraceLimit_string = 0x55f9;
  static constexpr Tagged_t ksticky_string = 0x5615;
  static constexpr Tagged_t kString_string = 0x5629;
  static constexpr Tagged_t kstring_string = 0x563d;
  static constexpr Tagged_t kstring_to_string = 0x5651;
  static constexpr Tagged_t kSymbol_iterator_string = 0x566d;
  static constexpr Tagged_t kSymbol_replace_string = 0x5689;
  static constexpr Tagged_t ksymbol_species_string = 0x56a5;
  static constexpr Tagged_t kSymbol_species_string = 0x56c1;
  static constexpr Tagged_t kSymbol_string = 0x56dd;
  static constexpr Tagged_t ksymbol_string = 0x56f1;
  static constexpr Tagged_t kSyntaxError_string = 0x5705;
  static constexpr Tagged_t ktarget_string = 0x571d;
  static constexpr Tagged_t kthis_function_string = 0x5731;
  static constexpr Tagged_t kthis_string = 0x574d;
  static constexpr Tagged_t kthrow_string = 0x575d;
  static constexpr Tagged_t ktimed_out_string = 0x5771;
  static constexpr Tagged_t ktimeZone_string = 0x5789;
  static constexpr Tagged_t ktoJSON_string = 0x579d;
  static constexpr Tagged_t ktoString_string = 0x57b1;
  static constexpr Tagged_t ktrue_string = 0x57c5;
  static constexpr Tagged_t ktotal_string = 0x57d5;
  static constexpr Tagged_t kTypeError_string = 0x57e9;
  static constexpr Tagged_t kUint16Array_string = 0x5801;
  static constexpr Tagged_t kUint32Array_string = 0x5819;
  static constexpr Tagged_t kUint8Array_string = 0x5831;
  static constexpr Tagged_t kUint8ClampedArray_string = 0x5849;
  static constexpr Tagged_t kundefined_string = 0x5869;
  static constexpr Tagged_t kundefined_to_string = 0x5881;
  static constexpr Tagged_t kunicode_string = 0x58a1;
  static constexpr Tagged_t kunicodeSets_string = 0x58b5;
  static constexpr Tagged_t kunit_string = 0x58cd;
  static constexpr Tagged_t kURIError_string = 0x58dd;
  static constexpr Tagged_t kUTC_string = 0x58f1;
  static constexpr Tagged_t kvalue_string = 0x5901;
  static constexpr Tagged_t kvalueOf_string = 0x5915;
  static constexpr Tagged_t kWeakMap_string = 0x5929;
  static constexpr Tagged_t kWeakRef_string = 0x593d;
  static constexpr Tagged_t kWeakSet_string = 0x5951;
  static constexpr Tagged_t kweek_string = 0x5965;
  static constexpr Tagged_t kweeks_string = 0x5975;
  static constexpr Tagged_t kweekOfYear_string = 0x5989;
  static constexpr Tagged_t kword_string = 0x59a1;
  static constexpr Tagged_t kwritable_string = 0x59b1;
  static constexpr Tagged_t kyearMonthFromFields_string = 0x59c5;
  static constexpr Tagged_t kyear_string = 0x59e5;
  static constexpr Tagged_t kyears_string = 0x59f5;
  static constexpr Tagged_t kUninitializedValue = 0x5a19;
  static constexpr Tagged_t kArgumentsMarker = 0x5a51;
  static constexpr Tagged_t kTerminationException = 0x5a89;
  static constexpr Tagged_t kException = 0x5ac9;
  static constexpr Tagged_t kOptimizedOut = 0x5ae5;
  static constexpr Tagged_t kStaleRegister = 0x5b1d;
  static constexpr Tagged_t kSelfReferenceMarker = 0x5b55;
  static constexpr Tagged_t kBasicBlockCountersMarker = 0x5b95;
  static constexpr Tagged_t karray_buffer_wasm_memory_symbol = 0x5bd9;
  static constexpr Tagged_t kcall_site_info_symbol = 0x5be9;
  static constexpr Tagged_t kconsole_context_id_symbol = 0x5bf9;
  static constexpr Tagged_t kconsole_context_name_symbol = 0x5c09;
  static constexpr Tagged_t kclass_fields_symbol = 0x5c19;
  static constexpr Tagged_t kclass_positions_symbol = 0x5c29;
  static constexpr Tagged_t kelements_transition_symbol = 0x5c39;
  static constexpr Tagged_t kerror_end_pos_symbol = 0x5c49;
  static constexpr Tagged_t kerror_script_symbol = 0x5c59;
  static constexpr Tagged_t kerror_stack_symbol = 0x5c69;
  static constexpr Tagged_t kerror_start_pos_symbol = 0x5c79;
  static constexpr Tagged_t kfrozen_symbol = 0x5c89;
  static constexpr Tagged_t kinterpreter_trampoline_symbol = 0x5c99;
  static constexpr Tagged_t kmega_dom_symbol = 0x5ca9;
  static constexpr Tagged_t kmegamorphic_symbol = 0x5cb9;
  static constexpr Tagged_t knative_context_index_symbol = 0x5cc9;
  static constexpr Tagged_t knonextensible_symbol = 0x5cd9;
  static constexpr Tagged_t knot_mapped_symbol = 0x5ce9;
  static constexpr Tagged_t kpromise_debug_marker_symbol = 0x5cf9;
  static constexpr Tagged_t kpromise_debug_message_symbol = 0x5d09;
  static constexpr Tagged_t kpromise_forwarding_handler_symbol = 0x5d19;
  static constexpr Tagged_t kpromise_handled_by_symbol = 0x5d29;
  static constexpr Tagged_t kpromise_awaited_by_symbol = 0x5d39;
  static constexpr Tagged_t kregexp_result_names_symbol = 0x5d49;
  static constexpr Tagged_t kregexp_result_regexp_input_symbol = 0x5d59;
  static constexpr Tagged_t kregexp_result_regexp_last_index_symbol = 0x5d69;
  static constexpr Tagged_t ksealed_symbol = 0x5d79;
  static constexpr Tagged_t kstrict_function_transition_symbol = 0x5d89;
  static constexpr Tagged_t ktemplate_literal_function_literal_id_symbol =
      0x5d99;
  static constexpr Tagged_t ktemplate_literal_slot_id_symbol = 0x5da9;
  static constexpr Tagged_t kwasm_exception_tag_symbol = 0x5db9;
  static constexpr Tagged_t kwasm_exception_values_symbol = 0x5dc9;
  static constexpr Tagged_t kwasm_uncatchable_symbol = 0x5dd9;
  static constexpr Tagged_t kwasm_wrapped_object_symbol = 0x5de9;
  static constexpr Tagged_t kwasm_debug_proxy_cache_symbol = 0x5df9;
  static constexpr Tagged_t kwasm_debug_proxy_names_symbol = 0x5e09;
  static constexpr Tagged_t kuninitialized_symbol = 0x5e19;
  static constexpr Tagged_t kasync_iterator_symbol = 0x5e29;
  static constexpr Tagged_t kintl_fallback_symbol = 0x5e59;
  static constexpr Tagged_t kmatch_all_symbol = 0x5e91;
  static constexpr Tagged_t kmatch_symbol = 0x5ebd;
  static constexpr Tagged_t ksearch_symbol = 0x5ee5;
  static constexpr Tagged_t ksplit_symbol = 0x5f11;
  static constexpr Tagged_t kto_primitive_symbol = 0x5f39;
  static constexpr Tagged_t kunscopables_symbol = 0x5f69;
  static constexpr Tagged_t khas_instance_symbol = 0x5f99;
  static constexpr Tagged_t kto_string_tag_symbol = 0x5fc9;
  static constexpr Tagged_t kconstructor_string = 0x6021;
  static constexpr Tagged_t knext_string = 0x6039;
  static constexpr Tagged_t kresolve_string = 0x6049;
  static constexpr Tagged_t kthen_string = 0x605d;
  static constexpr Tagged_t kiterator_symbol = 0x606d;
  static constexpr Tagged_t kreplace_symbol = 0x607d;
  static constexpr Tagged_t kspecies_symbol = 0x608d;
  static constexpr Tagged_t kis_concat_spreadable_symbol = 0x609d;
  static constexpr Tagged_t kEmptyPropertyDictionary = 0x60ad;
  static constexpr Tagged_t kEmptySymbolTable = 0x60d9;
  static constexpr Tagged_t kEmptySlowElementDictionary = 0x60f5;
  static constexpr Tagged_t kEmptyOrderedHashMap = 0x6119;
  static constexpr Tagged_t kEmptyOrderedHashSet = 0x612d;
  static constexpr Tagged_t kEmptyOrderedPropertyDictionary = 0x6141;
  static constexpr Tagged_t kEmptySwissPropertyDictionary = 0x6165;
  static constexpr Tagged_t kEmptyFeedbackMetadata = 0x6185;
  static constexpr Tagged_t kGlobalThisBindingScopeInfo = 0x6191;
  static constexpr Tagged_t kEmptyFunctionScopeInfo = 0x61b1;
  static constexpr Tagged_t kNativeScopeInfo = 0x61d5;
  static constexpr Tagged_t kShadowRealmScopeInfo = 0x61ed;
  static constexpr Tagged_t kWasmNull = 0xfffd;
};

static constexpr std::array<Tagged_t, 737> StaticReadOnlyRootsPointerTable = {
    StaticReadOnlyRoot::kFreeSpaceMap,
    StaticReadOnlyRoot::kOnePointerFillerMap,
    StaticReadOnlyRoot::kTwoPointerFillerMap,
    StaticReadOnlyRoot::kUninitializedValue,
    StaticReadOnlyRoot::kUndefinedValue,
    StaticReadOnlyRoot::kTheHoleValue,
    StaticReadOnlyRoot::kNullValue,
    StaticReadOnlyRoot::kTrueValue,
    StaticReadOnlyRoot::kFalseValue,
    StaticReadOnlyRoot::kempty_string,
    StaticReadOnlyRoot::kMetaMap,
    StaticReadOnlyRoot::kByteArrayMap,
    StaticReadOnlyRoot::kFixedArrayMap,
    StaticReadOnlyRoot::kFixedCOWArrayMap,
    StaticReadOnlyRoot::kFixedDoubleArrayMap,
    StaticReadOnlyRoot::kHashTableMap,
    StaticReadOnlyRoot::kSymbolMap,
    StaticReadOnlyRoot::kOneByteStringMap,
    StaticReadOnlyRoot::kOneByteInternalizedStringMap,
    StaticReadOnlyRoot::kScopeInfoMap,
    StaticReadOnlyRoot::kSharedFunctionInfoMap,
    StaticReadOnlyRoot::kInstructionStreamMap,
    StaticReadOnlyRoot::kCellMap,
    StaticReadOnlyRoot::kGlobalPropertyCellMap,
    StaticReadOnlyRoot::kForeignMap,
    StaticReadOnlyRoot::kHeapNumberMap,
    StaticReadOnlyRoot::kTransitionArrayMap,
    StaticReadOnlyRoot::kFeedbackVectorMap,
    StaticReadOnlyRoot::kEmptyScopeInfo,
    StaticReadOnlyRoot::kEmptyFixedArray,
    StaticReadOnlyRoot::kEmptyDescriptorArray,
    StaticReadOnlyRoot::kArgumentsMarker,
    StaticReadOnlyRoot::kException,
    StaticReadOnlyRoot::kTerminationException,
    StaticReadOnlyRoot::kOptimizedOut,
    StaticReadOnlyRoot::kStaleRegister,
    StaticReadOnlyRoot::kScriptContextTableMap,
    StaticReadOnlyRoot::kClosureFeedbackCellArrayMap,
    StaticReadOnlyRoot::kFeedbackMetadataArrayMap,
    StaticReadOnlyRoot::kArrayListMap,
    StaticReadOnlyRoot::kBigIntMap,
    StaticReadOnlyRoot::kObjectBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kBytecodeArrayMap,
    StaticReadOnlyRoot::kCodeMap,
    StaticReadOnlyRoot::kCoverageInfoMap,
    StaticReadOnlyRoot::kGlobalDictionaryMap,
    StaticReadOnlyRoot::kManyClosuresCellMap,
    StaticReadOnlyRoot::kMegaDomHandlerMap,
    StaticReadOnlyRoot::kModuleInfoMap,
    StaticReadOnlyRoot::kNameDictionaryMap,
    StaticReadOnlyRoot::kNoClosuresCellMap,
    StaticReadOnlyRoot::kNumberDictionaryMap,
    StaticReadOnlyRoot::kOneClosureCellMap,
    StaticReadOnlyRoot::kOrderedHashMapMap,
    StaticReadOnlyRoot::kOrderedHashSetMap,
    StaticReadOnlyRoot::kNameToIndexHashTableMap,
    StaticReadOnlyRoot::kRegisteredSymbolTableMap,
    StaticReadOnlyRoot::kOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kPreparseDataMap,
    StaticReadOnlyRoot::kPropertyArrayMap,
    StaticReadOnlyRoot::kAccessorInfoMap,
    StaticReadOnlyRoot::kSideEffectCallHandlerInfoMap,
    StaticReadOnlyRoot::kSideEffectFreeCallHandlerInfoMap,
    StaticReadOnlyRoot::kNextCallSideEffectFreeCallHandlerInfoMap,
    StaticReadOnlyRoot::kSimpleNumberDictionaryMap,
    StaticReadOnlyRoot::kSmallOrderedHashMapMap,
    StaticReadOnlyRoot::kSmallOrderedHashSetMap,
    StaticReadOnlyRoot::kSmallOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kSourceTextModuleMap,
    StaticReadOnlyRoot::kSwissNameDictionaryMap,
    StaticReadOnlyRoot::kSyntheticModuleMap,
    StaticReadOnlyRoot::kWasmApiFunctionRefMap,
    StaticReadOnlyRoot::kWasmCapiFunctionDataMap,
    StaticReadOnlyRoot::kWasmExportedFunctionDataMap,
    StaticReadOnlyRoot::kWasmInternalFunctionMap,
    StaticReadOnlyRoot::kWasmJSFunctionDataMap,
    StaticReadOnlyRoot::kWasmResumeDataMap,
    StaticReadOnlyRoot::kWasmTypeInfoMap,
    StaticReadOnlyRoot::kWasmContinuationObjectMap,
    StaticReadOnlyRoot::kWasmNullMap,
    StaticReadOnlyRoot::kWeakFixedArrayMap,
    StaticReadOnlyRoot::kWeakArrayListMap,
    StaticReadOnlyRoot::kEphemeronHashTableMap,
    StaticReadOnlyRoot::kEmbedderDataArrayMap,
    StaticReadOnlyRoot::kWeakCellMap,
    StaticReadOnlyRoot::kStringMap,
    StaticReadOnlyRoot::kConsOneByteStringMap,
    StaticReadOnlyRoot::kConsStringMap,
    StaticReadOnlyRoot::kThinStringMap,
    StaticReadOnlyRoot::kSlicedStringMap,
    StaticReadOnlyRoot::kSlicedOneByteStringMap,
    StaticReadOnlyRoot::kExternalStringMap,
    StaticReadOnlyRoot::kExternalOneByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalStringMap,
    StaticReadOnlyRoot::kInternalizedStringMap,
    StaticReadOnlyRoot::kExternalInternalizedStringMap,
    StaticReadOnlyRoot::kExternalOneByteInternalizedStringMap,
    StaticReadOnlyRoot::kUncachedExternalInternalizedStringMap,
    StaticReadOnlyRoot::kUncachedExternalOneByteInternalizedStringMap,
    StaticReadOnlyRoot::kUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedOneByteStringMap,
    StaticReadOnlyRoot::kSharedStringMap,
    StaticReadOnlyRoot::kSharedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedExternalStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalStringMap,
    StaticReadOnlyRoot::kUndefinedMap,
    StaticReadOnlyRoot::kTheHoleMap,
    StaticReadOnlyRoot::kNullMap,
    StaticReadOnlyRoot::kBooleanMap,
    StaticReadOnlyRoot::kUninitializedMap,
    StaticReadOnlyRoot::kArgumentsMarkerMap,
    StaticReadOnlyRoot::kExceptionMap,
    StaticReadOnlyRoot::kTerminationExceptionMap,
    StaticReadOnlyRoot::kOptimizedOutMap,
    StaticReadOnlyRoot::kStaleRegisterMap,
    StaticReadOnlyRoot::kSelfReferenceMarkerMap,
    StaticReadOnlyRoot::kBasicBlockCountersMarkerMap,
    StaticReadOnlyRoot::kEmptyEnumCache,
    StaticReadOnlyRoot::kEmptyPropertyArray,
    StaticReadOnlyRoot::kEmptyByteArray,
    StaticReadOnlyRoot::kEmptyObjectBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyArrayBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyClosureFeedbackCellArray,
    StaticReadOnlyRoot::kEmptySlowElementDictionary,
    StaticReadOnlyRoot::kEmptyOrderedHashMap,
    StaticReadOnlyRoot::kEmptyOrderedHashSet,
    StaticReadOnlyRoot::kEmptyFeedbackMetadata,
    StaticReadOnlyRoot::kEmptyPropertyDictionary,
    StaticReadOnlyRoot::kEmptyOrderedPropertyDictionary,
    StaticReadOnlyRoot::kEmptySwissPropertyDictionary,
    StaticReadOnlyRoot::kNoOpInterceptorInfo,
    StaticReadOnlyRoot::kEmptyArrayList,
    StaticReadOnlyRoot::kEmptyWeakFixedArray,
    StaticReadOnlyRoot::kEmptyWeakArrayList,
    StaticReadOnlyRoot::kInvalidPrototypeValidityCell,
    StaticReadOnlyRoot::kNanValue,
    StaticReadOnlyRoot::kHoleNanValue,
    StaticReadOnlyRoot::kInfinityValue,
    StaticReadOnlyRoot::kMinusZeroValue,
    StaticReadOnlyRoot::kMinusInfinityValue,
    StaticReadOnlyRoot::kMaxSafeInteger,
    StaticReadOnlyRoot::kMaxUInt32,
    StaticReadOnlyRoot::kSmiMinValue,
    StaticReadOnlyRoot::kSmiMaxValuePlusOne,
    StaticReadOnlyRoot::kSingleCharacterStringTable,
    StaticReadOnlyRoot::kSelfReferenceMarker,
    StaticReadOnlyRoot::kBasicBlockCountersMarker,
    StaticReadOnlyRoot::kGlobalThisBindingScopeInfo,
    StaticReadOnlyRoot::kEmptyFunctionScopeInfo,
    StaticReadOnlyRoot::kNativeScopeInfo,
    StaticReadOnlyRoot::kShadowRealmScopeInfo,
    StaticReadOnlyRoot::kEmptySymbolTable,
    StaticReadOnlyRoot::kHashSeed,
    StaticReadOnlyRoot::kWasmNull,
    StaticReadOnlyRoot::kadoptText_string,
    StaticReadOnlyRoot::kapproximatelySign_string,
    StaticReadOnlyRoot::kbaseName_string,
    StaticReadOnlyRoot::kaccounting_string,
    StaticReadOnlyRoot::kbreakType_string,
    StaticReadOnlyRoot::kcalendars_string,
    StaticReadOnlyRoot::kcardinal_string,
    StaticReadOnlyRoot::kcaseFirst_string,
    StaticReadOnlyRoot::kceil_string,
    StaticReadOnlyRoot::kcompare_string,
    StaticReadOnlyRoot::kcollation_string,
    StaticReadOnlyRoot::kcollations_string,
    StaticReadOnlyRoot::kcompact_string,
    StaticReadOnlyRoot::kcompactDisplay_string,
    StaticReadOnlyRoot::kcurrency_string,
    StaticReadOnlyRoot::kcurrencyDisplay_string,
    StaticReadOnlyRoot::kcurrencySign_string,
    StaticReadOnlyRoot::kdateStyle_string,
    StaticReadOnlyRoot::kdateTimeField_string,
    StaticReadOnlyRoot::kdayPeriod_string,
    StaticReadOnlyRoot::kdaysDisplay_string,
    StaticReadOnlyRoot::kdecimal_string,
    StaticReadOnlyRoot::kdialect_string,
    StaticReadOnlyRoot::kdigital_string,
    StaticReadOnlyRoot::kdirection_string,
    StaticReadOnlyRoot::kendRange_string,
    StaticReadOnlyRoot::kengineering_string,
    StaticReadOnlyRoot::kexceptZero_string,
    StaticReadOnlyRoot::kexpand_string,
    StaticReadOnlyRoot::kexponentInteger_string,
    StaticReadOnlyRoot::kexponentMinusSign_string,
    StaticReadOnlyRoot::kexponentSeparator_string,
    StaticReadOnlyRoot::kfallback_string,
    StaticReadOnlyRoot::kfirst_string,
    StaticReadOnlyRoot::kfirstDay_string,
    StaticReadOnlyRoot::kfloor_string,
    StaticReadOnlyRoot::kformat_string,
    StaticReadOnlyRoot::kfraction_string,
    StaticReadOnlyRoot::kfractionalDigits_string,
    StaticReadOnlyRoot::kfractionalSecond_string,
    StaticReadOnlyRoot::kfull_string,
    StaticReadOnlyRoot::kgranularity_string,
    StaticReadOnlyRoot::kgrapheme_string,
    StaticReadOnlyRoot::kgroup_string,
    StaticReadOnlyRoot::kh11_string,
    StaticReadOnlyRoot::kh12_string,
    StaticReadOnlyRoot::kh23_string,
    StaticReadOnlyRoot::kh24_string,
    StaticReadOnlyRoot::khalfCeil_string,
    StaticReadOnlyRoot::khalfEven_string,
    StaticReadOnlyRoot::khalfExpand_string,
    StaticReadOnlyRoot::khalfFloor_string,
    StaticReadOnlyRoot::khalfTrunc_string,
    StaticReadOnlyRoot::khour12_string,
    StaticReadOnlyRoot::khourCycle_string,
    StaticReadOnlyRoot::khourCycles_string,
    StaticReadOnlyRoot::khoursDisplay_string,
    StaticReadOnlyRoot::kideo_string,
    StaticReadOnlyRoot::kignorePunctuation_string,
    StaticReadOnlyRoot::kInvalid_Date_string,
    StaticReadOnlyRoot::kinteger_string,
    StaticReadOnlyRoot::kisWordLike_string,
    StaticReadOnlyRoot::kkana_string,
    StaticReadOnlyRoot::klanguage_string,
    StaticReadOnlyRoot::klanguageDisplay_string,
    StaticReadOnlyRoot::klessPrecision_string,
    StaticReadOnlyRoot::kletter_string,
    StaticReadOnlyRoot::klist_string,
    StaticReadOnlyRoot::kliteral_string,
    StaticReadOnlyRoot::klocale_string,
    StaticReadOnlyRoot::kloose_string,
    StaticReadOnlyRoot::klower_string,
    StaticReadOnlyRoot::kltr_string,
    StaticReadOnlyRoot::kmaximumFractionDigits_string,
    StaticReadOnlyRoot::kmaximumSignificantDigits_string,
    StaticReadOnlyRoot::kmicrosecondsDisplay_string,
    StaticReadOnlyRoot::kmillisecondsDisplay_string,
    StaticReadOnlyRoot::kmin2_string,
    StaticReadOnlyRoot::kminimalDays_string,
    StaticReadOnlyRoot::kminimumFractionDigits_string,
    StaticReadOnlyRoot::kminimumIntegerDigits_string,
    StaticReadOnlyRoot::kminimumSignificantDigits_string,
    StaticReadOnlyRoot::kminus_0,
    StaticReadOnlyRoot::kminusSign_string,
    StaticReadOnlyRoot::kminutesDisplay_string,
    StaticReadOnlyRoot::kmonthsDisplay_string,
    StaticReadOnlyRoot::kmorePrecision_string,
    StaticReadOnlyRoot::knan_string,
    StaticReadOnlyRoot::knanosecondsDisplay_string,
    StaticReadOnlyRoot::knarrowSymbol_string,
    StaticReadOnlyRoot::knegative_string,
    StaticReadOnlyRoot::knever_string,
    StaticReadOnlyRoot::knone_string,
    StaticReadOnlyRoot::knotation_string,
    StaticReadOnlyRoot::knormal_string,
    StaticReadOnlyRoot::knumberingSystem_string,
    StaticReadOnlyRoot::knumberingSystems_string,
    StaticReadOnlyRoot::knumeric_string,
    StaticReadOnlyRoot::kordinal_string,
    StaticReadOnlyRoot::kpercentSign_string,
    StaticReadOnlyRoot::kplusSign_string,
    StaticReadOnlyRoot::kquarter_string,
    StaticReadOnlyRoot::kregion_string,
    StaticReadOnlyRoot::krelatedYear_string,
    StaticReadOnlyRoot::kroundingMode_string,
    StaticReadOnlyRoot::kroundingPriority_string,
    StaticReadOnlyRoot::krtl_string,
    StaticReadOnlyRoot::kscientific_string,
    StaticReadOnlyRoot::ksecondsDisplay_string,
    StaticReadOnlyRoot::ksegment_string,
    StaticReadOnlyRoot::kSegmentIterator_string,
    StaticReadOnlyRoot::kSegments_string,
    StaticReadOnlyRoot::ksensitivity_string,
    StaticReadOnlyRoot::ksep_string,
    StaticReadOnlyRoot::kshared_string,
    StaticReadOnlyRoot::ksignDisplay_string,
    StaticReadOnlyRoot::kstandard_string,
    StaticReadOnlyRoot::kstartRange_string,
    StaticReadOnlyRoot::kstrict_string,
    StaticReadOnlyRoot::kstripIfInteger_string,
    StaticReadOnlyRoot::kstyle_string,
    StaticReadOnlyRoot::kterm_string,
    StaticReadOnlyRoot::ktextInfo_string,
    StaticReadOnlyRoot::ktimeStyle_string,
    StaticReadOnlyRoot::ktimeZones_string,
    StaticReadOnlyRoot::ktimeZoneName_string,
    StaticReadOnlyRoot::ktrailingZeroDisplay_string,
    StaticReadOnlyRoot::ktrunc_string,
    StaticReadOnlyRoot::ktwo_digit_string,
    StaticReadOnlyRoot::ktype_string,
    StaticReadOnlyRoot::kunknown_string,
    StaticReadOnlyRoot::kupper_string,
    StaticReadOnlyRoot::kusage_string,
    StaticReadOnlyRoot::kuseGrouping_string,
    StaticReadOnlyRoot::kunitDisplay_string,
    StaticReadOnlyRoot::kweekday_string,
    StaticReadOnlyRoot::kweekend_string,
    StaticReadOnlyRoot::kweeksDisplay_string,
    StaticReadOnlyRoot::kweekInfo_string,
    StaticReadOnlyRoot::kyearName_string,
    StaticReadOnlyRoot::kyearsDisplay_string,
    StaticReadOnlyRoot::kadd_string,
    StaticReadOnlyRoot::kAggregateError_string,
    StaticReadOnlyRoot::kalways_string,
    StaticReadOnlyRoot::kanonymous_function_string,
    StaticReadOnlyRoot::kanonymous_string,
    StaticReadOnlyRoot::kapply_string,
    StaticReadOnlyRoot::kArguments_string,
    StaticReadOnlyRoot::karguments_string,
    StaticReadOnlyRoot::karguments_to_string,
    StaticReadOnlyRoot::kArray_string,
    StaticReadOnlyRoot::karray_to_string,
    StaticReadOnlyRoot::kArrayBuffer_string,
    StaticReadOnlyRoot::kArrayIterator_string,
    StaticReadOnlyRoot::kas_string,
    StaticReadOnlyRoot::kassert_string,
    StaticReadOnlyRoot::kasync_string,
    StaticReadOnlyRoot::kAtomicsCondition_string,
    StaticReadOnlyRoot::kAtomicsMutex_string,
    StaticReadOnlyRoot::kauto_string,
    StaticReadOnlyRoot::kawait_string,
    StaticReadOnlyRoot::kBigInt_string,
    StaticReadOnlyRoot::kbigint_string,
    StaticReadOnlyRoot::kBigInt64Array_string,
    StaticReadOnlyRoot::kBigUint64Array_string,
    StaticReadOnlyRoot::kbind_string,
    StaticReadOnlyRoot::kblank_string,
    StaticReadOnlyRoot::kBoolean_string,
    StaticReadOnlyRoot::kboolean_string,
    StaticReadOnlyRoot::kboolean_to_string,
    StaticReadOnlyRoot::kbound__string,
    StaticReadOnlyRoot::kbuffer_string,
    StaticReadOnlyRoot::kbyte_length_string,
    StaticReadOnlyRoot::kbyte_offset_string,
    StaticReadOnlyRoot::kCompileError_string,
    StaticReadOnlyRoot::kcalendar_string,
    StaticReadOnlyRoot::kcallee_string,
    StaticReadOnlyRoot::kcaller_string,
    StaticReadOnlyRoot::kcause_string,
    StaticReadOnlyRoot::kcharacter_string,
    StaticReadOnlyRoot::kclosure_string,
    StaticReadOnlyRoot::kcode_string,
    StaticReadOnlyRoot::kcolumn_string,
    StaticReadOnlyRoot::kcomputed_string,
    StaticReadOnlyRoot::kconfigurable_string,
    StaticReadOnlyRoot::kconjunction_string,
    StaticReadOnlyRoot::kconsole_string,
    StaticReadOnlyRoot::kconstrain_string,
    StaticReadOnlyRoot::kconstruct_string,
    StaticReadOnlyRoot::kcurrent_string,
    StaticReadOnlyRoot::kDate_string,
    StaticReadOnlyRoot::kdate_to_string,
    StaticReadOnlyRoot::kdateAdd_string,
    StaticReadOnlyRoot::kdateFromFields_string,
    StaticReadOnlyRoot::kdateUntil_string,
    StaticReadOnlyRoot::kday_string,
    StaticReadOnlyRoot::kdayOfWeek_string,
    StaticReadOnlyRoot::kdayOfYear_string,
    StaticReadOnlyRoot::kdays_string,
    StaticReadOnlyRoot::kdaysInMonth_string,
    StaticReadOnlyRoot::kdaysInWeek_string,
    StaticReadOnlyRoot::kdaysInYear_string,
    StaticReadOnlyRoot::kdefault_string,
    StaticReadOnlyRoot::kdefineProperty_string,
    StaticReadOnlyRoot::kdeleteProperty_string,
    StaticReadOnlyRoot::kdetached_string,
    StaticReadOnlyRoot::kdisjunction_string,
    StaticReadOnlyRoot::kdone_string,
    StaticReadOnlyRoot::kdot_brand_string,
    StaticReadOnlyRoot::kdot_catch_string,
    StaticReadOnlyRoot::kdot_default_string,
    StaticReadOnlyRoot::kdot_for_string,
    StaticReadOnlyRoot::kdot_generator_object_string,
    StaticReadOnlyRoot::kdot_home_object_string,
    StaticReadOnlyRoot::kdot_new_target_string,
    StaticReadOnlyRoot::kdot_result_string,
    StaticReadOnlyRoot::kdot_repl_result_string,
    StaticReadOnlyRoot::kdot_static_home_object_string,
    StaticReadOnlyRoot::kdot_string,
    StaticReadOnlyRoot::kdot_switch_tag_string,
    StaticReadOnlyRoot::kdotAll_string,
    StaticReadOnlyRoot::kError_string,
    StaticReadOnlyRoot::kEvalError_string,
    StaticReadOnlyRoot::kenumerable_string,
    StaticReadOnlyRoot::kelement_string,
    StaticReadOnlyRoot::kepochMicroseconds_string,
    StaticReadOnlyRoot::kepochMilliseconds_string,
    StaticReadOnlyRoot::kepochNanoseconds_string,
    StaticReadOnlyRoot::kepochSeconds_string,
    StaticReadOnlyRoot::kera_string,
    StaticReadOnlyRoot::keraYear_string,
    StaticReadOnlyRoot::kerrors_string,
    StaticReadOnlyRoot::kerror_to_string,
    StaticReadOnlyRoot::keval_string,
    StaticReadOnlyRoot::kexception_string,
    StaticReadOnlyRoot::kexec_string,
    StaticReadOnlyRoot::kfalse_string,
    StaticReadOnlyRoot::kfields_string,
    StaticReadOnlyRoot::kFinalizationRegistry_string,
    StaticReadOnlyRoot::kflags_string,
    StaticReadOnlyRoot::kFloat32Array_string,
    StaticReadOnlyRoot::kFloat64Array_string,
    StaticReadOnlyRoot::kfractionalSecondDigits_string,
    StaticReadOnlyRoot::kfrom_string,
    StaticReadOnlyRoot::kFunction_string,
    StaticReadOnlyRoot::kfunction_native_code_string,
    StaticReadOnlyRoot::kfunction_string,
    StaticReadOnlyRoot::kfunction_to_string,
    StaticReadOnlyRoot::kGenerator_string,
    StaticReadOnlyRoot::kget_space_string,
    StaticReadOnlyRoot::kget_string,
    StaticReadOnlyRoot::kgetOffsetNanosecondsFor_string,
    StaticReadOnlyRoot::kgetOwnPropertyDescriptor_string,
    StaticReadOnlyRoot::kgetPossibleInstantsFor_string,
    StaticReadOnlyRoot::kgetPrototypeOf_string,
    StaticReadOnlyRoot::kglobal_string,
    StaticReadOnlyRoot::kglobalThis_string,
    StaticReadOnlyRoot::kgroups_string,
    StaticReadOnlyRoot::kgrowable_string,
    StaticReadOnlyRoot::khas_string,
    StaticReadOnlyRoot::khasIndices_string,
    StaticReadOnlyRoot::khour_string,
    StaticReadOnlyRoot::khours_string,
    StaticReadOnlyRoot::khoursInDay_string,
    StaticReadOnlyRoot::kignoreCase_string,
    StaticReadOnlyRoot::kid_string,
    StaticReadOnlyRoot::killegal_access_string,
    StaticReadOnlyRoot::killegal_argument_string,
    StaticReadOnlyRoot::kinLeapYear_string,
    StaticReadOnlyRoot::kindex_string,
    StaticReadOnlyRoot::kindices_string,
    StaticReadOnlyRoot::kInfinity_string,
    StaticReadOnlyRoot::kinfinity_string,
    StaticReadOnlyRoot::kinput_string,
    StaticReadOnlyRoot::kInt16Array_string,
    StaticReadOnlyRoot::kInt32Array_string,
    StaticReadOnlyRoot::kInt8Array_string,
    StaticReadOnlyRoot::kisExtensible_string,
    StaticReadOnlyRoot::kiso8601_string,
    StaticReadOnlyRoot::kisoDay_string,
    StaticReadOnlyRoot::kisoHour_string,
    StaticReadOnlyRoot::kisoMicrosecond_string,
    StaticReadOnlyRoot::kisoMillisecond_string,
    StaticReadOnlyRoot::kisoMinute_string,
    StaticReadOnlyRoot::kisoMonth_string,
    StaticReadOnlyRoot::kisoNanosecond_string,
    StaticReadOnlyRoot::kisoSecond_string,
    StaticReadOnlyRoot::kisoYear_string,
    StaticReadOnlyRoot::kjsMemoryEstimate_string,
    StaticReadOnlyRoot::kjsMemoryRange_string,
    StaticReadOnlyRoot::kkeys_string,
    StaticReadOnlyRoot::klargestUnit_string,
    StaticReadOnlyRoot::klastIndex_string,
    StaticReadOnlyRoot::klength_string,
    StaticReadOnlyRoot::klet_string,
    StaticReadOnlyRoot::kline_string,
    StaticReadOnlyRoot::klinear_string,
    StaticReadOnlyRoot::kLinkError_string,
    StaticReadOnlyRoot::klong_string,
    StaticReadOnlyRoot::kMap_string,
    StaticReadOnlyRoot::kMapIterator_string,
    StaticReadOnlyRoot::kmax_byte_length_string,
    StaticReadOnlyRoot::kmedium_string,
    StaticReadOnlyRoot::kmergeFields_string,
    StaticReadOnlyRoot::kmessage_string,
    StaticReadOnlyRoot::kmeta_string,
    StaticReadOnlyRoot::kminus_Infinity_string,
    StaticReadOnlyRoot::kmicrosecond_string,
    StaticReadOnlyRoot::kmicroseconds_string,
    StaticReadOnlyRoot::kmillisecond_string,
    StaticReadOnlyRoot::kmilliseconds_string,
    StaticReadOnlyRoot::kminute_string,
    StaticReadOnlyRoot::kminutes_string,
    StaticReadOnlyRoot::kModule_string,
    StaticReadOnlyRoot::kmonth_string,
    StaticReadOnlyRoot::kmonthDayFromFields_string,
    StaticReadOnlyRoot::kmonths_string,
    StaticReadOnlyRoot::kmonthsInYear_string,
    StaticReadOnlyRoot::kmonthCode_string,
    StaticReadOnlyRoot::kmultiline_string,
    StaticReadOnlyRoot::kname_string,
    StaticReadOnlyRoot::kNaN_string,
    StaticReadOnlyRoot::knanosecond_string,
    StaticReadOnlyRoot::knanoseconds_string,
    StaticReadOnlyRoot::knarrow_string,
    StaticReadOnlyRoot::knative_string,
    StaticReadOnlyRoot::knew_target_string,
    StaticReadOnlyRoot::kNFC_string,
    StaticReadOnlyRoot::kNFD_string,
    StaticReadOnlyRoot::kNFKC_string,
    StaticReadOnlyRoot::kNFKD_string,
    StaticReadOnlyRoot::knot_equal_string,
    StaticReadOnlyRoot::knull_string,
    StaticReadOnlyRoot::knull_to_string,
    StaticReadOnlyRoot::kNumber_string,
    StaticReadOnlyRoot::knumber_string,
    StaticReadOnlyRoot::knumber_to_string,
    StaticReadOnlyRoot::kObject_string,
    StaticReadOnlyRoot::kobject_string,
    StaticReadOnlyRoot::kobject_to_string,
    StaticReadOnlyRoot::kof_string,
    StaticReadOnlyRoot::koffset_string,
    StaticReadOnlyRoot::koffsetNanoseconds_string,
    StaticReadOnlyRoot::kok_string,
    StaticReadOnlyRoot::kone_string,
    StaticReadOnlyRoot::kother_string,
    StaticReadOnlyRoot::koverflow_string,
    StaticReadOnlyRoot::kownKeys_string,
    StaticReadOnlyRoot::kpercent_string,
    StaticReadOnlyRoot::kplainDate_string,
    StaticReadOnlyRoot::kplainTime_string,
    StaticReadOnlyRoot::kposition_string,
    StaticReadOnlyRoot::kpreventExtensions_string,
    StaticReadOnlyRoot::kprivate_constructor_string,
    StaticReadOnlyRoot::kPromise_string,
    StaticReadOnlyRoot::kproto_string,
    StaticReadOnlyRoot::kprototype_string,
    StaticReadOnlyRoot::kproxy_string,
    StaticReadOnlyRoot::kProxy_string,
    StaticReadOnlyRoot::kquery_colon_string,
    StaticReadOnlyRoot::kRangeError_string,
    StaticReadOnlyRoot::kraw_json_string,
    StaticReadOnlyRoot::kraw_string,
    StaticReadOnlyRoot::kReferenceError_string,
    StaticReadOnlyRoot::kReflectGet_string,
    StaticReadOnlyRoot::kReflectHas_string,
    StaticReadOnlyRoot::kRegExp_string,
    StaticReadOnlyRoot::kregexp_to_string,
    StaticReadOnlyRoot::kreject_string,
    StaticReadOnlyRoot::krelativeTo_string,
    StaticReadOnlyRoot::kresizable_string,
    StaticReadOnlyRoot::kResizableArrayBuffer_string,
    StaticReadOnlyRoot::kreturn_string,
    StaticReadOnlyRoot::krevoke_string,
    StaticReadOnlyRoot::kroundingIncrement_string,
    StaticReadOnlyRoot::kRuntimeError_string,
    StaticReadOnlyRoot::kWebAssemblyException_string,
    StaticReadOnlyRoot::kScript_string,
    StaticReadOnlyRoot::kscript_string,
    StaticReadOnlyRoot::ksecond_string,
    StaticReadOnlyRoot::kseconds_string,
    StaticReadOnlyRoot::kshort_string,
    StaticReadOnlyRoot::kSet_string,
    StaticReadOnlyRoot::ksentence_string,
    StaticReadOnlyRoot::kset_space_string,
    StaticReadOnlyRoot::kset_string,
    StaticReadOnlyRoot::kSetIterator_string,
    StaticReadOnlyRoot::ksetPrototypeOf_string,
    StaticReadOnlyRoot::kShadowRealm_string,
    StaticReadOnlyRoot::kSharedArray_string,
    StaticReadOnlyRoot::kSharedArrayBuffer_string,
    StaticReadOnlyRoot::kSharedStruct_string,
    StaticReadOnlyRoot::ksign_string,
    StaticReadOnlyRoot::ksmallestUnit_string,
    StaticReadOnlyRoot::ksource_string,
    StaticReadOnlyRoot::ksourceText_string,
    StaticReadOnlyRoot::kstack_string,
    StaticReadOnlyRoot::kstackTraceLimit_string,
    StaticReadOnlyRoot::ksticky_string,
    StaticReadOnlyRoot::kString_string,
    StaticReadOnlyRoot::kstring_string,
    StaticReadOnlyRoot::kstring_to_string,
    StaticReadOnlyRoot::kSymbol_iterator_string,
    StaticReadOnlyRoot::kSymbol_replace_string,
    StaticReadOnlyRoot::ksymbol_species_string,
    StaticReadOnlyRoot::kSymbol_species_string,
    StaticReadOnlyRoot::kSymbol_string,
    StaticReadOnlyRoot::ksymbol_string,
    StaticReadOnlyRoot::kSyntaxError_string,
    StaticReadOnlyRoot::ktarget_string,
    StaticReadOnlyRoot::kthis_function_string,
    StaticReadOnlyRoot::kthis_string,
    StaticReadOnlyRoot::kthrow_string,
    StaticReadOnlyRoot::ktimed_out_string,
    StaticReadOnlyRoot::ktimeZone_string,
    StaticReadOnlyRoot::ktoJSON_string,
    StaticReadOnlyRoot::ktoString_string,
    StaticReadOnlyRoot::ktrue_string,
    StaticReadOnlyRoot::ktotal_string,
    StaticReadOnlyRoot::kTypeError_string,
    StaticReadOnlyRoot::kUint16Array_string,
    StaticReadOnlyRoot::kUint32Array_string,
    StaticReadOnlyRoot::kUint8Array_string,
    StaticReadOnlyRoot::kUint8ClampedArray_string,
    StaticReadOnlyRoot::kundefined_string,
    StaticReadOnlyRoot::kundefined_to_string,
    StaticReadOnlyRoot::kunicode_string,
    StaticReadOnlyRoot::kunicodeSets_string,
    StaticReadOnlyRoot::kunit_string,
    StaticReadOnlyRoot::kURIError_string,
    StaticReadOnlyRoot::kUTC_string,
    StaticReadOnlyRoot::kvalue_string,
    StaticReadOnlyRoot::kvalueOf_string,
    StaticReadOnlyRoot::kWeakMap_string,
    StaticReadOnlyRoot::kWeakRef_string,
    StaticReadOnlyRoot::kWeakSet_string,
    StaticReadOnlyRoot::kweek_string,
    StaticReadOnlyRoot::kweeks_string,
    StaticReadOnlyRoot::kweekOfYear_string,
    StaticReadOnlyRoot::kword_string,
    StaticReadOnlyRoot::kwritable_string,
    StaticReadOnlyRoot::kyearMonthFromFields_string,
    StaticReadOnlyRoot::kyear_string,
    StaticReadOnlyRoot::kyears_string,
    StaticReadOnlyRoot::kzero_string,
    StaticReadOnlyRoot::karray_buffer_wasm_memory_symbol,
    StaticReadOnlyRoot::kcall_site_info_symbol,
    StaticReadOnlyRoot::kconsole_context_id_symbol,
    StaticReadOnlyRoot::kconsole_context_name_symbol,
    StaticReadOnlyRoot::kclass_fields_symbol,
    StaticReadOnlyRoot::kclass_positions_symbol,
    StaticReadOnlyRoot::kelements_transition_symbol,
    StaticReadOnlyRoot::kerror_end_pos_symbol,
    StaticReadOnlyRoot::kerror_script_symbol,
    StaticReadOnlyRoot::kerror_stack_symbol,
    StaticReadOnlyRoot::kerror_start_pos_symbol,
    StaticReadOnlyRoot::kfrozen_symbol,
    StaticReadOnlyRoot::kinterpreter_trampoline_symbol,
    StaticReadOnlyRoot::kmega_dom_symbol,
    StaticReadOnlyRoot::kmegamorphic_symbol,
    StaticReadOnlyRoot::knative_context_index_symbol,
    StaticReadOnlyRoot::knonextensible_symbol,
    StaticReadOnlyRoot::knot_mapped_symbol,
    StaticReadOnlyRoot::kpromise_debug_marker_symbol,
    StaticReadOnlyRoot::kpromise_debug_message_symbol,
    StaticReadOnlyRoot::kpromise_forwarding_handler_symbol,
    StaticReadOnlyRoot::kpromise_handled_by_symbol,
    StaticReadOnlyRoot::kpromise_awaited_by_symbol,
    StaticReadOnlyRoot::kregexp_result_names_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_input_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_last_index_symbol,
    StaticReadOnlyRoot::ksealed_symbol,
    StaticReadOnlyRoot::kstrict_function_transition_symbol,
    StaticReadOnlyRoot::ktemplate_literal_function_literal_id_symbol,
    StaticReadOnlyRoot::ktemplate_literal_slot_id_symbol,
    StaticReadOnlyRoot::kwasm_exception_tag_symbol,
    StaticReadOnlyRoot::kwasm_exception_values_symbol,
    StaticReadOnlyRoot::kwasm_uncatchable_symbol,
    StaticReadOnlyRoot::kwasm_wrapped_object_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_cache_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_names_symbol,
    StaticReadOnlyRoot::kuninitialized_symbol,
    StaticReadOnlyRoot::kasync_iterator_symbol,
    StaticReadOnlyRoot::kintl_fallback_symbol,
    StaticReadOnlyRoot::kmatch_all_symbol,
    StaticReadOnlyRoot::kmatch_symbol,
    StaticReadOnlyRoot::ksearch_symbol,
    StaticReadOnlyRoot::ksplit_symbol,
    StaticReadOnlyRoot::kto_primitive_symbol,
    StaticReadOnlyRoot::kunscopables_symbol,
    StaticReadOnlyRoot::khas_instance_symbol,
    StaticReadOnlyRoot::kto_string_tag_symbol,
    StaticReadOnlyRoot::kPromiseFulfillReactionJobTaskMap,
    StaticReadOnlyRoot::kPromiseRejectReactionJobTaskMap,
    StaticReadOnlyRoot::kCallableTaskMap,
    StaticReadOnlyRoot::kCallbackTaskMap,
    StaticReadOnlyRoot::kPromiseResolveThenableJobTaskMap,
    StaticReadOnlyRoot::kFunctionTemplateInfoMap,
    StaticReadOnlyRoot::kObjectTemplateInfoMap,
    StaticReadOnlyRoot::kAccessCheckInfoMap,
    StaticReadOnlyRoot::kAccessorPairMap,
    StaticReadOnlyRoot::kAliasedArgumentsEntryMap,
    StaticReadOnlyRoot::kAllocationMementoMap,
    StaticReadOnlyRoot::kArrayBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kAsmWasmDataMap,
    StaticReadOnlyRoot::kAsyncGeneratorRequestMap,
    StaticReadOnlyRoot::kBreakPointMap,
    StaticReadOnlyRoot::kBreakPointInfoMap,
    StaticReadOnlyRoot::kCallSiteInfoMap,
    StaticReadOnlyRoot::kClassPositionsMap,
    StaticReadOnlyRoot::kDebugInfoMap,
    StaticReadOnlyRoot::kEnumCacheMap,
    StaticReadOnlyRoot::kErrorStackDataMap,
    StaticReadOnlyRoot::kFunctionTemplateRareDataMap,
    StaticReadOnlyRoot::kInterceptorInfoMap,
    StaticReadOnlyRoot::kInterpreterDataMap,
    StaticReadOnlyRoot::kModuleRequestMap,
    StaticReadOnlyRoot::kPromiseCapabilityMap,
    StaticReadOnlyRoot::kPromiseOnStackMap,
    StaticReadOnlyRoot::kPromiseReactionMap,
    StaticReadOnlyRoot::kPropertyDescriptorObjectMap,
    StaticReadOnlyRoot::kPrototypeInfoMap,
    StaticReadOnlyRoot::kRegExpBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kScriptMap,
    StaticReadOnlyRoot::kScriptOrModuleMap,
    StaticReadOnlyRoot::kSourceTextModuleInfoEntryMap,
    StaticReadOnlyRoot::kStackFrameInfoMap,
    StaticReadOnlyRoot::kTemplateObjectDescriptionMap,
    StaticReadOnlyRoot::kTuple2Map,
    StaticReadOnlyRoot::kWasmExceptionTagMap,
    StaticReadOnlyRoot::kWasmIndirectFunctionTableMap,
    StaticReadOnlyRoot::kSloppyArgumentsElementsMap,
    StaticReadOnlyRoot::kDescriptorArrayMap,
    StaticReadOnlyRoot::kStrongDescriptorArrayMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataWithJobMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataAndJobMap,
    StaticReadOnlyRoot::kOnHeapBasicBlockProfilerDataMap,
    StaticReadOnlyRoot::kTurbofanBitsetTypeMap,
    StaticReadOnlyRoot::kTurbofanUnionTypeMap,
    StaticReadOnlyRoot::kTurbofanRangeTypeMap,
    StaticReadOnlyRoot::kTurbofanHeapConstantTypeMap,
    StaticReadOnlyRoot::kTurbofanOtherNumberConstantTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64TypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64SetTypeMap,
    StaticReadOnlyRoot::kInternalClassMap,
    StaticReadOnlyRoot::kSmiPairMap,
    StaticReadOnlyRoot::kSmiBoxMap,
    StaticReadOnlyRoot::kExportedSubClassBaseMap,
    StaticReadOnlyRoot::kExportedSubClassMap,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass1Map,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass2Map,
    StaticReadOnlyRoot::kInternalClassWithSmiElementsMap,
    StaticReadOnlyRoot::kInternalClassWithStructElementsMap,
    StaticReadOnlyRoot::kExportedSubClass2Map,
    StaticReadOnlyRoot::kSortStateMap,
    StaticReadOnlyRoot::kWasmStringViewIterMap,
    StaticReadOnlyRoot::kAllocationSiteWithWeakNextMap,
    StaticReadOnlyRoot::kAllocationSiteWithoutWeakNextMap,
    StaticReadOnlyRoot::kconstructor_string,
    StaticReadOnlyRoot::knext_string,
    StaticReadOnlyRoot::kresolve_string,
    StaticReadOnlyRoot::kthen_string,
    StaticReadOnlyRoot::kiterator_symbol,
    StaticReadOnlyRoot::kreplace_symbol,
    StaticReadOnlyRoot::kspecies_symbol,
    StaticReadOnlyRoot::kis_concat_spreadable_symbol,
    StaticReadOnlyRoot::kLoadHandler1Map,
    StaticReadOnlyRoot::kLoadHandler2Map,
    StaticReadOnlyRoot::kLoadHandler3Map,
    StaticReadOnlyRoot::kStoreHandler0Map,
    StaticReadOnlyRoot::kStoreHandler1Map,
    StaticReadOnlyRoot::kStoreHandler2Map,
    StaticReadOnlyRoot::kStoreHandler3Map,
};

inline constexpr base::Optional<std::pair<RootIndex, RootIndex>>
StaticReadOnlyRootMapRange(InstanceType type) {
  switch (type) {
    case INTERNALIZED_STRING_TYPE:
      return {{RootIndex::kInternalizedStringMap,
               RootIndex::kUncachedExternalOneByteInternalizedStringMap}};
    case ALLOCATION_SITE_TYPE:
      return {{RootIndex::kAllocationSiteWithWeakNextMap,
               RootIndex::kAllocationSiteWithoutWeakNextMap}};
    default: {
    }
  }
  return {};
}

inline constexpr base::Optional<std::pair<RootIndex, RootIndex>>
StaticReadOnlyRootMapRange(InstanceType first, InstanceType last) {
  if (first == FIRST_STRING_TYPE && last == LAST_STRING_TYPE) {
    return {{RootIndex::kStringMap,
             RootIndex::kSharedUncachedExternalOneByteStringMap}};
  }
  if (first == FIRST_NAME_TYPE && last == LAST_NAME_TYPE) {
    return {{RootIndex::kSymbolMap,
             RootIndex::kSharedUncachedExternalOneByteStringMap}};
  }
  return {};
}

static constexpr size_t kStaticReadOnlyRootRangesHash = 8801697340173357852UL;

}  // namespace internal
}  // namespace v8
#endif  // V8_STATIC_ROOTS_BOOL
#endif  // V8_ROOTS_STATIC_ROOTS_H_
