/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.InstantiationClassMarker;

public class InstantiationClassFilter
implements ClassVisitor {
    private final ClassVisitor classVisitor;

    public InstantiationClassFilter(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (InstantiationClassMarker.isInstantiated(programClass)) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        if (InstantiationClassMarker.isInstantiated(libraryClass)) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }
}

