# Contributing

1. Thanks for considering contributing to Web Page Replay. You're awesome!
2. Style Guide - The source code of Web Page Replay follows the [Google
Python Style
Guide](http://google-styleguide.googlecode.com/svn/trunk/pyguide.html) so you should familiarize yourself with those
guidelines. You may also wish to email web-page-replay-dev at
googlegroups.com for advice on your change before starting.
3. Get the code - Fork this repo and clone it locally.
4. Get a review - All submissions, including submissions by project members,
require review.

## Using rietveld

1. Make sure that you have a fork of the original repo.
2. Make your changes.
3. Commit your changes.
4. Run 'yes "" |git cl config' (first time only).
5. Run 'git cl upload'.
6. Once the review is approved, run 'git cl land' to land your changes. This also
pushes your change to your forked branch.
7. Login your github account and make a pull request to merge the change from
your forked branch to the original repo.

## The fine print

Before we can use your code you have to sign the [Google Individual
Contributor License
Agreement](http://code.google.com/legal/individual-cla-v1.0.html), which you can do online. This is mainly
because you own the copyright to your changes, even after your
contribution becomes part of our codebase, so we need your permission to
use and distribute your code. We also need to be sure of various other
things, for instance that you'll tell us if you know that your code
infringes on other people's patents. You don't have to do this until
after you've submitted your code for review and a member has approved
it, but you will have to do it before we can put your code into our
codebase.

Contributions made by corporations are covered by a different agreement
than the one above, the [Software Grant and Corporate Contributor License
Agreement](http://code.google.com/legal/corporate-cla-v1.0.html).
