/* Copyright (c) 2014, Google Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. */

#include <openssl/err.h>

#include <openssl/ecdh.h>

const ERR_STRING_DATA ECDH_error_string_data[] = {
  {ERR_PACK(ERR_LIB_ECDH, ECDH_F_ECDH_compute_key, 0), "ECDH_compute_key"},
  {ERR_PACK(ERR_LIB_ECDH, 0, ECDH_R_KDF_FAILED), "KDF_FAILED"},
  {ERR_PACK(ERR_LIB_ECDH, 0, ECDH_R_NO_PRIVATE_VALUE), "NO_PRIVATE_VALUE"},
  {ERR_PACK(ERR_LIB_ECDH, 0, ECDH_R_POINT_ARITHMETIC_FAILURE), "POINT_ARITHMETIC_FAILURE"},
  {0, NULL},
};
