/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc;

import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

public class ValidatorContext {
    private static final Comparator<MessageRecord> MESSAGE_RECORD_COMPARATOR = new Comparator<MessageRecord>(){

        @Override
        public int compare(MessageRecord messageRecord, MessageRecord messageRecord2) {
            return messageRecord.position - messageRecord2.position;
        }
    };
    public final String scriptFileName;
    public final SourceFile sourceFile;
    private final SortedSet<MessageRecord> validationResult = new TreeSet<MessageRecord>(MESSAGE_RECORD_COMPARATOR);

    public ValidatorContext(String string, String string2) {
        this.scriptFileName = string2;
        this.sourceFile = SourceFile.builder().buildFromCode(string2, string);
    }

    public SortedSet<MessageRecord> getValidationResult() {
        return Collections.unmodifiableSortedSet(this.validationResult);
    }

    public String getNodeText(Node node) {
        if (node == null) {
            return null;
        }
        try {
            return this.sourceFile.getCode().substring(node.getSourceOffset(), node.getSourceOffset() + node.getLength());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public SourcePosition getPosition(int n) {
        return new SourcePosition(this.sourceFile.getLineOfOffset(n), this.sourceFile.getColumnOfOffset(n));
    }

    public void reportErrorInNode(Node node, int n, String string) {
        int n2 = node.getSourceOffset() + n;
        this.reportErrorAtOffset(n2, string);
    }

    public void reportErrorAtOffset(int n, String string) {
        SourcePosition sourcePosition = this.getPosition(n);
        StringBuilder stringBuilder = new StringBuilder(sourcePosition.column + 1);
        for (int i = sourcePosition.column; i > 0; --i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append('^');
        String string2 = String.format("%s:%d: ERROR - %s%n%s%n%s%n", this.scriptFileName, sourcePosition.line, string, this.sourceFile.getLine(sourcePosition.line), stringBuilder.toString());
        this.validationResult.add(new MessageRecord(n, string2));
    }

    public static class SourcePosition {
        public final int line;
        public final int column;

        public SourcePosition(int n, int n2) {
            this.line = n;
            this.column = n2;
        }
    }

    public static class MessageRecord {
        public final int position;
        public final String text;

        public MessageRecord(int n, String string) {
            this.position = n;
            this.text = string;
        }
    }
}

