/*
 * Copyright (C) 2006, 2007, 2008, 2009 Apple Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#ifndef LayoutSlider_h
#define LayoutSlider_h

#include "core/CoreExport.h"
#include "core/layout/LayoutFlexibleBox.h"

namespace blink {

class HTMLInputElement;
class SliderThumbElement;

class LayoutSlider final : public LayoutFlexibleBox {
 public:
  static const int kDefaultTrackLength;

  explicit LayoutSlider(HTMLInputElement*);
  ~LayoutSlider() override;

  CORE_EXPORT bool InDragMode() const;

  const char* GetName() const override { return "LayoutSlider"; }

 private:
  bool IsOfType(LayoutObjectType type) const override {
    return type == kLayoutObjectSlider || LayoutFlexibleBox::IsOfType(type);
  }

  int BaselinePosition(
      FontBaseline,
      bool first_line,
      LineDirectionMode,
      LinePositionMode = kPositionOnContainingLine) const override;
  void ComputeIntrinsicLogicalWidths(
      LayoutUnit& min_logical_width,
      LayoutUnit& max_logical_width) const override;
  void UpdateLayout() override;

  SliderThumbElement* GetSliderThumbElement() const;
};

DEFINE_LAYOUT_OBJECT_TYPE_CASTS(LayoutSlider, IsSlider());

}  // namespace blink

#endif  // LayoutSlider_h
