# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial

import os
import sys
import unittest

from pathlib import Path
sys.path.append(os.fspath(Path(__file__).resolve().parents[1]))
from init_paths import init_test_paths
init_test_paths(False)

from PySide6.QtCore import QSysInfo


class TestQSysInfo(unittest.TestCase):
    newenum = sys.pyside63_option_python_enum

    def testEnumEndian(self):
        self.assertEqual(QSysInfo.BigEndian.value if self.newenum else QSysInfo.BigEndian, 0)
        self.assertEqual(QSysInfo.LittleEndian.value if self.newenum else QSysInfo.LittleEndian, 1)
        self.assertTrue((QSysInfo.ByteOrder.value if self.newenum else QSysInfo.ByteOrder) > -1)

    def testEnumSizes(self):
        self.assertTrue((QSysInfo.WordSize.value if self.newenum else QSysInfo.WordSize) > 0)


if __name__ == '__main__':
    unittest.main()
