/*
    Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef TestData_h
#define TestData_h

typedef struct _TestData {
    const char* file;
    const char* advertisedType;
    bool isImage;
    const char* sniffedType;
} TestData;

static const TestData testList[] = {
    {":/application_atom+xml", "text/plain", false, "text/plain"},
    {":/application_atom+xml", "text/plain", true, "text/plain"},
    {":/application_atom+xml", "unknown/unknown", false, "text/xml"},
    {":/application_atom+xml", "unknown/unknown", true, "text/xml"},
    {":/application_atom+xml", "application/unknown", false, "text/xml"},
    {":/application_atom+xml", "application/unknown", true, "text/xml"},
    {":/application_atom+xml", "*/*", false, "text/xml"},
    {":/application_atom+xml", "*/*", true, "text/xml"},
    {":/application_atom+xml", "text/xml", false, 0},
    {":/application_atom+xml", "text/xml", true, 0},
    {":/application_atom+xml", "application/xml", false, 0},
    {":/application_atom+xml", "application/xml", true, 0},
    {":/application_atom+xml", "text/html", false, "application/atom+xml"},
    {":/application_atom+xml", "text/html", true, 0},
    {":/application_atom+xml", "text/xml", false, 0},
    {":/application_atom+xml", "text/xml", true, 0},
    {":/application_atom+xml", "application/pdf", false, 0},
    {":/application_atom+xml", "application/pdf", true, 0},
    {":/application_atom+xml", "application/postscript", false, 0},
    {":/application_atom+xml", "application/postscript", true, 0},
    {":/application_atom+xml", "application/ogg", false, 0},
    {":/application_atom+xml", "application/ogg", true, 0},
    {":/application_atom+xml", "video/webm", false, 0},
    {":/application_atom+xml", "video/webm", true, 0},
    {":/application_atom+xml", "application/x-rar-compressed", false, 0},
    {":/application_atom+xml", "application/x-rar-compressed", true, 0},
    {":/application_atom+xml", "application/zip", false, 0},
    {":/application_atom+xml", "application/zip", true, 0},
    {":/application_atom+xml", "application/x-gzip", false, 0},
    {":/application_atom+xml", "application/x-gzip", true, 0},
    {":/application_atom+xml", "audio/x-wave", false, 0},
    {":/application_atom+xml", "audio/x-wave", true, 0},
    {":/application_atom+xml", "image/webp", false, 0},
    {":/application_atom+xml", "image/webp", true, 0},
    {":/application_atom+xml", "image/gif", false, 0},
    {":/application_atom+xml", "image/gif", true, 0},
    {":/application_atom+xml", "image/png", false, 0},
    {":/application_atom+xml", "image/png", true, 0},
    {":/application_atom+xml", "image/jpeg", false, 0},
    {":/application_atom+xml", "image/jpeg", true, 0},
    {":/application_atom+xml", "image/bmp", false, 0},
    {":/application_atom+xml", "image/bmp", true, 0},
    {":/application_atom+xml", "image/vnd.microsoft.icon", false, 0},
    {":/application_atom+xml", "image/vnd.microsoft.icon", true, 0},
    {":/application_atom+xml", "application/rdf+xml", false, 0},
    {":/application_atom+xml", "application/rdf+xml", true, 0},
    {":/application_atom+xml", "application/rss+xml", false, 0},
    {":/application_atom+xml", "application/rss+xml", true, 0},
    {":/application_atom+xml", "application/atom+xml", false, 0},
    {":/application_atom+xml", "application/atom+xml", true, 0},
    {":/application_ogg", "text/plain", false, "application/ogg"},
    {":/application_ogg", "text/plain", true, "application/ogg"},
    {":/application_ogg", "unknown/unknown", false, "application/ogg"},
    {":/application_ogg", "unknown/unknown", true, "application/ogg"},
    {":/application_ogg", "application/unknown", false, "application/ogg"},
    {":/application_ogg", "application/unknown", true, "application/ogg"},
    {":/application_ogg", "*/*", false, "application/ogg"},
    {":/application_ogg", "*/*", true, "application/ogg"},
    {":/application_ogg", "text/xml", false, 0},
    {":/application_ogg", "text/xml", true, 0},
    {":/application_ogg", "application/xml", false, 0},
    {":/application_ogg", "application/xml", true, 0},
    {":/application_ogg", "text/html", false, 0},
    {":/application_ogg", "text/html", true, 0},
    {":/application_ogg", "text/xml", false, 0},
    {":/application_ogg", "text/xml", true, 0},
    {":/application_ogg", "application/pdf", false, 0},
    {":/application_ogg", "application/pdf", true, 0},
    {":/application_ogg", "application/postscript", false, 0},
    {":/application_ogg", "application/postscript", true, 0},
    {":/application_ogg", "application/ogg", false, 0},
    {":/application_ogg", "application/ogg", true, 0},
    {":/application_ogg", "video/webm", false, 0},
    {":/application_ogg", "video/webm", true, 0},
    {":/application_ogg", "application/x-rar-compressed", false, 0},
    {":/application_ogg", "application/x-rar-compressed", true, 0},
    {":/application_ogg", "application/zip", false, 0},
    {":/application_ogg", "application/zip", true, 0},
    {":/application_ogg", "application/x-gzip", false, 0},
    {":/application_ogg", "application/x-gzip", true, 0},
    {":/application_ogg", "audio/x-wave", false, 0},
    {":/application_ogg", "audio/x-wave", true, 0},
    {":/application_ogg", "image/webp", false, 0},
    {":/application_ogg", "image/webp", true, 0},
    {":/application_ogg", "image/gif", false, 0},
    {":/application_ogg", "image/gif", true, 0},
    {":/application_ogg", "image/png", false, 0},
    {":/application_ogg", "image/png", true, 0},
    {":/application_ogg", "image/jpeg", false, 0},
    {":/application_ogg", "image/jpeg", true, 0},
    {":/application_ogg", "image/bmp", false, 0},
    {":/application_ogg", "image/bmp", true, 0},
    {":/application_ogg", "image/vnd.microsoft.icon", false, 0},
    {":/application_ogg", "image/vnd.microsoft.icon", true, 0},
    {":/application_ogg", "application/rdf+xml", false, 0},
    {":/application_ogg", "application/rdf+xml", true, 0},
    {":/application_ogg", "application/rss+xml", false, 0},
    {":/application_ogg", "application/rss+xml", true, 0},
    {":/application_ogg", "application/atom+xml", false, 0},
    {":/application_ogg", "application/atom+xml", true, 0},
    {":/application_pdf", "text/plain", false, "application/octet-stream"},
    {":/application_pdf", "text/plain", true, "application/octet-stream"},
    {":/application_pdf", "unknown/unknown", false, "application/pdf"},
    {":/application_pdf", "unknown/unknown", true, "application/pdf"},
    {":/application_pdf", "application/unknown", false, "application/pdf"},
    {":/application_pdf", "application/unknown", true, "application/pdf"},
    {":/application_pdf", "*/*", false, "application/pdf"},
    {":/application_pdf", "*/*", true, "application/pdf"},
    {":/application_pdf", "text/xml", false, 0},
    {":/application_pdf", "text/xml", true, 0},
    {":/application_pdf", "application/xml", false, 0},
    {":/application_pdf", "application/xml", true, 0},
    {":/application_pdf", "text/html", false, 0},
    {":/application_pdf", "text/html", true, 0},
    {":/application_pdf", "text/xml", false, 0},
    {":/application_pdf", "text/xml", true, 0},
    {":/application_pdf", "application/pdf", false, 0},
    {":/application_pdf", "application/pdf", true, 0},
    {":/application_pdf", "application/postscript", false, 0},
    {":/application_pdf", "application/postscript", true, 0},
    {":/application_pdf", "application/ogg", false, 0},
    {":/application_pdf", "application/ogg", true, 0},
    {":/application_pdf", "video/webm", false, 0},
    {":/application_pdf", "video/webm", true, 0},
    {":/application_pdf", "application/x-rar-compressed", false, 0},
    {":/application_pdf", "application/x-rar-compressed", true, 0},
    {":/application_pdf", "application/zip", false, 0},
    {":/application_pdf", "application/zip", true, 0},
    {":/application_pdf", "application/x-gzip", false, 0},
    {":/application_pdf", "application/x-gzip", true, 0},
    {":/application_pdf", "audio/x-wave", false, 0},
    {":/application_pdf", "audio/x-wave", true, 0},
    {":/application_pdf", "image/webp", false, 0},
    {":/application_pdf", "image/webp", true, 0},
    {":/application_pdf", "image/gif", false, 0},
    {":/application_pdf", "image/gif", true, 0},
    {":/application_pdf", "image/png", false, 0},
    {":/application_pdf", "image/png", true, 0},
    {":/application_pdf", "image/jpeg", false, 0},
    {":/application_pdf", "image/jpeg", true, 0},
    {":/application_pdf", "image/bmp", false, 0},
    {":/application_pdf", "image/bmp", true, 0},
    {":/application_pdf", "image/vnd.microsoft.icon", false, 0},
    {":/application_pdf", "image/vnd.microsoft.icon", true, 0},
    {":/application_pdf", "application/rdf+xml", false, 0},
    {":/application_pdf", "application/rdf+xml", true, 0},
    {":/application_pdf", "application/rss+xml", false, 0},
    {":/application_pdf", "application/rss+xml", true, 0},
    {":/application_pdf", "application/atom+xml", false, 0},
    {":/application_pdf", "application/atom+xml", true, 0},
    {":/application_postscript", "text/plain", false, "text/plain"},
    {":/application_postscript", "text/plain", true, "text/plain"},
    {":/application_postscript", "unknown/unknown", false, "application/postscript"},
    {":/application_postscript", "unknown/unknown", true, "application/postscript"},
    {":/application_postscript", "application/unknown", false, "application/postscript"},
    {":/application_postscript", "application/unknown", true, "application/postscript"},
    {":/application_postscript", "*/*", false, "application/postscript"},
    {":/application_postscript", "*/*", true, "application/postscript"},
    {":/application_postscript", "text/xml", false, 0},
    {":/application_postscript", "text/xml", true, 0},
    {":/application_postscript", "application/xml", false, 0},
    {":/application_postscript", "application/xml", true, 0},
    {":/application_postscript", "text/html", false, 0},
    {":/application_postscript", "text/html", true, 0},
    {":/application_postscript", "text/xml", false, 0},
    {":/application_postscript", "text/xml", true, 0},
    {":/application_postscript", "application/pdf", false, 0},
    {":/application_postscript", "application/pdf", true, 0},
    {":/application_postscript", "application/postscript", false, 0},
    {":/application_postscript", "application/postscript", true, 0},
    {":/application_postscript", "application/ogg", false, 0},
    {":/application_postscript", "application/ogg", true, 0},
    {":/application_postscript", "video/webm", false, 0},
    {":/application_postscript", "video/webm", true, 0},
    {":/application_postscript", "application/x-rar-compressed", false, 0},
    {":/application_postscript", "application/x-rar-compressed", true, 0},
    {":/application_postscript", "application/zip", false, 0},
    {":/application_postscript", "application/zip", true, 0},
    {":/application_postscript", "application/x-gzip", false, 0},
    {":/application_postscript", "application/x-gzip", true, 0},
    {":/application_postscript", "audio/x-wave", false, 0},
    {":/application_postscript", "audio/x-wave", true, 0},
    {":/application_postscript", "image/webp", false, 0},
    {":/application_postscript", "image/webp", true, 0},
    {":/application_postscript", "image/gif", false, 0},
    {":/application_postscript", "image/gif", true, 0},
    {":/application_postscript", "image/png", false, 0},
    {":/application_postscript", "image/png", true, 0},
    {":/application_postscript", "image/jpeg", false, 0},
    {":/application_postscript", "image/jpeg", true, 0},
    {":/application_postscript", "image/bmp", false, 0},
    {":/application_postscript", "image/bmp", true, 0},
    {":/application_postscript", "image/vnd.microsoft.icon", false, 0},
    {":/application_postscript", "image/vnd.microsoft.icon", true, 0},
    {":/application_postscript", "application/rdf+xml", false, 0},
    {":/application_postscript", "application/rdf+xml", true, 0},
    {":/application_postscript", "application/rss+xml", false, 0},
    {":/application_postscript", "application/rss+xml", true, 0},
    {":/application_postscript", "application/atom+xml", false, 0},
    {":/application_postscript", "application/atom+xml", true, 0},
    {":/application_rdf+xml", "text/plain", false, "text/plain"},
    {":/application_rdf+xml", "text/plain", true, "text/plain"},
    {":/application_rdf+xml", "unknown/unknown", false, "text/xml"},
    {":/application_rdf+xml", "unknown/unknown", true, "text/xml"},
    {":/application_rdf+xml", "application/unknown", false, "text/xml"},
    {":/application_rdf+xml", "application/unknown", true, "text/xml"},
    {":/application_rdf+xml", "*/*", false, "text/xml"},
    {":/application_rdf+xml", "*/*", true, "text/xml"},
    {":/application_rdf+xml", "text/xml", false, 0},
    {":/application_rdf+xml", "text/xml", true, 0},
    {":/application_rdf+xml", "application/xml", false, 0},
    {":/application_rdf+xml", "application/xml", true, 0},
    {":/application_rdf+xml", "text/html", false, "application/rdf+xml"},
    {":/application_rdf+xml", "text/html", true, 0},
    {":/application_rdf+xml", "text/xml", false, 0},
    {":/application_rdf+xml", "text/xml", true, 0},
    {":/application_rdf+xml", "application/pdf", false, 0},
    {":/application_rdf+xml", "application/pdf", true, 0},
    {":/application_rdf+xml", "application/postscript", false, 0},
    {":/application_rdf+xml", "application/postscript", true, 0},
    {":/application_rdf+xml", "application/ogg", false, 0},
    {":/application_rdf+xml", "application/ogg", true, 0},
    {":/application_rdf+xml", "video/webm", false, 0},
    {":/application_rdf+xml", "video/webm", true, 0},
    {":/application_rdf+xml", "application/x-rar-compressed", false, 0},
    {":/application_rdf+xml", "application/x-rar-compressed", true, 0},
    {":/application_rdf+xml", "application/zip", false, 0},
    {":/application_rdf+xml", "application/zip", true, 0},
    {":/application_rdf+xml", "application/x-gzip", false, 0},
    {":/application_rdf+xml", "application/x-gzip", true, 0},
    {":/application_rdf+xml", "audio/x-wave", false, 0},
    {":/application_rdf+xml", "audio/x-wave", true, 0},
    {":/application_rdf+xml", "image/webp", false, 0},
    {":/application_rdf+xml", "image/webp", true, 0},
    {":/application_rdf+xml", "image/gif", false, 0},
    {":/application_rdf+xml", "image/gif", true, 0},
    {":/application_rdf+xml", "image/png", false, 0},
    {":/application_rdf+xml", "image/png", true, 0},
    {":/application_rdf+xml", "image/jpeg", false, 0},
    {":/application_rdf+xml", "image/jpeg", true, 0},
    {":/application_rdf+xml", "image/bmp", false, 0},
    {":/application_rdf+xml", "image/bmp", true, 0},
    {":/application_rdf+xml", "image/vnd.microsoft.icon", false, 0},
    {":/application_rdf+xml", "image/vnd.microsoft.icon", true, 0},
    {":/application_rdf+xml", "application/rdf+xml", false, 0},
    {":/application_rdf+xml", "application/rdf+xml", true, 0},
    {":/application_rdf+xml", "application/rss+xml", false, 0},
    {":/application_rdf+xml", "application/rss+xml", true, 0},
    {":/application_rdf+xml", "application/atom+xml", false, 0},
    {":/application_rdf+xml", "application/atom+xml", true, 0},
    {":/application_rss+xml", "text/plain", false, "text/plain"},
    {":/application_rss+xml", "text/plain", true, "text/plain"},
    {":/application_rss+xml", "unknown/unknown", false, "text/xml"},
    {":/application_rss+xml", "unknown/unknown", true, "text/xml"},
    {":/application_rss+xml", "application/unknown", false, "text/xml"},
    {":/application_rss+xml", "application/unknown", true, "text/xml"},
    {":/application_rss+xml", "*/*", false, "text/xml"},
    {":/application_rss+xml", "*/*", true, "text/xml"},
    {":/application_rss+xml", "text/xml", false, 0},
    {":/application_rss+xml", "text/xml", true, 0},
    {":/application_rss+xml", "application/xml", false, 0},
    {":/application_rss+xml", "application/xml", true, 0},
    {":/application_rss+xml", "text/html", false, "application/rss+xml"},
    {":/application_rss+xml", "text/html", true, 0},
    {":/application_rss+xml", "text/xml", false, 0},
    {":/application_rss+xml", "text/xml", true, 0},
    {":/application_rss+xml", "application/pdf", false, 0},
    {":/application_rss+xml", "application/pdf", true, 0},
    {":/application_rss+xml", "application/postscript", false, 0},
    {":/application_rss+xml", "application/postscript", true, 0},
    {":/application_rss+xml", "application/ogg", false, 0},
    {":/application_rss+xml", "application/ogg", true, 0},
    {":/application_rss+xml", "video/webm", false, 0},
    {":/application_rss+xml", "video/webm", true, 0},
    {":/application_rss+xml", "application/x-rar-compressed", false, 0},
    {":/application_rss+xml", "application/x-rar-compressed", true, 0},
    {":/application_rss+xml", "application/zip", false, 0},
    {":/application_rss+xml", "application/zip", true, 0},
    {":/application_rss+xml", "application/x-gzip", false, 0},
    {":/application_rss+xml", "application/x-gzip", true, 0},
    {":/application_rss+xml", "audio/x-wave", false, 0},
    {":/application_rss+xml", "audio/x-wave", true, 0},
    {":/application_rss+xml", "image/webp", false, 0},
    {":/application_rss+xml", "image/webp", true, 0},
    {":/application_rss+xml", "image/gif", false, 0},
    {":/application_rss+xml", "image/gif", true, 0},
    {":/application_rss+xml", "image/png", false, 0},
    {":/application_rss+xml", "image/png", true, 0},
    {":/application_rss+xml", "image/jpeg", false, 0},
    {":/application_rss+xml", "image/jpeg", true, 0},
    {":/application_rss+xml", "image/bmp", false, 0},
    {":/application_rss+xml", "image/bmp", true, 0},
    {":/application_rss+xml", "image/vnd.microsoft.icon", false, 0},
    {":/application_rss+xml", "image/vnd.microsoft.icon", true, 0},
    {":/application_rss+xml", "application/rdf+xml", false, 0},
    {":/application_rss+xml", "application/rdf+xml", true, 0},
    {":/application_rss+xml", "application/rss+xml", false, 0},
    {":/application_rss+xml", "application/rss+xml", true, 0},
    {":/application_rss+xml", "application/atom+xml", false, 0},
    {":/application_rss+xml", "application/atom+xml", true, 0},
    {":/application_x-gzip", "text/plain", false, "application/x-gzip"},
    {":/application_x-gzip", "text/plain", true, "application/x-gzip"},
    {":/application_x-gzip", "unknown/unknown", false, "application/x-gzip"},
    {":/application_x-gzip", "unknown/unknown", true, "application/x-gzip"},
    {":/application_x-gzip", "application/unknown", false, "application/x-gzip"},
    {":/application_x-gzip", "application/unknown", true, "application/x-gzip"},
    {":/application_x-gzip", "*/*", false, "application/x-gzip"},
    {":/application_x-gzip", "*/*", true, "application/x-gzip"},
    {":/application_x-gzip", "text/xml", false, 0},
    {":/application_x-gzip", "text/xml", true, 0},
    {":/application_x-gzip", "application/xml", false, 0},
    {":/application_x-gzip", "application/xml", true, 0},
    {":/application_x-gzip", "text/html", false, 0},
    {":/application_x-gzip", "text/html", true, 0},
    {":/application_x-gzip", "text/xml", false, 0},
    {":/application_x-gzip", "text/xml", true, 0},
    {":/application_x-gzip", "application/pdf", false, 0},
    {":/application_x-gzip", "application/pdf", true, 0},
    {":/application_x-gzip", "application/postscript", false, 0},
    {":/application_x-gzip", "application/postscript", true, 0},
    {":/application_x-gzip", "application/ogg", false, 0},
    {":/application_x-gzip", "application/ogg", true, 0},
    {":/application_x-gzip", "video/webm", false, 0},
    {":/application_x-gzip", "video/webm", true, 0},
    {":/application_x-gzip", "application/x-rar-compressed", false, 0},
    {":/application_x-gzip", "application/x-rar-compressed", true, 0},
    {":/application_x-gzip", "application/zip", false, 0},
    {":/application_x-gzip", "application/zip", true, 0},
    {":/application_x-gzip", "application/x-gzip", false, 0},
    {":/application_x-gzip", "application/x-gzip", true, 0},
    {":/application_x-gzip", "audio/x-wave", false, 0},
    {":/application_x-gzip", "audio/x-wave", true, 0},
    {":/application_x-gzip", "image/webp", false, 0},
    {":/application_x-gzip", "image/webp", true, 0},
    {":/application_x-gzip", "image/gif", false, 0},
    {":/application_x-gzip", "image/gif", true, 0},
    {":/application_x-gzip", "image/png", false, 0},
    {":/application_x-gzip", "image/png", true, 0},
    {":/application_x-gzip", "image/jpeg", false, 0},
    {":/application_x-gzip", "image/jpeg", true, 0},
    {":/application_x-gzip", "image/bmp", false, 0},
    {":/application_x-gzip", "image/bmp", true, 0},
    {":/application_x-gzip", "image/vnd.microsoft.icon", false, 0},
    {":/application_x-gzip", "image/vnd.microsoft.icon", true, 0},
    {":/application_x-gzip", "application/rdf+xml", false, 0},
    {":/application_x-gzip", "application/rdf+xml", true, 0},
    {":/application_x-gzip", "application/rss+xml", false, 0},
    {":/application_x-gzip", "application/rss+xml", true, 0},
    {":/application_x-gzip", "application/atom+xml", false, 0},
    {":/application_x-gzip", "application/atom+xml", true, 0},
    {":/application_x-rar-compressed", "text/plain", false, "application/x-rar-compressed"},
    {":/application_x-rar-compressed", "text/plain", true, "application/x-rar-compressed"},
    {":/application_x-rar-compressed", "unknown/unknown", false, "application/x-rar-compressed"},
    {":/application_x-rar-compressed", "unknown/unknown", true, "application/x-rar-compressed"},
    {":/application_x-rar-compressed", "application/unknown", false, "application/x-rar-compressed"},
    {":/application_x-rar-compressed", "application/unknown", true, "application/x-rar-compressed"},
    {":/application_x-rar-compressed", "*/*", false, "application/x-rar-compressed"},
    {":/application_x-rar-compressed", "*/*", true, "application/x-rar-compressed"},
    {":/application_x-rar-compressed", "text/xml", false, 0},
    {":/application_x-rar-compressed", "text/xml", true, 0},
    {":/application_x-rar-compressed", "application/xml", false, 0},
    {":/application_x-rar-compressed", "application/xml", true, 0},
    {":/application_x-rar-compressed", "text/html", false, 0},
    {":/application_x-rar-compressed", "text/html", true, 0},
    {":/application_x-rar-compressed", "text/xml", false, 0},
    {":/application_x-rar-compressed", "text/xml", true, 0},
    {":/application_x-rar-compressed", "application/pdf", false, 0},
    {":/application_x-rar-compressed", "application/pdf", true, 0},
    {":/application_x-rar-compressed", "application/postscript", false, 0},
    {":/application_x-rar-compressed", "application/postscript", true, 0},
    {":/application_x-rar-compressed", "application/ogg", false, 0},
    {":/application_x-rar-compressed", "application/ogg", true, 0},
    {":/application_x-rar-compressed", "video/webm", false, 0},
    {":/application_x-rar-compressed", "video/webm", true, 0},
    {":/application_x-rar-compressed", "application/x-rar-compressed", false, 0},
    {":/application_x-rar-compressed", "application/x-rar-compressed", true, 0},
    {":/application_x-rar-compressed", "application/zip", false, 0},
    {":/application_x-rar-compressed", "application/zip", true, 0},
    {":/application_x-rar-compressed", "application/x-gzip", false, 0},
    {":/application_x-rar-compressed", "application/x-gzip", true, 0},
    {":/application_x-rar-compressed", "audio/x-wave", false, 0},
    {":/application_x-rar-compressed", "audio/x-wave", true, 0},
    {":/application_x-rar-compressed", "image/webp", false, 0},
    {":/application_x-rar-compressed", "image/webp", true, 0},
    {":/application_x-rar-compressed", "image/gif", false, 0},
    {":/application_x-rar-compressed", "image/gif", true, 0},
    {":/application_x-rar-compressed", "image/png", false, 0},
    {":/application_x-rar-compressed", "image/png", true, 0},
    {":/application_x-rar-compressed", "image/jpeg", false, 0},
    {":/application_x-rar-compressed", "image/jpeg", true, 0},
    {":/application_x-rar-compressed", "image/bmp", false, 0},
    {":/application_x-rar-compressed", "image/bmp", true, 0},
    {":/application_x-rar-compressed", "image/vnd.microsoft.icon", false, 0},
    {":/application_x-rar-compressed", "image/vnd.microsoft.icon", true, 0},
    {":/application_x-rar-compressed", "application/rdf+xml", false, 0},
    {":/application_x-rar-compressed", "application/rdf+xml", true, 0},
    {":/application_x-rar-compressed", "application/rss+xml", false, 0},
    {":/application_x-rar-compressed", "application/rss+xml", true, 0},
    {":/application_x-rar-compressed", "application/atom+xml", false, 0},
    {":/application_x-rar-compressed", "application/atom+xml", true, 0},
    {":/application_zip", "text/plain", false, "application/zip"},
    {":/application_zip", "text/plain", true, "application/zip"},
    {":/application_zip", "unknown/unknown", false, "application/zip"},
    {":/application_zip", "unknown/unknown", true, "application/zip"},
    {":/application_zip", "application/unknown", false, "application/zip"},
    {":/application_zip", "application/unknown", true, "application/zip"},
    {":/application_zip", "*/*", false, "application/zip"},
    {":/application_zip", "*/*", true, "application/zip"},
    {":/application_zip", "text/xml", false, 0},
    {":/application_zip", "text/xml", true, 0},
    {":/application_zip", "application/xml", false, 0},
    {":/application_zip", "application/xml", true, 0},
    {":/application_zip", "text/html", false, 0},
    {":/application_zip", "text/html", true, 0},
    {":/application_zip", "text/xml", false, 0},
    {":/application_zip", "text/xml", true, 0},
    {":/application_zip", "application/pdf", false, 0},
    {":/application_zip", "application/pdf", true, 0},
    {":/application_zip", "application/postscript", false, 0},
    {":/application_zip", "application/postscript", true, 0},
    {":/application_zip", "application/ogg", false, 0},
    {":/application_zip", "application/ogg", true, 0},
    {":/application_zip", "video/webm", false, 0},
    {":/application_zip", "video/webm", true, 0},
    {":/application_zip", "application/x-rar-compressed", false, 0},
    {":/application_zip", "application/x-rar-compressed", true, 0},
    {":/application_zip", "application/zip", false, 0},
    {":/application_zip", "application/zip", true, 0},
    {":/application_zip", "application/x-gzip", false, 0},
    {":/application_zip", "application/x-gzip", true, 0},
    {":/application_zip", "audio/x-wave", false, 0},
    {":/application_zip", "audio/x-wave", true, 0},
    {":/application_zip", "image/webp", false, 0},
    {":/application_zip", "image/webp", true, 0},
    {":/application_zip", "image/gif", false, 0},
    {":/application_zip", "image/gif", true, 0},
    {":/application_zip", "image/png", false, 0},
    {":/application_zip", "image/png", true, 0},
    {":/application_zip", "image/jpeg", false, 0},
    {":/application_zip", "image/jpeg", true, 0},
    {":/application_zip", "image/bmp", false, 0},
    {":/application_zip", "image/bmp", true, 0},
    {":/application_zip", "image/vnd.microsoft.icon", false, 0},
    {":/application_zip", "image/vnd.microsoft.icon", true, 0},
    {":/application_zip", "application/rdf+xml", false, 0},
    {":/application_zip", "application/rdf+xml", true, 0},
    {":/application_zip", "application/rss+xml", false, 0},
    {":/application_zip", "application/rss+xml", true, 0},
    {":/application_zip", "application/atom+xml", false, 0},
    {":/application_zip", "application/atom+xml", true, 0},
    {":/audio_x-wave", "text/plain", false, "audio/x-wave"},
    {":/audio_x-wave", "text/plain", true, "audio/x-wave"},
    {":/audio_x-wave", "unknown/unknown", false, "audio/x-wave"},
    {":/audio_x-wave", "unknown/unknown", true, "audio/x-wave"},
    {":/audio_x-wave", "application/unknown", false, "audio/x-wave"},
    {":/audio_x-wave", "application/unknown", true, "audio/x-wave"},
    {":/audio_x-wave", "*/*", false, "audio/x-wave"},
    {":/audio_x-wave", "*/*", true, "audio/x-wave"},
    {":/audio_x-wave", "text/xml", false, 0},
    {":/audio_x-wave", "text/xml", true, 0},
    {":/audio_x-wave", "application/xml", false, 0},
    {":/audio_x-wave", "application/xml", true, 0},
    {":/audio_x-wave", "text/html", false, 0},
    {":/audio_x-wave", "text/html", true, 0},
    {":/audio_x-wave", "text/xml", false, 0},
    {":/audio_x-wave", "text/xml", true, 0},
    {":/audio_x-wave", "application/pdf", false, 0},
    {":/audio_x-wave", "application/pdf", true, 0},
    {":/audio_x-wave", "application/postscript", false, 0},
    {":/audio_x-wave", "application/postscript", true, 0},
    {":/audio_x-wave", "application/ogg", false, 0},
    {":/audio_x-wave", "application/ogg", true, 0},
    {":/audio_x-wave", "video/webm", false, 0},
    {":/audio_x-wave", "video/webm", true, 0},
    {":/audio_x-wave", "application/x-rar-compressed", false, 0},
    {":/audio_x-wave", "application/x-rar-compressed", true, 0},
    {":/audio_x-wave", "application/zip", false, 0},
    {":/audio_x-wave", "application/zip", true, 0},
    {":/audio_x-wave", "application/x-gzip", false, 0},
    {":/audio_x-wave", "application/x-gzip", true, 0},
    {":/audio_x-wave", "audio/x-wave", false, 0},
    {":/audio_x-wave", "audio/x-wave", true, 0},
    {":/audio_x-wave", "image/webp", false, 0},
    {":/audio_x-wave", "image/webp", true, 0},
    {":/audio_x-wave", "image/gif", false, 0},
    {":/audio_x-wave", "image/gif", true, 0},
    {":/audio_x-wave", "image/png", false, 0},
    {":/audio_x-wave", "image/png", true, 0},
    {":/audio_x-wave", "image/jpeg", false, 0},
    {":/audio_x-wave", "image/jpeg", true, 0},
    {":/audio_x-wave", "image/bmp", false, 0},
    {":/audio_x-wave", "image/bmp", true, 0},
    {":/audio_x-wave", "image/vnd.microsoft.icon", false, 0},
    {":/audio_x-wave", "image/vnd.microsoft.icon", true, 0},
    {":/audio_x-wave", "application/rdf+xml", false, 0},
    {":/audio_x-wave", "application/rdf+xml", true, 0},
    {":/audio_x-wave", "application/rss+xml", false, 0},
    {":/audio_x-wave", "application/rss+xml", true, 0},
    {":/audio_x-wave", "application/atom+xml", false, 0},
    {":/audio_x-wave", "application/atom+xml", true, 0},
    {":/image_bmp", "text/plain", false, "image/bmp"},
    {":/image_bmp", "text/plain", true, "image/bmp"},
    {":/image_bmp", "unknown/unknown", false, "image/bmp"},
    {":/image_bmp", "unknown/unknown", true, "image/bmp"},
    {":/image_bmp", "application/unknown", false, "image/bmp"},
    {":/image_bmp", "application/unknown", true, "image/bmp"},
    {":/image_bmp", "*/*", false, "image/bmp"},
    {":/image_bmp", "*/*", true, "image/bmp"},
    {":/image_bmp", "text/xml", false, 0},
    {":/image_bmp", "text/xml", true, 0},
    {":/image_bmp", "application/xml", false, 0},
    {":/image_bmp", "application/xml", true, 0},
    {":/image_bmp", "text/html", false, 0},
    {":/image_bmp", "text/html", true, "image/bmp"},
    {":/image_bmp", "text/xml", false, 0},
    {":/image_bmp", "text/xml", true, 0},
    {":/image_bmp", "application/pdf", false, 0},
    {":/image_bmp", "application/pdf", true, "image/bmp"},
    {":/image_bmp", "application/postscript", false, 0},
    {":/image_bmp", "application/postscript", true, "image/bmp"},
    {":/image_bmp", "application/ogg", false, 0},
    {":/image_bmp", "application/ogg", true, "image/bmp"},
    {":/image_bmp", "video/webm", false, 0},
    {":/image_bmp", "video/webm", true, "image/bmp"},
    {":/image_bmp", "application/x-rar-compressed", false, 0},
    {":/image_bmp", "application/x-rar-compressed", true, "image/bmp"},
    {":/image_bmp", "application/zip", false, 0},
    {":/image_bmp", "application/zip", true, "image/bmp"},
    {":/image_bmp", "application/x-gzip", false, 0},
    {":/image_bmp", "application/x-gzip", true, "image/bmp"},
    {":/image_bmp", "audio/x-wave", false, 0},
    {":/image_bmp", "audio/x-wave", true, "image/bmp"},
    {":/image_bmp", "image/webp", false, 0},
    {":/image_bmp", "image/webp", true, "image/bmp"},
    {":/image_bmp", "image/gif", false, 0},
    {":/image_bmp", "image/gif", true, "image/bmp"},
    {":/image_bmp", "image/png", false, 0},
    {":/image_bmp", "image/png", true, "image/bmp"},
    {":/image_bmp", "image/jpeg", false, 0},
    {":/image_bmp", "image/jpeg", true, "image/bmp"},
    {":/image_bmp", "image/bmp", false, 0},
    {":/image_bmp", "image/bmp", true, "image/bmp"},
    {":/image_bmp", "image/vnd.microsoft.icon", false, 0},
    {":/image_bmp", "image/vnd.microsoft.icon", true, "image/bmp"},
    {":/image_bmp", "application/rdf+xml", false, 0},
    {":/image_bmp", "application/rdf+xml", true, 0},
    {":/image_bmp", "application/rss+xml", false, 0},
    {":/image_bmp", "application/rss+xml", true, 0},
    {":/image_bmp", "application/atom+xml", false, 0},
    {":/image_bmp", "application/atom+xml", true, 0},
    {":/image_gif", "text/plain", false, "image/gif"},
    {":/image_gif", "text/plain", true, "image/gif"},
    {":/image_gif", "unknown/unknown", false, "image/gif"},
    {":/image_gif", "unknown/unknown", true, "image/gif"},
    {":/image_gif", "application/unknown", false, "image/gif"},
    {":/image_gif", "application/unknown", true, "image/gif"},
    {":/image_gif", "*/*", false, "image/gif"},
    {":/image_gif", "*/*", true, "image/gif"},
    {":/image_gif", "text/xml", false, 0},
    {":/image_gif", "text/xml", true, 0},
    {":/image_gif", "application/xml", false, 0},
    {":/image_gif", "application/xml", true, 0},
    {":/image_gif", "text/html", false, 0},
    {":/image_gif", "text/html", true, "image/gif"},
    {":/image_gif", "text/xml", false, 0},
    {":/image_gif", "text/xml", true, 0},
    {":/image_gif", "application/pdf", false, 0},
    {":/image_gif", "application/pdf", true, "image/gif"},
    {":/image_gif", "application/postscript", false, 0},
    {":/image_gif", "application/postscript", true, "image/gif"},
    {":/image_gif", "application/ogg", false, 0},
    {":/image_gif", "application/ogg", true, "image/gif"},
    {":/image_gif", "video/webm", false, 0},
    {":/image_gif", "video/webm", true, "image/gif"},
    {":/image_gif", "application/x-rar-compressed", false, 0},
    {":/image_gif", "application/x-rar-compressed", true, "image/gif"},
    {":/image_gif", "application/zip", false, 0},
    {":/image_gif", "application/zip", true, "image/gif"},
    {":/image_gif", "application/x-gzip", false, 0},
    {":/image_gif", "application/x-gzip", true, "image/gif"},
    {":/image_gif", "audio/x-wave", false, 0},
    {":/image_gif", "audio/x-wave", true, "image/gif"},
    {":/image_gif", "image/webp", false, 0},
    {":/image_gif", "image/webp", true, "image/gif"},
    {":/image_gif", "image/gif", false, 0},
    {":/image_gif", "image/gif", true, "image/gif"},
    {":/image_gif", "image/png", false, 0},
    {":/image_gif", "image/png", true, "image/gif"},
    {":/image_gif", "image/jpeg", false, 0},
    {":/image_gif", "image/jpeg", true, "image/gif"},
    {":/image_gif", "image/bmp", false, 0},
    {":/image_gif", "image/bmp", true, "image/gif"},
    {":/image_gif", "image/vnd.microsoft.icon", false, 0},
    {":/image_gif", "image/vnd.microsoft.icon", true, "image/gif"},
    {":/image_gif", "application/rdf+xml", false, 0},
    {":/image_gif", "application/rdf+xml", true, 0},
    {":/image_gif", "application/rss+xml", false, 0},
    {":/image_gif", "application/rss+xml", true, 0},
    {":/image_gif", "application/atom+xml", false, 0},
    {":/image_gif", "application/atom+xml", true, 0},
    {":/image_jpeg", "text/plain", false, "image/jpeg"},
    {":/image_jpeg", "text/plain", true, "image/jpeg"},
    {":/image_jpeg", "unknown/unknown", false, "image/jpeg"},
    {":/image_jpeg", "unknown/unknown", true, "image/jpeg"},
    {":/image_jpeg", "application/unknown", false, "image/jpeg"},
    {":/image_jpeg", "application/unknown", true, "image/jpeg"},
    {":/image_jpeg", "*/*", false, "image/jpeg"},
    {":/image_jpeg", "*/*", true, "image/jpeg"},
    {":/image_jpeg", "text/xml", false, 0},
    {":/image_jpeg", "text/xml", true, 0},
    {":/image_jpeg", "application/xml", false, 0},
    {":/image_jpeg", "application/xml", true, 0},
    {":/image_jpeg", "text/html", false, 0},
    {":/image_jpeg", "text/html", true, "image/jpeg"},
    {":/image_jpeg", "text/xml", false, 0},
    {":/image_jpeg", "text/xml", true, 0},
    {":/image_jpeg", "application/pdf", false, 0},
    {":/image_jpeg", "application/pdf", true, "image/jpeg"},
    {":/image_jpeg", "application/postscript", false, 0},
    {":/image_jpeg", "application/postscript", true, "image/jpeg"},
    {":/image_jpeg", "application/ogg", false, 0},
    {":/image_jpeg", "application/ogg", true, "image/jpeg"},
    {":/image_jpeg", "video/webm", false, 0},
    {":/image_jpeg", "video/webm", true, "image/jpeg"},
    {":/image_jpeg", "application/x-rar-compressed", false, 0},
    {":/image_jpeg", "application/x-rar-compressed", true, "image/jpeg"},
    {":/image_jpeg", "application/zip", false, 0},
    {":/image_jpeg", "application/zip", true, "image/jpeg"},
    {":/image_jpeg", "application/x-gzip", false, 0},
    {":/image_jpeg", "application/x-gzip", true, "image/jpeg"},
    {":/image_jpeg", "audio/x-wave", false, 0},
    {":/image_jpeg", "audio/x-wave", true, "image/jpeg"},
    {":/image_jpeg", "image/webp", false, 0},
    {":/image_jpeg", "image/webp", true, "image/jpeg"},
    {":/image_jpeg", "image/gif", false, 0},
    {":/image_jpeg", "image/gif", true, "image/jpeg"},
    {":/image_jpeg", "image/png", false, 0},
    {":/image_jpeg", "image/png", true, "image/jpeg"},
    {":/image_jpeg", "image/jpeg", false, 0},
    {":/image_jpeg", "image/jpeg", true, "image/jpeg"},
    {":/image_jpeg", "image/bmp", false, 0},
    {":/image_jpeg", "image/bmp", true, "image/jpeg"},
    {":/image_jpeg", "image/vnd.microsoft.icon", false, 0},
    {":/image_jpeg", "image/vnd.microsoft.icon", true, "image/jpeg"},
    {":/image_jpeg", "application/rdf+xml", false, 0},
    {":/image_jpeg", "application/rdf+xml", true, 0},
    {":/image_jpeg", "application/rss+xml", false, 0},
    {":/image_jpeg", "application/rss+xml", true, 0},
    {":/image_jpeg", "application/atom+xml", false, 0},
    {":/image_jpeg", "application/atom+xml", true, 0},
    {":/image_png", "text/plain", false, "image/png"},
    {":/image_png", "text/plain", true, "image/png"},
    {":/image_png", "unknown/unknown", false, "image/png"},
    {":/image_png", "unknown/unknown", true, "image/png"},
    {":/image_png", "application/unknown", false, "image/png"},
    {":/image_png", "application/unknown", true, "image/png"},
    {":/image_png", "*/*", false, "image/png"},
    {":/image_png", "*/*", true, "image/png"},
    {":/image_png", "text/xml", false, 0},
    {":/image_png", "text/xml", true, 0},
    {":/image_png", "application/xml", false, 0},
    {":/image_png", "application/xml", true, 0},
    {":/image_png", "text/html", false, 0},
    {":/image_png", "text/html", true, "image/png"},
    {":/image_png", "text/xml", false, 0},
    {":/image_png", "text/xml", true, 0},
    {":/image_png", "application/pdf", false, 0},
    {":/image_png", "application/pdf", true, "image/png"},
    {":/image_png", "application/postscript", false, 0},
    {":/image_png", "application/postscript", true, "image/png"},
    {":/image_png", "application/ogg", false, 0},
    {":/image_png", "application/ogg", true, "image/png"},
    {":/image_png", "video/webm", false, 0},
    {":/image_png", "video/webm", true, "image/png"},
    {":/image_png", "application/x-rar-compressed", false, 0},
    {":/image_png", "application/x-rar-compressed", true, "image/png"},
    {":/image_png", "application/zip", false, 0},
    {":/image_png", "application/zip", true, "image/png"},
    {":/image_png", "application/x-gzip", false, 0},
    {":/image_png", "application/x-gzip", true, "image/png"},
    {":/image_png", "audio/x-wave", false, 0},
    {":/image_png", "audio/x-wave", true, "image/png"},
    {":/image_png", "image/webp", false, 0},
    {":/image_png", "image/webp", true, "image/png"},
    {":/image_png", "image/gif", false, 0},
    {":/image_png", "image/gif", true, "image/png"},
    {":/image_png", "image/png", false, 0},
    {":/image_png", "image/png", true, "image/png"},
    {":/image_png", "image/jpeg", false, 0},
    {":/image_png", "image/jpeg", true, "image/png"},
    {":/image_png", "image/bmp", false, 0},
    {":/image_png", "image/bmp", true, "image/png"},
    {":/image_png", "image/vnd.microsoft.icon", false, 0},
    {":/image_png", "image/vnd.microsoft.icon", true, "image/png"},
    {":/image_png", "application/rdf+xml", false, 0},
    {":/image_png", "application/rdf+xml", true, 0},
    {":/image_png", "application/rss+xml", false, 0},
    {":/image_png", "application/rss+xml", true, 0},
    {":/image_png", "application/atom+xml", false, 0},
    {":/image_png", "application/atom+xml", true, 0},
    {":/image_vnd.microsoft.icon", "text/plain", false, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "text/plain", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "unknown/unknown", false, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "unknown/unknown", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "application/unknown", false, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "application/unknown", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "*/*", false, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "*/*", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "text/xml", false, 0},
    {":/image_vnd.microsoft.icon", "text/xml", true, 0},
    {":/image_vnd.microsoft.icon", "application/xml", false, 0},
    {":/image_vnd.microsoft.icon", "application/xml", true, 0},
    {":/image_vnd.microsoft.icon", "text/html", false, 0},
    {":/image_vnd.microsoft.icon", "text/html", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "text/xml", false, 0},
    {":/image_vnd.microsoft.icon", "text/xml", true, 0},
    {":/image_vnd.microsoft.icon", "application/pdf", false, 0},
    {":/image_vnd.microsoft.icon", "application/pdf", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "application/postscript", false, 0},
    {":/image_vnd.microsoft.icon", "application/postscript", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "application/ogg", false, 0},
    {":/image_vnd.microsoft.icon", "application/ogg", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "video/webm", false, 0},
    {":/image_vnd.microsoft.icon", "video/webm", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "application/x-rar-compressed", false, 0},
    {":/image_vnd.microsoft.icon", "application/x-rar-compressed", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "application/zip", false, 0},
    {":/image_vnd.microsoft.icon", "application/zip", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "application/x-gzip", false, 0},
    {":/image_vnd.microsoft.icon", "application/x-gzip", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "audio/x-wave", false, 0},
    {":/image_vnd.microsoft.icon", "audio/x-wave", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "image/webp", false, 0},
    {":/image_vnd.microsoft.icon", "image/webp", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "image/gif", false, 0},
    {":/image_vnd.microsoft.icon", "image/gif", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "image/png", false, 0},
    {":/image_vnd.microsoft.icon", "image/png", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "image/jpeg", false, 0},
    {":/image_vnd.microsoft.icon", "image/jpeg", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "image/bmp", false, 0},
    {":/image_vnd.microsoft.icon", "image/bmp", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "image/vnd.microsoft.icon", false, 0},
    {":/image_vnd.microsoft.icon", "image/vnd.microsoft.icon", true, "image/vnd.microsoft.icon"},
    {":/image_vnd.microsoft.icon", "application/rdf+xml", false, 0},
    {":/image_vnd.microsoft.icon", "application/rdf+xml", true, 0},
    {":/image_vnd.microsoft.icon", "application/rss+xml", false, 0},
    {":/image_vnd.microsoft.icon", "application/rss+xml", true, 0},
    {":/image_vnd.microsoft.icon", "application/atom+xml", false, 0},
    {":/image_vnd.microsoft.icon", "application/atom+xml", true, 0},
    {":/image_webp", "text/plain", false, "image/webp"},
    {":/image_webp", "text/plain", true, "image/webp"},
    {":/image_webp", "unknown/unknown", false, "image/webp"},
    {":/image_webp", "unknown/unknown", true, "image/webp"},
    {":/image_webp", "application/unknown", false, "image/webp"},
    {":/image_webp", "application/unknown", true, "image/webp"},
    {":/image_webp", "*/*", false, "image/webp"},
    {":/image_webp", "*/*", true, "image/webp"},
    {":/image_webp", "text/xml", false, 0},
    {":/image_webp", "text/xml", true, 0},
    {":/image_webp", "application/xml", false, 0},
    {":/image_webp", "application/xml", true, 0},
    {":/image_webp", "text/html", false, 0},
    {":/image_webp", "text/html", true, "image/webp"},
    {":/image_webp", "text/xml", false, 0},
    {":/image_webp", "text/xml", true, 0},
    {":/image_webp", "application/pdf", false, 0},
    {":/image_webp", "application/pdf", true, "image/webp"},
    {":/image_webp", "application/postscript", false, 0},
    {":/image_webp", "application/postscript", true, "image/webp"},
    {":/image_webp", "application/ogg", false, 0},
    {":/image_webp", "application/ogg", true, "image/webp"},
    {":/image_webp", "video/webm", false, 0},
    {":/image_webp", "video/webm", true, "image/webp"},
    {":/image_webp", "application/x-rar-compressed", false, 0},
    {":/image_webp", "application/x-rar-compressed", true, "image/webp"},
    {":/image_webp", "application/zip", false, 0},
    {":/image_webp", "application/zip", true, "image/webp"},
    {":/image_webp", "application/x-gzip", false, 0},
    {":/image_webp", "application/x-gzip", true, "image/webp"},
    {":/image_webp", "audio/x-wave", false, 0},
    {":/image_webp", "audio/x-wave", true, "image/webp"},
    {":/image_webp", "image/webp", false, 0},
    {":/image_webp", "image/webp", true, "image/webp"},
    {":/image_webp", "image/gif", false, 0},
    {":/image_webp", "image/gif", true, "image/webp"},
    {":/image_webp", "image/png", false, 0},
    {":/image_webp", "image/png", true, "image/webp"},
    {":/image_webp", "image/jpeg", false, 0},
    {":/image_webp", "image/jpeg", true, "image/webp"},
    {":/image_webp", "image/bmp", false, 0},
    {":/image_webp", "image/bmp", true, "image/webp"},
    {":/image_webp", "image/vnd.microsoft.icon", false, 0},
    {":/image_webp", "image/vnd.microsoft.icon", true, "image/webp"},
    {":/image_webp", "application/rdf+xml", false, 0},
    {":/image_webp", "application/rdf+xml", true, 0},
    {":/image_webp", "application/rss+xml", false, 0},
    {":/image_webp", "application/rss+xml", true, 0},
    {":/image_webp", "application/atom+xml", false, 0},
    {":/image_webp", "application/atom+xml", true, 0},
    {":/text_html", "text/plain", false, "text/plain"},
    {":/text_html", "text/plain", true, "text/plain"},
    {":/text_html", "unknown/unknown", false, "text/html"},
    {":/text_html", "unknown/unknown", true, "text/html"},
    {":/text_html", "application/unknown", false, "text/html"},
    {":/text_html", "application/unknown", true, "text/html"},
    {":/text_html", "*/*", false, "text/html"},
    {":/text_html", "*/*", true, "text/html"},
    {":/text_html", "text/xml", false, 0},
    {":/text_html", "text/xml", true, 0},
    {":/text_html", "application/xml", false, 0},
    {":/text_html", "application/xml", true, 0},
    {":/text_html", "text/html", false, 0},
    {":/text_html", "text/html", true, 0},
    {":/text_html", "text/xml", false, 0},
    {":/text_html", "text/xml", true, 0},
    {":/text_html", "application/pdf", false, 0},
    {":/text_html", "application/pdf", true, 0},
    {":/text_html", "application/postscript", false, 0},
    {":/text_html", "application/postscript", true, 0},
    {":/text_html", "application/ogg", false, 0},
    {":/text_html", "application/ogg", true, 0},
    {":/text_html", "video/webm", false, 0},
    {":/text_html", "video/webm", true, 0},
    {":/text_html", "application/x-rar-compressed", false, 0},
    {":/text_html", "application/x-rar-compressed", true, 0},
    {":/text_html", "application/zip", false, 0},
    {":/text_html", "application/zip", true, 0},
    {":/text_html", "application/x-gzip", false, 0},
    {":/text_html", "application/x-gzip", true, 0},
    {":/text_html", "audio/x-wave", false, 0},
    {":/text_html", "audio/x-wave", true, 0},
    {":/text_html", "image/webp", false, 0},
    {":/text_html", "image/webp", true, 0},
    {":/text_html", "image/gif", false, 0},
    {":/text_html", "image/gif", true, 0},
    {":/text_html", "image/png", false, 0},
    {":/text_html", "image/png", true, 0},
    {":/text_html", "image/jpeg", false, 0},
    {":/text_html", "image/jpeg", true, 0},
    {":/text_html", "image/bmp", false, 0},
    {":/text_html", "image/bmp", true, 0},
    {":/text_html", "image/vnd.microsoft.icon", false, 0},
    {":/text_html", "image/vnd.microsoft.icon", true, 0},
    {":/text_html", "application/rdf+xml", false, 0},
    {":/text_html", "application/rdf+xml", true, 0},
    {":/text_html", "application/rss+xml", false, 0},
    {":/text_html", "application/rss+xml", true, 0},
    {":/text_html", "application/atom+xml", false, 0},
    {":/text_html", "application/atom+xml", true, 0},
    {":/text_xml", "text/plain", false, "text/plain"},
    {":/text_xml", "text/plain", true, "text/plain"},
    {":/text_xml", "unknown/unknown", false, "text/xml"},
    {":/text_xml", "unknown/unknown", true, "text/xml"},
    {":/text_xml", "application/unknown", false, "text/xml"},
    {":/text_xml", "application/unknown", true, "text/xml"},
    {":/text_xml", "*/*", false, "text/xml"},
    {":/text_xml", "*/*", true, "text/xml"},
    {":/text_xml", "text/xml", false, 0},
    {":/text_xml", "text/xml", true, 0},
    {":/text_xml", "application/xml", false, 0},
    {":/text_xml", "application/xml", true, 0},
    {":/text_xml", "text/html", false, 0},
    {":/text_xml", "text/html", true, 0},
    {":/text_xml", "text/xml", false, 0},
    {":/text_xml", "text/xml", true, 0},
    {":/text_xml", "application/pdf", false, 0},
    {":/text_xml", "application/pdf", true, 0},
    {":/text_xml", "application/postscript", false, 0},
    {":/text_xml", "application/postscript", true, 0},
    {":/text_xml", "application/ogg", false, 0},
    {":/text_xml", "application/ogg", true, 0},
    {":/text_xml", "video/webm", false, 0},
    {":/text_xml", "video/webm", true, 0},
    {":/text_xml", "application/x-rar-compressed", false, 0},
    {":/text_xml", "application/x-rar-compressed", true, 0},
    {":/text_xml", "application/zip", false, 0},
    {":/text_xml", "application/zip", true, 0},
    {":/text_xml", "application/x-gzip", false, 0},
    {":/text_xml", "application/x-gzip", true, 0},
    {":/text_xml", "audio/x-wave", false, 0},
    {":/text_xml", "audio/x-wave", true, 0},
    {":/text_xml", "image/webp", false, 0},
    {":/text_xml", "image/webp", true, 0},
    {":/text_xml", "image/gif", false, 0},
    {":/text_xml", "image/gif", true, 0},
    {":/text_xml", "image/png", false, 0},
    {":/text_xml", "image/png", true, 0},
    {":/text_xml", "image/jpeg", false, 0},
    {":/text_xml", "image/jpeg", true, 0},
    {":/text_xml", "image/bmp", false, 0},
    {":/text_xml", "image/bmp", true, 0},
    {":/text_xml", "image/vnd.microsoft.icon", false, 0},
    {":/text_xml", "image/vnd.microsoft.icon", true, 0},
    {":/text_xml", "application/rdf+xml", false, 0},
    {":/text_xml", "application/rdf+xml", true, 0},
    {":/text_xml", "application/rss+xml", false, 0},
    {":/text_xml", "application/rss+xml", true, 0},
    {":/text_xml", "application/atom+xml", false, 0},
    {":/text_xml", "application/atom+xml", true, 0},
    {":/video_webm", "text/plain", false, "video/webm"},
    {":/video_webm", "text/plain", true, "video/webm"},
    {":/video_webm", "unknown/unknown", false, "video/webm"},
    {":/video_webm", "unknown/unknown", true, "video/webm"},
    {":/video_webm", "application/unknown", false, "video/webm"},
    {":/video_webm", "application/unknown", true, "video/webm"},
    {":/video_webm", "*/*", false, "video/webm"},
    {":/video_webm", "*/*", true, "video/webm"},
    {":/video_webm", "text/xml", false, 0},
    {":/video_webm", "text/xml", true, 0},
    {":/video_webm", "application/xml", false, 0},
    {":/video_webm", "application/xml", true, 0},
    {":/video_webm", "text/html", false, 0},
    {":/video_webm", "text/html", true, 0},
    {":/video_webm", "text/xml", false, 0},
    {":/video_webm", "text/xml", true, 0},
    {":/video_webm", "application/pdf", false, 0},
    {":/video_webm", "application/pdf", true, 0},
    {":/video_webm", "application/postscript", false, 0},
    {":/video_webm", "application/postscript", true, 0},
    {":/video_webm", "application/ogg", false, 0},
    {":/video_webm", "application/ogg", true, 0},
    {":/video_webm", "video/webm", false, 0},
    {":/video_webm", "video/webm", true, 0},
    {":/video_webm", "application/x-rar-compressed", false, 0},
    {":/video_webm", "application/x-rar-compressed", true, 0},
    {":/video_webm", "application/zip", false, 0},
    {":/video_webm", "application/zip", true, 0},
    {":/video_webm", "application/x-gzip", false, 0},
    {":/video_webm", "application/x-gzip", true, 0},
    {":/video_webm", "audio/x-wave", false, 0},
    {":/video_webm", "audio/x-wave", true, 0},
    {":/video_webm", "image/webp", false, 0},
    {":/video_webm", "image/webp", true, 0},
    {":/video_webm", "image/gif", false, 0},
    {":/video_webm", "image/gif", true, 0},
    {":/video_webm", "image/png", false, 0},
    {":/video_webm", "image/png", true, 0},
    {":/video_webm", "image/jpeg", false, 0},
    {":/video_webm", "image/jpeg", true, 0},
    {":/video_webm", "image/bmp", false, 0},
    {":/video_webm", "image/bmp", true, 0},
    {":/video_webm", "image/vnd.microsoft.icon", false, 0},
    {":/video_webm", "image/vnd.microsoft.icon", true, 0},
    {":/video_webm", "application/rdf+xml", false, 0},
    {":/video_webm", "application/rdf+xml", true, 0},
    {":/video_webm", "application/rss+xml", false, 0},
    {":/video_webm", "application/rss+xml", true, 0},
    {":/video_webm", "application/atom+xml", false, 0},
    {":/video_webm", "application/atom+xml", true, 0}
};
static const size_t testListSize = sizeof(testList) / sizeof(testList[0]);

#endif // TestData_h
