/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.cpu;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.jfluid.results.ExportDataDumper;
import org.graalvm.visualvm.lib.jfluid.results.FilterSortSupport;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNodeFree;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.profiler.api.GoToSource;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIConstants;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.FilterComponent;
import org.graalvm.visualvm.lib.ui.components.JTreeTable;
import org.graalvm.visualvm.lib.ui.components.table.CustomBarCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.LabelBracketTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.LabelTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.tree.EnhancedTreeCellRenderer;
import org.graalvm.visualvm.lib.ui.components.tree.MethodNameTreeCellRenderer;
import org.graalvm.visualvm.lib.ui.components.treetable.AbstractTreeTableModel;
import org.graalvm.visualvm.lib.ui.components.treetable.ExtendedTreeTableModel;
import org.graalvm.visualvm.lib.ui.components.treetable.JTreeTablePanel;
import org.graalvm.visualvm.lib.ui.components.treetable.TreeTableModel;
import org.graalvm.visualvm.lib.ui.cpu.CPUResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.cpu.ScreenshotProvider;
import org.graalvm.visualvm.lib.ui.cpu.SnapshotCPUResultsPanel;

public class ReverseCallGraphPanel
extends SnapshotCPUResultsPanel
implements ScreenshotProvider {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.cpu.Bundle");
    private static final String PANEL_TITLE = messages.getString("ReverseCallGraphPanel_PanelTitle");
    private static final String PANEL_TITLE_SHORT = messages.getString("ReverseCallGraphPanel_PanelTitleShort");
    private static final String GO_TO_SOURCE_POPUP_ITEM = messages.getString("ReverseCallGraphPanel_GoToSourcePopupItem");
    private static final String ADD_ROOT_METHOD_POPUP_ITEM = messages.getString("ReverseCallGraphPanel_AddRootMethodPopupItem");
    private static final String METHOD_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_MethodColumnName");
    private static final String METHOD_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_MethodColumnToolTip");
    private static final String METHOD_FILTER_HINT = messages.getString("FlatProfilePanel_MethodFilterHint");
    private static final String CLASS_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_ClassColumnName");
    private static final String CLASS_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_ClassColumnToolTip");
    private static final String CLASS_FILTER_HINT = messages.getString("FlatProfilePanel_ClassFilterHint");
    private static final String PACKAGE_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_PackageColumnName");
    private static final String PACKAGE_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_PackageColumnToolTip");
    private static final String PACKAGE_FILTER_HINT = messages.getString("FlatProfilePanel_PackageFilterHint");
    private static final String TIME_REL_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_TimeRelColumnName");
    private static final String TIME_REL_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_TimeRelColumnToolTip");
    private static final String TIME_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_TimeColumnName");
    private static final String TIME_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_TimeColumnToolTip");
    private static final String TIME_CPU_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_TimeCpuColumnName");
    private static final String TIME_CPU_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_TimeCpuColumnToolTip");
    private static final String INVOCATIONS_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_InvocationsColumnName");
    private static final String INVOCATIONS_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_InvocationsColumnToolTip");
    private static final String TREETABLE_ACCESS_NAME = messages.getString("ReverseCallGraphPanel_TreeTableAccessName");
    private static final String FILTER_ITEM_NAME = messages.getString("FlatProfilePanel_FilterItemName");
    private static final String SAMPLES_COLUMN_NAME = messages.getString("CCTDisplay_SamplesColumnName");
    private static final String SAMPLES_COLUMN_TOOLTIP = messages.getString("CCTDisplay_SamplesColumnToolTip");
    protected JButton cornerButton;
    protected JTreeTable treeTable;
    protected JTreeTablePanel treeTablePanel;
    protected FilterComponent filterComponent;
    protected boolean sortOrder;
    protected int selectedMethodId;
    protected int sortingColumn;
    protected int threadId;
    private AbstractTreeTableModel abstractTreeTableModel;
    private EnhancedTreeCellRenderer enhancedTreeCellRenderer = new MethodNameTreeCellRenderer();
    private ExtendedTreeTableModel treeTableModel;
    private Icon leafIcon = Icons.getIcon((String)"ProfilerIcons.NodeReverse");
    private Icon nodeIcon = Icons.getIcon((String)"ProfilerIcons.NodeReverse");
    private int minNamesColumnWidth;

    public ReverseCallGraphPanel(CPUResUserActionsHandler actionsHandler, Boolean sampling) {
        super(actionsHandler, sampling);
        this.enhancedTreeCellRenderer.setLeafIcon(this.leafIcon);
        this.enhancedTreeCellRenderer.setClosedIcon(this.nodeIcon);
        this.enhancedTreeCellRenderer.setOpenIcon(this.nodeIcon);
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        this.cornerPopup = new JPopupMenu();
        this.cornerButton = this.createHeaderPopupCornerButton(this.cornerPopup);
        this.setDefaultSorting();
    }

    public void exportData(int exportedFileType, ExportDataDumper eDD, String viewName) {
        this.percentFormat.setMaximumFractionDigits(2);
        this.percentFormat.setMinimumFractionDigits(2);
        PrestimeCPUCCTNodeFree.setPercentFormat((NumberFormat)this.percentFormat);
        switch (exportedFileType) {
            case 1: {
                eDD.dumpData((CharSequence)this.getCSVHeader(","));
                ((PrestimeCPUCCTNodeFree)this.abstractTreeTableModel.getRoot()).exportCSVData(",", exportedFileType, eDD);
                eDD.close();
                break;
            }
            case 2: {
                eDD.dumpData((CharSequence)this.getCSVHeader(";"));
                ((PrestimeCPUCCTNodeFree)this.abstractTreeTableModel.getRoot()).exportCSVData(";", exportedFileType, eDD);
                eDD.close();
                break;
            }
            case 3: {
                eDD.dumpData((CharSequence)this.getXMLHeader(viewName));
                ((PrestimeCPUCCTNodeFree)this.abstractTreeTableModel.getRoot()).exportXMLData(eDD, "  ");
                eDD.dumpDataAndClose(this.getXMLFooter());
                break;
            }
            case 4: {
                eDD.dumpData((CharSequence)this.getHTMLHeader(viewName));
                ((PrestimeCPUCCTNodeFree)this.abstractTreeTableModel.getRoot()).exportHTMLData(eDD, 0);
                eDD.dumpDataAndClose(this.getHTMLFooter());
            }
        }
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    private StringBuffer getCSVHeader(String separator) {
        String newLine = "\r\n";
        String quote = "\"";
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.columnCount; ++i) {
            result.append(quote).append(this.columnNames[i]).append(quote).append(separator);
        }
        result.append(newLine);
        return result;
    }

    private StringBuffer getHTMLHeader(String viewName) {
        StringBuffer result = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE><style type=\"text/css\">pre.method{overflow:auto;width:600;height:30;vertical-align:baseline}pre.parent{overflow:auto;width:400;height:30;vertical-align:baseline}td.method{text-align:left;width:600}td.parent{text-align:left;width:400}td.right{text-align:right;white-space:nowrap}</style></HEAD><BODY><table border=\"1\"><tr>");
        for (int i = 0; i < this.columnCount; ++i) {
            result.append("<th>").append(this.columnNames[i]).append(this.columnNames[i].equals("Total Time") ? " [&micro;s]" : "").append("</th>");
        }
        result.append("</tr>");
        return result;
    }

    private StringBuffer getHTMLFooter() {
        return new StringBuffer("</TABLE></BODY></HTML>");
    }

    private StringBuffer getXMLHeader(String viewName) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<ExportedView Name=\"" + viewName + "\" type=\"tree\">" + newline + "<tree>" + newline);
        return result;
    }

    private StringBuffer getXMLFooter() {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer("</tree>" + newline + "</ExportedView>");
        return result;
    }

    @Override
    public int getCurrentThreadId() {
        return this.threadId;
    }

    @Override
    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        if (this.treeTablePanel == null || this.treeTable == null) {
            return null;
        }
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.treeTablePanel.getScrollPane());
        }
        return UIUtils.createScreenshot(this.treeTable);
    }

    public void setDataToDisplay(CPUResultsSnapshot snapshot, int threadId, int view) {
        super.setDataToDisplay(snapshot, view);
        this.threadId = threadId;
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    @Override
    public String getDefaultViewName() {
        return "cpu-backtraces";
    }

    public void setFindString(String findString) {
        this.treeTable.setFindParameters(findString, 0);
    }

    public String getFindString() {
        return this.treeTable.getFindString();
    }

    public boolean isFindStringDefined() {
        return this.treeTable.isFindStringDefined();
    }

    public void setSelectedMethodId(int selectedMethodId) {
        this.selectedMethodId = selectedMethodId;
    }

    public int getSelectedMethodId() {
        return this.selectedMethodId;
    }

    @Override
    public String getSelectedMethodName() {
        String name = this.snapshot.getInstrMethodClasses(this.currentView)[this.selectedMethodId];
        if (this.currentView == 0) {
            name = name + "." + this.snapshot.getInstrMethodNames()[this.selectedMethodId] + this.snapshot.getInstrMethodSignatures()[this.selectedMethodId];
        }
        return name;
    }

    public String getSelectedMethodNameShort() {
        if (this.currentView == 0) {
            return this.snapshot.getInstrMethodNames()[this.selectedMethodId];
        }
        return this.snapshot.getInstrMethodClasses(this.currentView)[this.selectedMethodId];
    }

    public String getShortTitle() {
        return MessageFormat.format(PANEL_TITLE_SHORT, this.getSelectedMethodNameShort());
    }

    public void setSorting(int sColumn, boolean sOrder) {
        if (sColumn == -1) {
            this.setDefaultSorting();
        } else {
            this.sortingColumn = sColumn;
            this.sortOrder = sOrder;
        }
    }

    @Override
    public int getSortingColumn() {
        return this.sortingColumn;
    }

    @Override
    public boolean getSortingOrder() {
        return this.sortOrder;
    }

    public String getTitle() {
        return MessageFormat.format(PANEL_TITLE, this.getSelectedMethodName());
    }

    public boolean findFirst() {
        return this.treeTable.findFirst();
    }

    public boolean findNext() {
        return this.treeTable.findNext();
    }

    public boolean findPrevious() {
        return this.treeTable.findPrevious();
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.treeTablePanel.getScrollPane().getVerticalScrollBar().isEnabled();
    }

    @Override
    public void prepareResults() {
        this.initColumnsData();
        PrestimeCPUCCTNode rootNode = this.snapshot.getReverseCCT(this.threadId, this.selectedMethodId, this.currentView);
        this.abstractTreeTableModel = new AbstractTreeTableModel((CCTNode)rootNode, this.sortingColumn, this.sortOrder){

            @Override
            public int getColumnCount() {
                return ReverseCallGraphPanel.this.columnCount;
            }

            @Override
            public String getColumnName(int column) {
                return ReverseCallGraphPanel.this.columnNames[column];
            }

            @Override
            public Class getColumnClass(int column) {
                if (column == 0) {
                    return TreeTableModel.class;
                }
                return Object.class;
            }

            @Override
            public Object getValueAt(Object node, int column) {
                if (!ReverseCallGraphPanel.this.snapshot.isCollectingTwoTimeStamps() && column > 2) {
                    ++column;
                }
                PrestimeCPUCCTNode pNode = (PrestimeCPUCCTNode)node;
                switch (column) {
                    case 0: {
                        return this.getNodeName(pNode);
                    }
                    case 1: {
                        return this.getNodeTimeRel(pNode);
                    }
                    case 2: {
                        return this.getNodeTime(pNode);
                    }
                    case 3: {
                        return this.getNodeSecondaryTime(pNode);
                    }
                    case 4: {
                        return this.getNodeInvocations(pNode);
                    }
                }
                return null;
            }

            @Override
            public String getColumnToolTipText(int col) {
                return ReverseCallGraphPanel.this.columnToolTips[col];
            }

            private String getNodeName(PrestimeCPUCCTNode pNode) {
                return pNode.toString();
            }

            private Float getNodeTimeRel(PrestimeCPUCCTNode pNode) {
                return new Float(pNode.getTotalTime0InPerCent());
            }

            private String getNodeTime(PrestimeCPUCCTNode pNode) {
                return StringUtils.mcsTimeToString((long)pNode.getTotalTime0()) + " ms (" + ReverseCallGraphPanel.this.percentFormat.format(pNode.getTotalTime0InPerCent() / 100.0f) + ")";
            }

            private String getNodeSecondaryTime(PrestimeCPUCCTNode pNode) {
                return StringUtils.mcsTimeToString((long)pNode.getTotalTime1()) + " ms";
            }

            private Integer getNodeInvocations(PrestimeCPUCCTNode pNode) {
                return pNode.getNCalls();
            }

            @Override
            public void sortByColumn(int column, boolean order) {
                ReverseCallGraphPanel.this.sortOrder = order;
                if (!ReverseCallGraphPanel.this.snapshot.isCollectingTwoTimeStamps() && column > 2) {
                    ++column;
                }
                PrestimeCPUCCTNode pRoot = (PrestimeCPUCCTNode)this.root;
                switch (column) {
                    case 0: {
                        pRoot.sortChildren(1, order);
                        break;
                    }
                    case 1: {
                        pRoot.sortChildren(2, order);
                        break;
                    }
                    case 2: {
                        pRoot.sortChildren(2, order);
                        break;
                    }
                    case 3: {
                        pRoot.sortChildren(3, order);
                        break;
                    }
                    case 4: {
                        pRoot.sortChildren(4, order);
                    }
                }
            }

            @Override
            public boolean getInitialSorting(int column) {
                return column == 0;
            }
        };
        this.treeTableModel = new ExtendedTreeTableModel(this.abstractTreeTableModel);
        if (this.columnsVisibility != null) {
            this.treeTableModel.setColumnsVisibility(this.columnsVisibility);
        }
        this.treeTable = new JTreeTable(this.treeTableModel){

            @Override
            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                TableColumnModel colModel = this.getColumnModel();
                for (int i = 0; i < ReverseCallGraphPanel.this.treeTableModel.getColumnCount(); ++i) {
                    int index = ReverseCallGraphPanel.this.treeTableModel.getRealColumn(i);
                    if (index == 0) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += colModel.getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    colModel.getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, ReverseCallGraphPanel.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.treeTable.getAccessibleContext().setAccessibleName(TREETABLE_ACCESS_NAME);
        this.treeTable.setRowSelectionAllowed(true);
        this.treeTable.setSelectionMode(0);
        this.treeTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.treeTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.treeTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.treeTable.setShowHorizontalLines(false);
        this.treeTable.setShowVerticalLines(true);
        this.treeTable.setRowMargin(0);
        this.treeTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.treeTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReverseCallGraphPanel.this.performDefaultAction();
            }
        });
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.treeTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.treeTable.setFocusTraversalKeys(1, keys);
        this.setColumnsData();
        UIUtils.autoExpandRoot(this.treeTable.getTree(), 2);
        UIUtils.makeTreeAutoExpandable(this.treeTable.getTree(), 2);
        this.treeTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int selectedRow;
                if ((e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) && (selectedRow = ReverseCallGraphPanel.this.treeTable.getSelectedRow()) != -1) {
                    ReverseCallGraphPanel.this.popupPath = ReverseCallGraphPanel.this.treeTable.getTree().getPathForRow(selectedRow);
                    PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)ReverseCallGraphPanel.this.popupPath.getLastPathComponent();
                    ReverseCallGraphPanel.this.enableDisablePopup(node);
                    Rectangle cellRect = ReverseCallGraphPanel.this.treeTable.getCellRect(selectedRow, 0, false);
                    ReverseCallGraphPanel.this.callGraphPopupMenu.show(e.getComponent(), cellRect.x + ReverseCallGraphPanel.this.treeTable.getSize().width > 50 ? 50 : 5, cellRect.y);
                }
            }
        });
        this.treeTable.addMouseListener(new MouseAdapter(){

            private void showPopupMenu(MouseEvent e) {
                ReverseCallGraphPanel.this.popupPath = ReverseCallGraphPanel.this.treeTable.getTree().getPathForRow(ReverseCallGraphPanel.this.treeTable.rowAtPoint(e.getPoint()));
                if (ReverseCallGraphPanel.this.popupPath == null) {
                    ReverseCallGraphPanel.this.treeTable.getTree().clearSelection();
                } else {
                    ReverseCallGraphPanel.this.treeTable.getTree().setSelectionPath(ReverseCallGraphPanel.this.popupPath);
                    PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)ReverseCallGraphPanel.this.popupPath.getLastPathComponent();
                    ReverseCallGraphPanel.this.enableDisablePopup(node);
                    ReverseCallGraphPanel.this.callGraphPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ReverseCallGraphPanel.this.popupPath = ReverseCallGraphPanel.this.treeTable.getTree().getPathForRow(ReverseCallGraphPanel.this.treeTable.rowAtPoint(e.getPoint()));
                if (ReverseCallGraphPanel.this.popupPath != null) {
                    ReverseCallGraphPanel.this.treeTable.getTree().setSelectionPath(ReverseCallGraphPanel.this.popupPath);
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && ReverseCallGraphPanel.this.treeTableModel.isLeaf(ReverseCallGraphPanel.this.popupPath.getPath()[ReverseCallGraphPanel.this.popupPath.getPath().length - 1])) {
                        ReverseCallGraphPanel.this.showSourceForMethod(ReverseCallGraphPanel.this.popupPath);
                    }
                }
            }
        });
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = ReverseCallGraphPanel.this.treeTable.getSelectedRow();
                if (selectedRow == -1) {
                    return;
                }
                ReverseCallGraphPanel.this.popupPath = ReverseCallGraphPanel.this.treeTable.getTree().getPathForRow(selectedRow);
            }
        });
        this.treeTablePanel = new JTreeTablePanel(this.treeTable);
        this.treeTablePanel.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
        this.treeTablePanel.clearBorders();
        this.add((Component)this.treeTablePanel, "Center");
        this.initFilterPanel();
        this.initFirstColumnName();
    }

    private void initFilterPanel() {
        this.filterComponent = FilterComponent.create(true, true);
        FilterSortSupport.Configuration config = this.snapshot.getFilterSortInfo((CCTNode)((PrestimeCPUCCTNode)this.treeTableModel.getRoot()));
        this.filterComponent.setFilter(config.getFilterString(), config.getFilterType());
        this.filterComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String filterString = ReverseCallGraphPanel.this.filterComponent.getFilterValue();
                int filterType = ReverseCallGraphPanel.this.filterComponent.getFilterType();
                ReverseCallGraphPanel.this.snapshot.filterReverse(filterString, filterType, (PrestimeCPUCCTNodeFree)ReverseCallGraphPanel.this.abstractTreeTableModel.getRoot(), ReverseCallGraphPanel.this.currentView);
                ReverseCallGraphPanel.this.treeTable.updateTreeTable();
            }
        });
        this.add((Component)this.filterComponent.getComponent(), "South");
    }

    private void enableDisablePopup(PrestimeCPUCCTNode node) {
        boolean regularNode;
        boolean bl = regularNode = node.getMethodId() != 0 && !node.isFiltered();
        if (this.popupShowSource != null) {
            this.popupShowSource.setEnabled(regularNode && this.isShowSourceAvailable());
        }
    }

    @Override
    public void requestFocus() {
        if (this.treeTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReverseCallGraphPanel.this.treeTable.requestFocus();
                }
            });
        }
    }

    @Override
    public void reset() {
        if (this.treeTablePanel != null) {
            this.remove(this.treeTablePanel);
            this.treeTablePanel = null;
        }
        this.treeTable = null;
        this.abstractTreeTableModel = null;
        this.treeTableModel = null;
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        if (GoToSource.isAvailable()) {
            this.popupShowSource = new JMenuItem();
        }
        Font boldfont = popup.getFont().deriveFont(1);
        if (this.popupShowSource != null) {
            this.popupShowSource.setFont(boldfont);
            this.popupShowSource.setText(GO_TO_SOURCE_POPUP_ITEM);
            popup.add(this.popupShowSource);
            popup.addSeparator();
        }
        ActionListener menuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReverseCallGraphPanel.this.menuActionPerformed(evt);
            }
        };
        if (this.popupShowSource != null) {
            this.popupShowSource.addActionListener(menuListener);
        }
        return popup;
    }

    @Override
    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.columnCount; ++i) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            menuItem.setActionCommand(Integer.toString(i));
            this.addMenuItemListener(menuItem);
            if (this.treeTable != null) {
                menuItem.setState(this.treeTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    menuItem.setEnabled(false);
                }
            } else {
                menuItem.setState(true);
            }
            this.cornerPopup.add(menuItem);
        }
        this.cornerPopup.addSeparator();
        JCheckBoxMenuItem filterMenuItem = new JCheckBoxMenuItem(FILTER_ITEM_NAME);
        filterMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(filterMenuItem);
        if (this.filterComponent == null) {
            filterMenuItem.setState(true);
        } else {
            filterMenuItem.setState(this.filterComponent.getComponent().isVisible());
        }
        this.cornerPopup.add(filterMenuItem);
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel colModel = this.treeTable.getColumnModel();
        this.treeTable.setTreeCellRenderer(this.enhancedTreeCellRenderer);
        colModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int index = this.treeTableModel.getRealColumn(i);
            if (index == 0) continue;
            colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private void addMenuItemListener(JCheckBoxMenuItem menuItem) {
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Filter")) {
                    ReverseCallGraphPanel.this.filterComponent.getComponent().setVisible(!ReverseCallGraphPanel.this.filterComponent.getComponent().isVisible());
                    return;
                }
                boolean sortResults = false;
                int column = Integer.parseInt(e.getActionCommand());
                boolean sortOrder = ReverseCallGraphPanel.this.treeTable.getSortingOrder();
                int sortingColumn = ReverseCallGraphPanel.this.treeTable.getSortingColumn();
                int realSortingColumn = ReverseCallGraphPanel.this.treeTableModel.getRealColumn(sortingColumn);
                boolean isColumnVisible = ReverseCallGraphPanel.this.treeTableModel.isRealColumnVisible(column);
                if (isColumnVisible && column == realSortingColumn) {
                    sortingColumn = sortingColumn + 1 == ReverseCallGraphPanel.this.treeTableModel.getColumnCount() ? sortingColumn - 1 : sortingColumn + 1;
                    realSortingColumn = ReverseCallGraphPanel.this.treeTableModel.getRealColumn(sortingColumn);
                    sortResults = true;
                }
                ReverseCallGraphPanel.this.treeTableModel.setRealColumnVisibility(column, !isColumnVisible);
                ReverseCallGraphPanel.this.treeTable.createDefaultColumnsFromModel();
                ReverseCallGraphPanel.this.treeTable.updateTreeTableHeader();
                sortingColumn = ReverseCallGraphPanel.this.treeTableModel.getVirtualColumn(realSortingColumn);
                if (sortResults) {
                    sortOrder = ReverseCallGraphPanel.this.treeTableModel.getInitialSorting(sortingColumn);
                    ReverseCallGraphPanel.this.treeTableModel.sortByColumn(sortingColumn, sortOrder);
                    ReverseCallGraphPanel.this.treeTable.updateTreeTable();
                }
                ReverseCallGraphPanel.this.treeTable.setSortingColumn(sortingColumn);
                ReverseCallGraphPanel.this.treeTable.setSortingOrder(sortOrder);
                ReverseCallGraphPanel.this.treeTable.getTableHeader().repaint();
                ReverseCallGraphPanel.this.setColumnsData();
            }
        });
    }

    private void initColumnsData() {
        this.columnCount = this.snapshot.isCollectingTwoTimeStamps() ? 5 : 4;
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnsVisibility = new boolean[this.columnCount];
        for (int i = 0; i < this.columnCount - 1; ++i) {
            this.columnsVisibility[i] = true;
        }
        if (this.isSampling() != null && !this.isSampling().booleanValue()) {
            this.columnsVisibility[this.columnCount - 1] = true;
        }
        if (this.columnCount == 5) {
            this.columnNames = new String[]{METHOD_COLUMN_NAME, TIME_REL_COLUMN_NAME, TIME_COLUMN_NAME, TIME_CPU_COLUMN_NAME, INVOCATIONS_COLUMN_NAME};
            this.columnToolTips = new String[]{METHOD_COLUMN_TOOLTIP, TIME_REL_COLUMN_TOOLTIP, TIME_COLUMN_TOOLTIP, TIME_CPU_COLUMN_TOOLTIP, INVOCATIONS_COLUMN_TOOLTIP};
        } else {
            this.columnNames = new String[]{METHOD_COLUMN_NAME, TIME_REL_COLUMN_NAME, TIME_COLUMN_NAME, INVOCATIONS_COLUMN_NAME};
            this.columnToolTips = new String[]{METHOD_COLUMN_TOOLTIP, TIME_REL_COLUMN_TOOLTIP, TIME_COLUMN_TOOLTIP, INVOCATIONS_COLUMN_TOOLTIP};
        }
        if (this.isSampling() != null && this.isSampling().booleanValue()) {
            this.columnNames[this.columnCount - 1] = SAMPLES_COLUMN_NAME;
            this.columnToolTips[this.columnCount - 1] = SAMPLES_COLUMN_TOOLTIP;
        }
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        CustomBarCellRenderer customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = maxWidth;
        this.columnRenderers[1] = customBarCellRenderer;
        this.columnWidths[1] = maxWidth;
        this.columnRenderers[2] = labelBracketTableCellRenderer;
        for (int i = 3; i < this.columnCount; ++i) {
            this.columnWidths[i - 1] = maxWidth;
            this.columnRenderers[i] = labelTableCellRenderer;
        }
        if (this.isSampling() == null) {
            --this.columnCount;
        }
    }

    private void initFirstColumnName() {
        switch (this.currentView) {
            case 0: {
                this.columnNames[0] = METHOD_COLUMN_NAME;
                this.columnToolTips[0] = METHOD_COLUMN_TOOLTIP;
                this.filterComponent.setHint(METHOD_FILTER_HINT);
                break;
            }
            case 1: {
                this.columnNames[0] = CLASS_COLUMN_NAME;
                this.columnToolTips[0] = CLASS_COLUMN_TOOLTIP;
                this.filterComponent.setHint(CLASS_FILTER_HINT);
                break;
            }
            case 2: {
                this.columnNames[0] = PACKAGE_COLUMN_NAME;
                this.columnToolTips[0] = PACKAGE_COLUMN_TOOLTIP;
                this.filterComponent.setHint(PACKAGE_FILTER_HINT);
            }
        }
    }
}

