/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.military;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.ai.AIColony;

public final class DefensiveZone {
    private final AIColony aiColony;
    private final Set<Unit> potentialEnemies = new HashSet<Unit>();
    private final Set<Settlement> potentialEnemySettlements = new HashSet<Settlement>();
    private boolean exposedLand = false;
    private boolean exposedWater = false;
    private final Set<DefensiveZone> neighbours = new HashSet<DefensiveZone>();
    private boolean enemiesInNeighbour = false;

    public DefensiveZone(AIColony aiColony) {
        this.aiColony = aiColony;
    }

    public AIColony getAiColony() {
        return this.aiColony;
    }

    public void setExposedWater(boolean exposedWater) {
        this.exposedWater = exposedWater;
    }

    public void setExposedLand(boolean exposedLand) {
        this.exposedLand = exposedLand;
    }

    public void setEnemiesInNeighbour(boolean enemiesInNeighbour) {
        this.enemiesInNeighbour = enemiesInNeighbour;
    }

    public void addAllPotentialEnemies(Set<Unit> units) {
        this.potentialEnemies.addAll(units);
    }

    public void addPotentialEnemySettlement(Settlement settlement) {
        this.potentialEnemySettlements.add(settlement);
    }

    public void addNeighbour(DefensiveZone defensiveZone) {
        this.neighbours.add(defensiveZone);
    }

    public boolean isExposed() {
        return this.exposedLand || this.exposedWater;
    }

    public boolean isExposedWater() {
        return this.exposedWater;
    }

    public boolean isExposedLand() {
        return this.exposedLand;
    }

    public boolean isEnemiesInNeighbour() {
        return this.enemiesInNeighbour;
    }

    public Set<Unit> getEnemies() {
        return this.potentialEnemies.stream().filter(this.enemiesOnly()).collect(Collectors.toSet());
    }

    public int getNumberOfMilitaryEnemies() {
        int unitEnemies = (int)this.potentialEnemies.stream().filter(this.enemiesOnly()).filter(u -> u.isOffensiveUnit()).filter(u -> !u.getOwner().isIndian()).count();
        int settlementEnemies = (int)this.potentialEnemySettlements.stream().filter(this.enemiesOnly()).filter(s -> !(s instanceof IndianSettlement)).count();
        return unitEnemies + settlementEnemies;
    }

    public int getNumberOfPotentialMilitaryEnemies() {
        int unitEnemies = (int)this.potentialEnemies.stream().filter(u -> u.isOffensiveUnit()).filter(u -> !u.getOwner().isIndian()).count();
        int settlementEnemies = (int)this.potentialEnemySettlements.stream().filter(s -> !(s instanceof IndianSettlement)).count();
        return unitEnemies + settlementEnemies;
    }

    private Player getPlayer() {
        return this.aiColony.getColony().getOwner();
    }

    public Set<DefensiveZone> getNeighbours() {
        return this.neighbours;
    }

    private Predicate<? super Ownable> enemiesOnly() {
        return u -> this.getPlayer().atWarWith(u.getOwner());
    }

    public int hashCode() {
        return Objects.hash(this.aiColony);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefensiveZone other = (DefensiveZone)obj;
        return Objects.equals(this.aiColony, other.aiColony);
    }
}

