/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class TrainUnitInEuropeMessage
extends AttributeMessage {
    public static final String TAG = "trainUnitInEurope";
    private static final String UNIT_TYPE_TAG = "unitType";

    public TrainUnitInEuropeMessage(UnitType type) {
        super(TAG, UNIT_TYPE_TAG, type.getId());
    }

    public TrainUnitInEuropeMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TYPE_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        String typeId = this.getStringAttribute(UNIT_TYPE_TAG);
        UnitType type = freeColServer.getSpecification().getUnitType(typeId);
        if (type == null) {
            return serverPlayer.clientError("Not a unit type: " + typeId);
        }
        return this.igc(freeColServer).trainUnitInEurope(serverPlayer, type);
    }
}

