/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class Role
extends BuildableType {
    public static final String TAG = "role";
    public static final Comparator<Role> militaryComparator = Comparator.comparingDouble(r -> r.getOffence() + r.getDefence()).reversed();
    private Role downgrade;
    private int maximumCount = 1;
    private UnitType expertUnit = null;
    private List<RoleChange> roleChanges = null;
    private static final String CAPTURE_TAG = "capture";
    private static final String DOWNGRADE_TAG = "downgrade";
    private static final String FROM_TAG = "from";
    private static final String EXPERT_UNIT_TAG = "expert-unit";
    private static final String MAXIMUM_COUNT_TAG = "maximum-count";
    private static final String ROLE_CHANGE_TAG = "role-change";
    private static final String OLD_EXPERT_UNIT_TAG = "expertUnit";
    private static final String OLD_MAXIMUM_COUNT_TAG = "maximumCount";

    public Role(String id, Specification specification) {
        super(id, specification);
    }

    public static boolean isDefaultRoleId(String roleId) {
        return "model.role.default".equals(roleId);
    }

    public boolean isDefaultRole() {
        return Role.isDefaultRoleId(this.getId());
    }

    public String getRoleSuffix() {
        return Role.getRoleIdSuffix(this.getId());
    }

    public static String getRoleIdSuffix(String roleId) {
        return StringUtils.lastPart(roleId, ".");
    }

    public final Role getDowngrade() {
        return this.downgrade;
    }

    public final void setDowngrade(Role newDowngrade) {
        this.downgrade = newDowngrade;
    }

    public final int getMaximumCount() {
        return this.maximumCount;
    }

    public final void setMaximumCount(int newMaximumCount) {
        this.maximumCount = newMaximumCount;
    }

    public final UnitType getExpertUnit() {
        return this.expertUnit;
    }

    public final void setExpertUnit(UnitType newExpertUnit) {
        this.expertUnit = newExpertUnit;
    }

    public List<AbstractGoods> getRequiredGoodsList(int roleCount) {
        List<AbstractGoods> result = this.getRequiredGoodsList();
        if (roleCount > 1 && !result.isEmpty()) {
            for (AbstractGoods ag : result) {
                ag.setAmount(roleCount * ag.getAmount());
            }
        }
        return result;
    }

    public Stream<AbstractGoods> getRequiredGoods(int roleCount) {
        return this.getRequiredGoodsList(roleCount).stream();
    }

    public int getRequiredGoodsPrice(Market market) {
        return CollectionUtils.sum(this.getRequiredGoods(), ag -> market.getBidPrice(ag.getType(), ag.getAmount() * this.getMaximumCount()));
    }

    public final List<RoleChange> getRoleChanges() {
        if (this.roleChanges == null) {
            this.roleChanges = new ArrayList<RoleChange>();
        }
        return this.roleChanges;
    }

    protected final void setRoleChanges(List<RoleChange> roleChanges) {
        if (this.roleChanges == null) {
            this.roleChanges = new ArrayList<RoleChange>();
        } else {
            this.roleChanges.clear();
        }
        this.roleChanges.addAll(roleChanges);
    }

    private void addRoleChange(String from, String capture) {
        if (this.roleChanges == null) {
            this.roleChanges = new ArrayList<RoleChange>();
        }
        this.roleChanges.add(new RoleChange(from, capture));
    }

    public double getOffence() {
        return this.apply(0.0f, null, "model.modifier.offence");
    }

    public boolean isOffensive() {
        return this.hasModifier("model.modifier.offence");
    }

    private double getDefence() {
        return this.apply(0.0f, null, "model.modifier.defence");
    }

    public boolean isDefensive() {
        return this.hasModifier("model.modifier.defence");
    }

    public boolean isCompatibleWith(Role other) {
        return Role.rolesCompatible(this, other);
    }

    public static boolean rolesCompatible(Role role1, Role role2) {
        if (role1 == null) {
            return role2 == null;
        }
        if (role2 == null) {
            return false;
        }
        return role1 == role2 || role1.getDowngrade() == role2 || role2.getDowngrade() == role1;
    }

    public static List<AbstractGoods> getGoodsDifference(Role from, int fromCount, Role to, int toCount) {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        if (!(from == to || from == null && to.isDefaultRole())) {
            List<Object> fromGoods = from == null ? new ArrayList() : from.getRequiredGoodsList(fromCount);
            List<AbstractGoods> toGoods = to.getRequiredGoodsList(toCount);
            for (AbstractGoods ag2 : toGoods) {
                int amount = ag2.getAmount() - AbstractGoods.getCount(ag2.getType(), fromGoods);
                if (amount == 0) continue;
                result.add(new AbstractGoods(ag2.getType(), amount));
            }
            result.addAll(CollectionUtils.transform(fromGoods, ag -> !CollectionUtils.any(toGoods, AbstractGoods.matches(ag.getType())), ag -> new AbstractGoods(ag.getType(), -ag.getAmount())));
        }
        return result;
    }

    public int getRoleIndex() {
        int base = this.requiresAbility("model.ability.native") ? 30 : (this.requiresAbility("model.ability.refUnit") ? 20 : 10);
        return base - this.getRequiredGoodsList().size();
    }

    public static List<Role> getAvailableRoles(Player player, UnitType type, List<Role> roles) {
        return CollectionUtils.transform(roles, r -> r.isAvailableTo(player, type));
    }

    public String toFullString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[Role ").append(this.getSuffix());
        CollectionUtils.forEachMapEntry(this.getRequiredAbilities(), e -> sb.append(' ').append((String)e.getKey()).append('=').append(e.getValue()));
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Colony.NoBuildReason canBeBuiltInColony(Colony colony, List<BuildableType> assumeBuilt) {
        return Colony.NoBuildReason.NONE;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Role o = this.copyInCast(other, Role.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.downgrade = o.getDowngrade();
        this.maximumCount = o.getMaximumCount();
        this.expertUnit = o.getExpertUnit();
        this.setRoleChanges(o.getRoleChanges());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.downgrade != null) {
            xw.writeAttribute(DOWNGRADE_TAG, this.downgrade);
        }
        if (this.expertUnit != null) {
            xw.writeAttribute(EXPERT_UNIT_TAG, this.expertUnit);
        }
        if (this.maximumCount > 1) {
            xw.writeAttribute(MAXIMUM_COUNT_TAG, this.maximumCount);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (RoleChange rc : this.getRoleChanges()) {
            xw.writeStartElement(ROLE_CHANGE_TAG);
            xw.writeAttribute(FROM_TAG, rc.from);
            xw.writeAttribute(CAPTURE_TAG, rc.capture);
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        this.downgrade = xr.getType(spec, DOWNGRADE_TAG, Role.class, null);
        this.expertUnit = xr.hasAttribute(OLD_EXPERT_UNIT_TAG) ? xr.getType(spec, OLD_EXPERT_UNIT_TAG, UnitType.class, null) : xr.getType(spec, EXPERT_UNIT_TAG, UnitType.class, null);
        this.maximumCount = xr.hasAttribute(OLD_MAXIMUM_COUNT_TAG) ? xr.getAttribute(OLD_MAXIMUM_COUNT_TAG, 1) : xr.getAttribute(MAXIMUM_COUNT_TAG, 1);
    }

    @Override
    protected void clearContainers(FreeColXMLReader xr) throws XMLStreamException {
        super.clearContainers(xr);
        this.roleChanges = null;
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (ROLE_CHANGE_TAG.equals(tag)) {
            String from = xr.getAttribute(FROM_TAG, null);
            String capture = xr.getAttribute(CAPTURE_TAG, null);
            this.addRoleChange(from, capture);
            xr.closeTag(ROLE_CHANGE_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    public static class RoleChange {
        public final String from;
        public final String capture;

        RoleChange(String from, String capture) {
            this.from = from;
            this.capture = capture;
        }

        public Role getFrom(Specification spec) {
            return spec.getRole(this.from);
        }

        public Role getCapture(Specification spec) {
            return spec.getRole(this.capture);
        }
    }
}

