/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Aquitaine for Mapael
* Equirectangular projection
* 
* @author CCM Benchmark Group
* @source http://fr.m.wikipedia.org/wiki/Fichier:France_location_map-Departements.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_72 : {
					width : 147.37883,
					height : 193.23335,
					getCoords : function (lat, lon) {
						var xfactor = 45.48385;
						var xoffset = 82.028;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -65.97284;
						var yoffset = 3014.8924;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-33" : "m 32.17,9.42 c -1.35,0.6 -1.67,2.33 -2.44,3.46 -0.9,1.15 -0.93,2.57 -0.99,3.96 -0.61,4.56 -0.18,9.24 -0.86,13.81 -0.54,4.31 -1.74,8.52 -1.95,12.89 -0.61,9.17 -2.18,18.25 -2.59,27.43 -0.23,0.48 0.43,1.07 0.51,0.37 0.12,-2.05 0.3,-4.24 1.78,-5.82 0.87,-0.89 1.14,-2.15 1.74,-3.18 1.21,-0.33 2.09,1.03 2.85,1.76 0.63,0.9 1.64,1.51 2.31,2.31 -0.15,0.54 -0.05,1.16 0.57,1.33 0.89,0.5 0.29,1.93 -0.63,2 -1.29,0.35 -2.75,0.59 -4.04,0.18 -0.46,-0.92 -1.95,-0.82 -2.18,0.22 -0.67,1.95 -0.9,4.12 -2.27,5.74 -1,1.52 0.46,3.25 0.04,4.89 -0.56,1.66 1.25,0.5 2.03,0.32 1.54,-0.68 3.4,-0.85 4.7,-1.95 0.37,-0.43 0.46,-1.26 0.94,-1.49 1.21,0.54 2.32,1.73 3.77,1.29 0.97,-0.01 0.89,1.32 0.88,2.01 -0.26,1.23 -0.86,2.4 -1.49,3.46 0.41,0.52 1.31,-0.06 1.87,-0.11 0.88,-0.1 1.78,-0.95 2.65,-0.7 1.26,0.68 2.7,1.33 4.15,1.39 0.95,-0.2 1.88,-0.68 2.53,-1.36 1.13,-0.52 2.4,-0.33 3.58,-0.23 0.42,-0.29 0.73,-0.99 1.37,-0.7 0.81,0.19 1.92,0.59 1.68,1.66 0.13,0.64 -0.15,1.31 -0.14,1.89 1.05,0.76 2.44,0.97 3.45,1.83 0.79,0.27 1.41,0.83 1.52,1.7 0.71,1.41 2.59,1.54 3.99,1.65 0.03,1.15 0.83,2.35 2.06,2.32 0.39,0.86 -0.23,1.95 -0.2,2.87 -0.13,0.87 -0.2,2.41 1.05,2.42 1.47,0.17 2.92,0.35 4.32,0.78 0.78,-0.08 1.67,-0.33 2.27,-0.79 0.05,-1.21 -0.43,-2.56 -0.04,-3.71 0.43,-0.21 1.01,-0.05 1.46,-0.32 1.09,0.27 1.03,1.87 2.02,2.36 0.58,0.83 0.85,-0.38 1.39,-0.35 0.82,0.69 1.56,-0.21 2.07,-0.76 0.74,-0.19 0.91,-1.16 1.56,-1.54 0.29,-0.56 -0.24,-1.15 -0.1,-1.75 -0.38,-1.09 -1.67,-1.67 -1.98,-2.76 0.06,-0.5 0.33,-0.96 0.89,-0.93 0.73,-0.5 1.85,-0.3 2.53,-0.96 0.37,-0.28 1.16,0.18 1.1,-0.57 0.09,-1.3 -1.54,-2.16 -0.97,-3.49 -0.03,-0.57 1.05,-1.42 0.17,-1.76 -0.65,-0.21 -0.45,-1.24 -0.54,-1.78 -0.08,-1.1 0.24,-2.35 1.37,-2.78 0.23,-0.52 -0.86,-1.1 -0.65,-1.58 0.42,0.05 0.76,0.79 1.19,0.23 0.54,-0.89 1.89,0.25 2.27,-0.85 0.42,-0.64 0.06,-1.88 1.14,-1.89 0.86,-0.29 1.33,-1.23 2.19,-1.44 0.21,-0.63 -0.73,-1.14 -0.43,-1.83 0.26,-0.42 1.09,0.83 1.23,-0.02 -0.18,-0.63 1.08,-1.19 0.41,-1.71 -0.56,-0.41 -1.38,0.04 -1.91,-0.19 -0,-0.61 -0.41,-1.09 -1.02,-1.04 -0.67,-0.51 -0.57,-1.57 0.21,-1.9 0.65,0.22 1.14,-0.35 1.03,-0.99 -0.13,-0.49 0.19,-0.8 0.6,-0.49 0.72,0.14 1.16,-0.47 1.49,-0.94 0.89,-0.03 0.33,1.48 1.2,1.41 0.29,-0.4 -0.11,-1.02 0.21,-1.48 0.05,-0.71 1.01,-1.42 1.37,-0.54 0.57,0.45 1.89,0.38 2.07,-0.4 -0.93,-1.21 -0.97,-2.77 -1.17,-4.22 0.94,0.41 1.89,-0.57 2.12,-1.32 -0.7,-0.72 -1.89,-1.75 -2.92,-1.16 -0.25,1.28 -1.94,1.44 -2.31,2.71 -0.25,0.7 -0.77,-0.16 -1.24,-0.03 -0.84,-0.1 -1.91,-0.43 -2.52,0.33 -0.49,0 -0.57,-1.31 -1.23,-0.7 -0.3,0.3 -0.56,0.98 -1.06,0.53 -0.52,-0.11 -1.13,-0.11 -1.3,-0.75 -0.32,-1.15 -1.67,-0.6 -2.48,-1 -0.36,-0.03 -1.06,-0.34 -0.4,-0.59 1.35,-0.39 1.54,-2.09 2.3,-3.08 0.95,-0.89 -0.46,-1.47 -0.68,-2.32 -0.21,-0.87 -0.08,-1.96 0.4,-2.7 1.15,-0.16 0.79,-1.67 0.9,-2.49 0.06,-1.42 1.66,-2.3 1.47,-3.79 -0.24,-1.15 -0.69,-2.82 -2.17,-2.71 -0.97,-0.05 -2.17,-0.17 -2.69,0.85 -0.68,0.81 -1.6,-0.07 -1.98,-0.72 -0.8,-0.86 -1.73,0.38 -2.23,0.93 -0.46,0.69 -1.24,0.78 -1.97,0.53 -1.18,-0.18 -2.19,-0.92 -3.37,-1.08 -1.04,-0.6 -1.16,-2.46 -2.52,-2.52 -0.33,0.07 -0.57,0.82 -0.8,0.16 -0.16,-0.99 -1.53,-2.19 -2.39,-1.24 -0.31,0.22 -0.3,0.97 -0.55,1.06 -0.69,-1.19 -0.87,-2.69 -1.58,-3.86 -0.25,-0.91 0.61,-1.8 0.34,-2.66 -0.29,-0.2 -0.77,-0.19 -0.54,-0.7 0.61,-1.25 -0.51,-1.67 -1.49,-2.04 -1.08,-0.8 -2.3,0.25 -3.44,-0.22 -0.61,-0.22 -1.49,-0.19 -1.92,-0.68 -0.26,-0.81 0.29,-1.98 -0.47,-2.54 -0.73,-0.01 -0.2,1.36 -1.01,1.09 -0.81,0.09 -1.62,0.47 -2.39,0.03 -0.86,-0.16 -1.78,-0.32 -2.64,-0.24 0.79,4.57 0.98,9.31 1.89,13.89 0.57,2.24 1.79,4.67 4.24,5.25 1.23,0.43 2.79,0.61 3.34,2.01 0.1,0.2 0.69,1.12 0.14,0.83 -0.99,-1.07 -2.51,-1.66 -3.95,-1.54 0.31,0.88 1.46,1.48 2.07,2.26 -0.27,1.98 -0.09,3.97 0.06,5.94 0.06,0.82 -0.29,0.46 -0.44,-0.1 -0.61,-1.89 -0.03,-4.07 -0.75,-5.91 -1.64,-1.75 -3.86,-2.98 -5.02,-5.15 -2.29,-3.19 -2.27,-7.29 -2.72,-11.04 -0.61,-2.8 -1.41,-5.61 -3,-8.03 -1.22,-1.92 -3.35,-3.02 -4.56,-4.97 -0.75,-1.2 -1.91,-2.11 -3.3,-2.37 -1.53,-0.82 -2.67,-2.26 -3.83,-3.56 -0.74,-0.96 0.63,-2.32 -0.22,-3.18 -0.12,-0.09 -0.29,-0.09 -0.44,-0.08 z",
					    "department-40" : "m 31.57,77.88 c -0.39,0.94 -0.87,1.95 -1.99,2.15 -1.85,0.78 -3.93,1.14 -5.67,2.13 -0.38,2.37 -0.67,4.75 -1.09,7.1 -0.43,4.37 -1.06,8.69 -1.87,13 -0.88,5.48 -2.1,10.93 -2.84,16.43 -0.59,2.95 -1.56,5.85 -1.84,8.84 -0.89,3.98 -1.4,8.08 -2.44,12.05 -0.24,1.45 -0.93,2.83 -1.03,4.28 0.65,0.43 1.31,-1.11 1.9,-0.15 0.28,0.38 0.16,1.05 0.81,1.1 1.09,0 1.22,1.58 2.36,1.37 1.31,0.06 2.5,-1.03 3.77,-0.38 1.24,1e-4 2.23,-1.09 3.28,-1.64 0.9,-0.41 1.66,-1.89 2.8,-1.25 0.62,0.63 1.47,1.22 1.79,2.05 -0.32,0.66 -1.7,0.2 -1.77,1.04 0.41,0.56 1.3,0.28 1.66,-0.15 0.8,0.09 0.94,-1.16 1.75,-0.85 0.47,0.14 0.63,-1.01 0.92,-0.36 0.23,0.96 1.31,0.25 1.92,0.7 0.71,0.36 2.01,0.19 1.85,-0.86 0.18,-0.39 -0.33,-0.8 -0.23,-1.09 0.86,-0.34 1.84,0.49 2.67,-0.02 0.88,0.34 1.14,-1.12 2.06,-0.77 0.73,-0.01 1.79,0.82 2.36,0.09 0.11,-0.76 1.12,-0.76 1.72,-0.76 0.66,-0.1 0.92,-0.65 1.21,-1.13 0.67,-0.41 1.14,0.75 1.63,1.05 0.5,0.29 0.55,1.04 1.04,1.25 0.63,-0.18 0.32,-1.41 1.19,-1.17 0.87,-0.05 1.59,-0.89 2.38,-0.94 -0.08,0.42 -0.84,1.13 0.03,1.27 0.79,0.19 1.53,1.42 2.38,0.67 0.36,-0.11 0.75,-1.13 1.15,-0.77 0.24,1.1 1.01,0.63 1.62,0.03 1.14,-0.97 2.31,-2.06 3.69,-2.63 0.48,0.19 1.16,0.8 0.51,1.25 -0.3,0.35 -1.3,1.39 -0.4,1.58 1.02,-0.34 1.92,-1.21 3.1,-0.95 0.97,-0.07 1.5,1.24 2.48,0.8 0.63,-0.25 1,-0.89 1.57,-1.19 0.17,-0.56 0.54,-1 1.19,-0.96 0.48,0.01 0.67,-0.4 0.44,-0.76 0.4,-0.43 0.26,-1.2 -0.45,-1.1 -0.48,0.13 -0.86,-0.1 -0.75,-0.63 7.3e-4,-0.45 -0.32,-1.23 0.4,-1.09 0.46,-0.22 0.54,-0.86 1.08,-0.94 0.64,-0.68 -0.84,-1.23 -0.21,-1.87 0.72,-0.47 -0.18,-1.85 0.85,-2 0.64,-0.44 1.51,-1 1.67,-1.8 -0.08,-0.49 -1.08,-0.17 -0.8,-0.8 0.55,-0.71 -0.35,-1.58 -0.26,-2.36 -0.03,-0.39 -0.41,-1.66 0.39,-1.43 0.87,0.21 0.72,-1.09 0.79,-1.62 0.16,-0.73 -1.03,-1.24 -0.3,-1.87 0.34,-0.34 0.76,-0.91 0.06,-1.19 -0.47,-0.46 -1.46,-0.34 -1.75,-0.92 0.11,-0.54 0.55,-1 1.1,-1 0.74,-0.32 1.11,-1.39 1.87,-1.53 0.37,0.31 0.74,0.13 0.94,-0.22 0.42,-0.07 0.91,-0.2 1.26,-0.35 0.41,0.23 1.2,1.44 1.25,0.34 -0.12,-0.95 1.23,-0.35 1.51,-1.13 0.39,-0.49 1.19,-0.61 1.16,-1.4 0.1,-0.73 0.84,0.01 1.09,0.25 0.45,0.48 1.55,1.29 0.83,1.98 -0.45,0.3 -0.92,0.96 -0.22,1.29 0.88,0.53 1.79,1.67 2.91,1.36 1.22,-0.89 0.1,-2.5 -0.21,-3.58 0.38,-0.82 1.13,-1.77 0.47,-2.66 -0.11,-0.57 -0.52,-1.41 -0.18,-1.89 1.01,-0.45 0.75,-1.9 1.28,-2.73 0.42,-0.71 0.43,-1.6 1.16,-2.13 0.42,-0.34 1.23,-1.27 0.34,-1.58 -1.75,-0.48 -3.8,-0.05 -5.25,-1.37 -1.3,-0.73 -2.91,-0.25 -4.3,-0.71 -0.64,-0.29 -1.47,0.52 -1.96,-0.07 -0.2,-1.84 0.26,-4.03 -1.33,-5.4 -0.54,-0.41 -0.67,-1.07 -1.02,-1.6 -0.58,-0.46 -1.57,-0.39 -2.11,0.01 0.04,1.23 0.08,2.47 0.12,3.7 -1.12,0.37 -2.23,1.1 -3.39,0.42 -1.34,-0.57 -2.94,-0.12 -4.21,-0.78 -0.67,-1.55 0.09,-3.21 0.02,-4.78 -0.35,-0.38 -1.04,-0.36 -1.39,-0.84 -0.66,-0.31 -0.42,-1.05 -0.68,-1.56 -0.99,-0.41 -2.19,-0.3 -3.14,-0.93 -1.2,-0.36 -0.74,-2.07 -1.98,-2.38 -1.26,-0.85 -2.64,-1.44 -4.06,-1.97 -0.52,-0.2 0.38,-0.65 0.24,-1.06 -0.05,-0.84 0.36,-2.22 -0.84,-2.31 -0.68,-0.42 -1.38,-0.47 -1.66,0.35 -0.61,0.36 -1.44,-0.19 -2.13,-0.02 -0.86,0 -1.85,0.22 -2.25,1.03 -0.91,0.08 -1.61,0.97 -2.59,0.67 -1.4,-0.16 -2.67,-1.01 -4,-1.37 -1.54,0.39 -3.15,1.18 -4.71,1.06 1.38,-1.46 2.22,-3.61 1.75,-5.64 -0.77,-0.32 -1.91,0.4 -2.61,-0.38 -0.59,-0.24 -1.25,-1.06 -1.85,-0.91 z",
					    "department-64" : "m 73.03,139.7 c -0.43,0.28 -0.97,0.98 -1.41,0.33 -0.76,-0.23 -1.48,0.85 -2.2,0.25 -0.62,-0.16 -1.13,0.24 -1.28,0.8 -0.63,0.67 -1.48,1.57 -2.46,1.4 -0.45,-0.54 -1.14,-0.59 -1.67,-0.94 -1.18,-0.17 -2.09,0.76 -3.14,1.01 -0.57,-0.12 -0.86,-1.03 -0.19,-1.28 0.56,-0.29 1.02,-1.22 0.18,-1.48 -0.77,0.18 -1.43,0.8 -2.16,1.16 -0.93,0.71 -1.75,1.82 -2.91,2.13 -0.06,-0.63 -0.75,-0.76 -1.13,-0.29 -0.45,0.42 -1.23,1.02 -1.72,0.31 -0.5,-0.73 -1.48,-0.59 -1.98,-1.29 -0.58,-0.23 -1.06,0.6 -1.68,0.29 -0.65,0.08 -0.07,1.43 -0.9,1.07 -0.83,-0.65 -1.37,-1.68 -2.28,-2.29 -0.62,-0.33 -0.3,0.97 -1.01,0.91 -0.45,0.73 -1.33,0 -1.91,0.5 -0.41,0.25 -0.37,1.1 -1.05,0.77 -0.88,0.05 -2.08,-0.67 -2.81,0.04 -0.19,0.41 -0.41,0.89 -0.9,0.49 -0.4,0.07 -0.72,0.4 -1.18,0.05 -0.54,-0.36 -1.34,-0.08 -1.15,0.66 -0.02,0.61 0.01,1.6 -0.89,1.4 -0.93,0.17 -1.69,-0.66 -2.64,-0.31 -0.33,-0.01 -0.47,-0.5 -0.9,-0.35 -0.93,-0.08 -1.35,0.82 -2.17,1.02 -0.34,0.18 -0.22,0.93 -0.79,0.57 -0.55,-0.02 -1.2,-0.27 -1.05,-0.96 0.23,-0.69 2.27,-0.03 1.51,-1.11 -0.87,-0.37 -1.06,-1.92 -2.23,-1.53 -1.06,0.48 -1.79,1.42 -2.87,1.89 -0.87,0.51 -1.76,1.49 -2.84,0.9 -1.24,-0.28 -2.36,0.73 -3.63,0.45 -0.62,0.06 -0.85,-0.41 -1.13,-0.84 -0.49,-0.61 -1.84,-0.15 -1.75,-1.18 0.02,-0.81 -0.91,-0.83 -1.23,-0.21 -1.47,0.52 -2.49,1.86 -3.55,2.97 -0.97,1.13 -1.17,2.75 -2.41,3.68 -1.84,1.62 -4.34,1.97 -6.64,2.43 -1.23,0.17 -0.94,1.78 -0.32,2.43 0.45,0.36 1.27,0.18 1.4,0.94 0.38,0.62 -0.06,1.86 0.78,2.11 1.33,-0.5 3.29,-1.19 4.44,0.06 0.32,0.49 -0.31,1.01 0.05,1.54 0.12,0.85 0.65,1.77 1.66,1.57 1.22,0.02 1.42,-1.34 1.58,-2.25 1.41,-0.73 2.98,0.35 4.23,0.96 1.07,0.54 2.74,-0.52 3.43,0.76 0.71,1.24 0.36,2.81 0.34,4.19 -0.25,0.67 -0.69,1.29 -0.76,2.05 -0.22,0.58 -0.47,1.12 -0.51,1.76 -0.5,1.45 -2.06,2.2 -2.82,3.39 0.67,0.91 0.91,2.37 1.98,2.89 1.2,0.24 2.42,0.94 3.69,0.72 0.73,-1.42 -0.01,-3.38 1,-4.71 0.64,-0.44 1.51,-0.92 2.31,-0.81 0.32,0.44 -0.62,0.86 -0.72,1.31 -0.55,0.7 -0.52,1.75 0.36,2.18 0.7,0.79 1.82,1.21 2.8,0.7 1.08,0.42 2.01,1.33 3.21,1.45 0.66,0.23 0.76,1.47 1.53,1.24 0.79,-0.72 1.74,0.37 2.4,0.78 0.99,0.8 2.91,0.04 3.39,1.55 1.01,1.06 2.45,2.01 3.97,1.61 1.72,0.14 3.53,1 5.24,0.29 0.66,-0.26 1.7,-1.42 2.34,-0.53 0.7,1.05 1.31,2.45 0.57,3.63 0.07,0.95 1.08,1.93 2.09,1.55 1.11,-0.05 1.23,1.52 2.23,1.71 0.94,0.71 1.77,1.73 1.98,2.92 0.27,0.67 1.33,0.62 1.54,1.22 -0.26,0.48 0.08,1.18 0.69,0.85 1.27,-0.41 1.28,-2.18 2.43,-2.62 0.89,0.58 1.66,1.55 2.85,1.35 0.92,-0.11 2.05,0.48 2.68,-0.46 0.62,-0.47 1.14,-1.41 1.79,-1.68 0.41,0.83 0.97,-0.26 1.03,-0.75 0.06,-1.19 -0.11,-2.49 -0.57,-3.58 -0.28,-0.34 -0.24,-1.15 0.31,-1.22 0.41,-0.43 0.88,-0.74 1.43,-0.88 0.49,-0.83 -0.38,-1.78 -0.26,-2.69 0.04,-0.68 -0.34,-1.87 0.42,-2.23 1.07,0.08 1.01,-1.21 1.1,-1.93 0.22,-0.8 0.96,0.11 1.42,-0.05 0.48,-0.23 1.42,-0.85 0.73,-1.39 -0.6,-0.67 0.63,-1.54 0.11,-2.31 -0.18,-0.51 -0.05,-1.37 0.63,-1.33 0.52,-0.34 1.16,-0.62 1.54,-1.09 0.38,-1.03 0.73,-2.17 1.36,-3.05 0.45,-0.37 0.5,0.79 0.98,0.23 0.34,-0.42 1.24,-0.16 1.09,-0.97 0.12,-0.71 -0.28,-1.75 0.22,-2.32 0.41,0.28 0.99,0.23 0.89,-0.39 0.26,-0.98 1.72,-1.96 0.94,-3.03 -0.8,-0.51 -1.17,-1.71 -0.38,-2.4 0.24,-0.57 0.38,-1.52 1.25,-1.28 0.69,0.34 1.78,-0.38 1.41,-1.14 -1.54,-1.1 -1.23,-3.23 -0.81,-4.81 -0.21,-0.46 -0.64,-0.84 -0.54,-1.44 -0.53,-0.35 -0.56,0.91 -1.19,0.96 -0.19,0.52 -0.32,1.33 -1.06,1.33 -0.46,0.09 -0.63,-0.25 -0.28,-0.52 0.22,-0.68 -0.72,-1.23 -0.23,-1.94 0.16,-0.48 -0.24,-1.2 0.54,-1.26 0.41,-0.08 1.42,0.06 1.06,-0.67 -0.16,-0.64 -0.95,-0.99 -0.68,-1.74 0.4,-1.15 -0.32,-2.45 -1.45,-2.79 -0.99,0.23 -0.64,-0.8 -0.73,-1.47 0.03,-0.53 -0.1,-1.2 -0.79,-1.05 -0.96,-0.22 -2.46,0.42 -2.92,-0.79 l -0.14,-0.08 -0.11,0.03 z",
					    "department-47" : "m 91.9,62.45 c -0.89,0.38 -0.65,1.57 -0.7,2.3 -0.3,0.38 -0.92,0.37 -0.9,-0.24 0,-0.37 -0.26,-1.33 -0.71,-0.74 -0.4,0.66 -1.24,0.6 -1.84,0.79 -0.31,0.45 0.11,1.76 -0.83,1.4 -1.18,-0.21 -1,1.95 0.11,1.67 0.73,-0.2 0.2,1.4 1.08,0.99 0.5,-0.36 1.35,-0.04 1.57,0.48 -0.28,0.6 -0.58,1.28 -0.9,1.85 -0.39,-0.04 -1.29,0.03 -0.84,0.64 0.45,0.22 0.57,0.85 0.02,1.03 -0.9,0.43 -1.54,1.19 -2.44,1.61 -0.45,0.69 -0.44,1.61 -0.97,2.3 -0.91,-0.33 -2.17,-0.17 -2.44,0.92 0.23,0.91 -1.05,0.93 -1.21,1.7 -0.47,1.15 -0.39,2.71 0.66,3.5 0.47,0.76 -0.67,1.13 -0.49,1.91 -0.07,1 0.64,1.74 1.01,2.58 0.04,0.5 0.27,1.62 -0.57,1.27 -0.87,-0.16 -1.42,0.76 -2.3,0.63 -0.7,0.1 -2.1,0.73 -1.42,1.61 0.72,1.02 2.09,1.88 1.83,3.28 0.33,0.54 0.04,1.01 -0.44,1.31 -0.55,0.35 -0.51,1.26 -1.24,1.31 -0.64,0.37 -1.37,1.37 -2.12,0.72 -0.85,0.13 -0.88,1.16 -0.51,1.76 0.36,1.14 0.02,2.43 0.34,3.57 0.5,0.27 1.11,-0.27 1.68,-0.04 1.8,0.19 3.84,-0.04 5.27,1.23 1.47,0.86 3.39,0.22 4.87,0.95 0.41,1.11 -1.17,1.62 -1.42,2.59 -0.24,1 -0.95,1.78 -1.05,2.84 -0.18,0.85 -1.14,1.45 -0.73,2.42 0.1,0.77 0.74,1.62 1.58,1.16 0.6,-0.1 0.97,-0.82 1.48,-0.96 0.77,0.33 0.15,1.57 1,1.71 0.79,-0.24 0.32,-1.42 1.07,-1.78 0.38,-0.45 0.55,-1.02 1.24,-1.15 0.41,-0.2 1.36,-0.52 1.37,0.24 0.19,0.56 0.76,0.68 1.24,0.67 0.74,0.18 1.77,1.08 2.46,0.42 -0.04,-0.37 -0.05,-0.7 0.46,-0.72 0.82,-0.23 1.7,-0.45 2.48,-0.02 0.56,-0.2 0.77,-1.01 1.47,-0.96 0.42,-0.51 1.37,-0.04 1.55,-0.85 0.13,-1.11 1.23,-1.38 2.18,-1.32 0.53,0.04 1,-0.6 1.42,-0.05 1.32,0.49 2.28,-0.75 3.13,-1.5 0.66,0.51 1.5,0.84 1.79,1.68 0.42,0.59 1.19,0.85 1.32,1.63 0.32,0.54 1.03,0.2 0.96,-0.37 0.49,-0.82 1.24,-1.61 2.25,-1.62 0.7,-0.43 0.4,-1.45 0.79,-2.11 0.28,-0.77 0.97,-1.74 1.9,-1.45 0.6,-0.42 0.06,-1.35 0.03,-1.87 1.34,-0.62 2.52,0.92 3.84,0.88 0.44,-0.11 0.28,-0.62 0.62,-0.81 0.04,-0.55 0.41,-1.65 -0.28,-1.89 -0.8,0.4 -1.74,-0.69 -1,-1.33 0.8,-0.47 2.24,0.39 2.41,-0.93 0.33,-0.72 0.83,-1.52 0.46,-2.3 0.37,-0.51 0.41,-1.22 0.37,-1.81 0.55,0.15 0.89,-0.44 0.4,-0.8 -0.6,-0.41 -0.71,-1.59 -1.63,-1.26 -0.7,0.31 -0.72,-0.71 -1.37,-0.73 -0.34,-0.56 0.36,-1.25 0.67,-1.71 0.66,-0.92 -0.47,-2.13 0.51,-2.93 0.47,-0.59 1.22,-0.31 1.54,0.29 0.37,0.37 0.4,1.12 1.13,0.98 0.67,0.1 1.28,-0.15 1.83,-0.44 0.93,-0.17 1.97,0.27 2.81,-0.06 0.27,-0.61 0.08,-1.23 -0.24,-1.74 0.54,-0.87 0.45,-2.68 -0.86,-2.59 -0.34,-0.6 -0.8,-1.13 -0.54,-1.89 0.18,-0.57 -0.29,-0.92 -0.56,-1.28 0.42,-1.08 0.13,-2.27 -0.69,-3.08 -0.38,-0.38 -0.78,-1.63 0.17,-1.46 0.43,0.03 0.78,0.64 1.18,0.15 0.55,-0.9 1.91,-1 2.27,-2.03 0.29,-1.28 -1.4,-1.57 -2.18,-2.11 -0.92,-0.45 -1.31,-1.64 -2.27,-1.97 -0.69,0.45 -1.65,-0.25 -2.25,0.5 -0.61,0.68 -1.43,0.99 -2.18,1.41 -0.29,0.37 -0.35,1.08 -1.01,0.82 -1.13,0.1 -1.41,-1.19 -1.83,-1.96 0.93,-0.48 0.62,-1.61 1.18,-2.32 0.05,-0.62 -1.18,-0.47 -0.68,-1.24 0.18,-1.06 -1.87,-1.58 -1.83,-0.3 -0.35,0.44 -1.02,-0.39 -1.26,0.26 -1.45,0.45 -3.15,0.65 -4.62,0.24 -0.37,-0.54 -0.41,-1.87 -1.38,-1.67 -0.4,0.16 -0.11,0.95 -0.69,0.7 -0.7,-0.18 -1.79,-0.24 -1.87,0.74 -0.14,0.56 -0.81,1.22 -1.39,1.07 -0.38,-0.59 -1.13,-1 -1.75,-0.44 -0.72,0.51 -1.7,0.28 -2.31,1.05 -0.57,0.33 -1.27,0.64 -1.9,0.75 -0.61,-0.47 -1.4,-0.39 -2.02,-0.75 -0.42,0.1 -1.05,0.13 -0.99,-0.49 -0.06,-0.86 0.81,-1.86 -0.17,-2.49 -0.31,-0.45 0.41,-1.01 -0.06,-1.48 -0.61,-0.79 -1.11,-2.48 -2.39,-2.15 -0.77,0.3 -1.96,0.71 -2.4,-0.26 -0.08,-0.05 -0.18,-0.1 -0.28,-0.07 z",
					    "department-24" : "m 109.55,0.56 c -0.69,0.52 -0.52,1.57 -1.23,2.02 -0.05,0.59 -1.04,0.7 -0.7,1.41 -0.01,0.76 -1.2,0.88 -1.72,1.03 -0.03,-0.96 -0.69,-0.77 -1.01,-0.07 -0.24,0.29 -0.16,0.69 -0.51,0.83 0.14,0.57 0.74,1.05 0.54,1.74 -0.15,0.87 -0.71,1.67 -0.5,2.59 -0.23,0.73 -1.07,0.83 -1.65,1.13 -0.26,0.36 -0.46,0.71 -0.81,0.94 -0.22,0.73 -0.84,1.32 -0.8,2.13 -0.38,0.73 -1.25,-0.27 -1.84,0.15 -0.55,0.17 -0.69,0.8 -1.26,0.89 -0.27,0.52 -0.83,0.65 -1.24,1 -0.23,0.25 -0.17,1.18 -0.67,0.66 -0.21,-0.45 -1.1,-0.67 -0.87,0.05 0.1,0.34 0.9,0.84 0.18,1 -0.79,-0.1 -1.49,0.4 -1.65,1.18 -0.61,1.5 -1.31,3.23 -0.43,4.77 0.22,1.05 0.7,2.52 -0.15,3.39 -0.67,0.36 -1.82,-0.23 -2.02,0.83 -0.18,0.71 -0.62,1.31 -1.39,1.35 -0.79,0.36 -0.32,1.45 -1.06,1.91 -0.55,0.4 -1.09,1.74 -1.93,1.19 -0.56,-0.26 -0.99,-1.4 -1.7,-0.68 -0.52,0.57 -1.26,-0.49 -1.71,0.21 -0.3,0.51 -0.58,0.94 -1.23,1.03 -0.83,0.42 -0.59,1.6 -1.37,2.12 -0.92,0.6 1.28,0.76 0.42,1.36 -0.54,0.34 -1.61,0.56 -1.28,1.43 -0.03,0.31 -0.46,0.97 0.18,0.89 1.06,-0.22 2.4,-0.39 3.36,0.24 0.66,0.81 1.21,1.96 1.15,2.99 -0.32,1.33 -1.58,2.25 -1.48,3.7 -0.16,0.71 -0,1.79 -0.59,2.27 -0.79,0.03 -0.78,1.24 -0.88,1.82 0.01,0.95 1.07,1.61 1.13,2.42 -0.74,1.19 -1.19,2.7 -2.23,3.65 -0.67,0.34 0.47,0.7 0.8,0.63 0.64,-0.12 1.35,-0.11 1.62,0.61 0.14,1.03 1.64,1.3 2.2,0.48 0.56,-0.33 1.05,0.13 1.51,0.33 1.01,-0.54 2.28,0.08 3.36,0.02 0.53,-0.51 0.91,-1.21 1.62,-1.56 0.62,-0.25 0.42,-1.04 0.73,-1.42 1.24,0.04 2.68,0.63 3.31,1.74 -0.37,0.55 -0.91,1.21 -1.54,1.45 -0.52,-0.26 -0.89,0.25 -0.55,0.71 0.39,0.93 -0.04,2.17 0.97,2.8 0.92,1.16 2.64,2.15 2.56,3.82 -0.22,0.59 0.36,0.94 0.57,1.36 -0.02,0.62 -0.8,1.76 0.01,2.13 0.55,-0.15 0.9,0.45 1.48,0.33 0.58,0.29 1.23,0.61 1.87,0.19 0.96,-0.25 1.53,-1.33 2.6,-1.2 0.69,-0.13 1.57,-1.14 2.15,-0.25 0.53,1.06 1.45,-0.16 1.68,-0.82 0.01,-1.11 1.34,-0.6 2,-0.79 0.39,-0.32 1,-0.88 1.4,-0.23 0.53,0.37 0.44,1.11 0.8,1.53 1.42,0.12 2.98,0.12 4.32,-0.44 0.26,-0.46 0.6,-0.25 0.98,-0.09 0.41,-0.15 0.39,-1.03 1.01,-0.94 0.79,0.07 1.5,0.66 1.35,1.52 -0.05,0.67 1.19,0.12 0.84,0.77 -0.56,0.73 -0.39,1.75 -1.06,2.39 -0.28,0.47 0.02,1.02 0.47,1.11 0.06,0.88 1.67,1.41 1.7,0.21 0.29,-0.59 1.18,-0.45 1.6,-0.98 0.67,-0.44 1.27,-1.33 2.18,-1 0.52,0.09 1.08,-0.5 1.45,0.14 1.02,1.26 2.38,2.15 3.84,2.76 0.36,0.44 0.13,1.68 0.99,1.45 0.65,-0.44 -0.31,-1.28 0.42,-1.71 0.6,-0.9 1.78,-1.5 2.1,-2.5 0.12,-0.85 -0.67,-2.17 0.49,-2.5 1.21,-0.85 3.43,-0.34 4,-2.02 0.38,-0.27 0.84,-0.49 1,-0.94 0.56,0.17 1.32,-0.01 1.24,-0.75 -0.08,-0.47 0.23,-1.01 0.72,-0.86 0.88,-0.77 -0.2,-1.65 -0.62,-2.3 0.14,-0.32 -0.15,-0.6 -0.15,-0.85 0.63,-0.89 1.77,-1.08 2.76,-1.2 0.78,-0.51 -0.25,-1.93 0.59,-2.35 0.55,0.2 0.92,-0.48 1.44,-0.36 0.25,-0.49 0.28,-1.55 1.09,-1.4 0.49,-0.04 1.23,-0.68 0.57,-1.05 -0.43,-0.36 -1.13,-0.96 -0.99,-1.55 0.2,-0.58 1.27,-0.49 0.96,-1.23 -0.32,-1.11 -0.9,-2.1 -0.9,-3.3 0.01,-0.58 -0.38,-1.38 -0.1,-1.85 0.41,-0.2 1.72,-0.29 1.19,-1.01 -0.56,-0.78 -1.01,-1.64 -1.55,-2.4 -0.51,-0.17 0.05,-0.86 -0.33,-1.22 -0.38,-0.48 -0.12,-1.41 -0.83,-1.57 -0.16,-0.56 0.77,-0.2 1,-0.58 0.73,-0.33 0.36,-1.22 -0.33,-1.28 -0.76,-0.26 -1.64,-0.08 -2.32,-0.49 -1.04,-0.06 -2.18,0.14 -2.96,-0.68 -0.34,-0.31 -1.16,-0.68 -1.08,-1.17 0.72,-0.15 2.01,-1.03 1.26,-1.82 -0.62,-0.74 -1.75,-0.09 -2.39,-0.61 -0.27,-0.82 0.25,-1.65 1.09,-1.79 0.58,-0.2 1.5,-1.34 0.7,-1.74 -0.69,0.14 -1.48,-0.26 -1.68,-0.93 -0.71,-0.37 0.15,-1.25 0.23,-1.78 0.11,-0.58 -0.02,-1.16 -0.06,-1.74 1.19,0.25 2.03,-0.83 2.21,-1.88 0.56,-0.52 1.68,-0.63 1.61,-1.63 0.08,-0.93 -1.1,-1.13 -1.72,-0.71 -0.55,-0.39 -1.42,-1.26 -0.99,-1.98 0.45,-0.18 1.41,0.05 1.19,-0.79 -0.34,-0.76 -1.39,-1.07 -2.06,-0.64 -0.44,-0.41 -0.38,-1.38 -1.2,-1.42 -0.6,-0.2 -1.45,0.77 -1.74,-0.1 -0.13,-0.67 -0.71,-1.17 -1.4,-0.83 -0.75,0.52 -1.7,-0.49 -1.13,-1.19 0.4,-0.91 1.18,-1.56 1.81,-2.31 -0.65,-0.45 -1.55,-1.43 -2.44,-1.09 -0.2,0.39 -0.92,0.73 -1.27,0.49 -0.33,-0.68 -0.88,-1.15 -1.49,-1.51 -1.01,-0.88 -0.04,-2.73 -1.42,-3.3 -0.91,-0.33 -1.85,0.53 -2.71,-0.13 -1.03,-0.37 -1.97,0.66 -2.94,0.59 -0.57,-0.27 -0.67,-1.45 -1.27,-1.26 -0.57,0.95 -0.62,2.73 -2.02,2.84 -0.93,0.29 -0.39,-1.33 -1.28,-1.13 -0.95,0.56 -1.26,-0.79 -1.83,-1.25 -0.33,-0.59 0.53,-1.18 0.5,-1.82 0.17,-0.69 0.65,-1.72 -0.24,-2.09 -0.48,-0.76 -1.45,-1.82 -2.4,-1.19 -0.94,0.23 -2.19,0.52 -2.82,-0.45 -0.47,-0.61 -0.85,-0.72 -1.32,-0.02 z"
					}
				}
			}
		}
	);
})(jQuery);