/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils.counters;

import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;

public final class InstanceCounter {
    private int size;
    private int nullCount;
    private final long[] keys;
    private final int[] counts;

    public InstanceCounter(int bufferSize) {
        bufferSize = bufferSize * 9 / 8;
        this.keys = new long[bufferSize];
        this.counts = new int[bufferSize];
    }

    public void count(Instance ikey) {
        if (ikey == null) {
            ++this.nullCount;
        } else {
            int idx;
            long key = ikey.getInstanceId();
            int index = idx = this.hash(key);
            while (this.keys[index] != key && this.counts[index] != 0) {
                if ((index = this.incIndex(index)) != idx) continue;
                throw new RuntimeException("Full when counting " + ikey);
            }
            if (this.counts[index] == 0) {
                this.keys[index] = key;
                ++this.size;
            }
            int n = index;
            this.counts[n] = this.counts[n] + 1;
        }
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public int size() {
        return this.size + (this.nullCount > 0 ? 1 : 0);
    }

    private int hash(long key) {
        return (int)Math.abs(key % (long)this.keys.length);
    }

    private int incIndex(int index) {
        return ++index < this.keys.length ? index : 0;
    }

    public final class Iterator
    implements java.util.Iterator<Record> {
        private final boolean hasNullCount;
        private int index;
        private int count;

        private Iterator() {
            this.hasNullCount = InstanceCounter.this.nullCount > 0;
        }

        @Override
        public boolean hasNext() {
            return this.hasNullCount ? this.count <= InstanceCounter.this.size : this.count < InstanceCounter.this.size;
        }

        @Override
        public Record next() {
            Record entry = new Record();
            if (this.count == InstanceCounter.this.size) {
                entry.value = -1L;
                entry.count = InstanceCounter.this.nullCount;
            } else {
                entry.count = InstanceCounter.this.counts[this.index];
                while (entry.count == 0) {
                    entry.count = InstanceCounter.this.counts[++this.index];
                }
                entry.value = InstanceCounter.this.keys[this.index++];
            }
            ++this.count;
            return entry;
        }
    }

    public static final class Record {
        private long value;
        private int count;

        private Record() {
        }

        public Instance getInstance(Heap heap) {
            return this.value == -1L ? null : heap.getInstanceByID(this.value);
        }

        public int getCount() {
            return this.count;
        }

        public int hashCode() {
            return Long.hashCode(this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            return this.value == ((Record)o).value;
        }
    }
}

