/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.CGI;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.JnetFile;
import jalview.MSFfile;
import jalview.ScoreSequence;
import jalview.SecondaryColourScheme;
import jalview.Sequence;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

public class JnetCGI
extends CGI {
    Sequence[] sequence;
    Object parent;

    public JnetCGI(String string, int n, String string2, Sequence[] sequenceArray, PrintStream printStream, Object object) {
        super(string, n, string2, printStream);
        this.sequence = sequenceArray;
        this.variables = this.makeVariables();
        this.parent = object;
    }

    public Hashtable makeVariables() {
        String string = MSFfile.print(this.sequence);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("sequence", string);
        return hashtable;
    }

    public void insertGaps(Sequence sequence, Sequence sequence2) {
        int n = 0;
        while (n < sequence.sequence.length()) {
            String string = sequence.sequence.substring(n, n + 1);
            if (string.equals("-") || string.equals(".") || string.equals(" ")) {
                System.out.println(String.valueOf(n) + " " + sequence2.sequence.length());
                sequence2.insertCharAt(n, '-', false);
            }
            ++n;
        }
    }

    public DrawableSequence copySequence(DrawableSequence drawableSequence) {
        DrawableSequence drawableSequence2 = new DrawableSequence(drawableSequence.name, drawableSequence.sequence, drawableSequence.start, drawableSequence.end);
        int n = 0;
        while (n < drawableSequence.score.length && drawableSequence.score[n] != null) {
            drawableSequence2.score[n] = (Vector)drawableSequence.score[n].clone();
            ++n;
        }
        return drawableSequence2;
    }

    public void readInput(DataInputStream dataInputStream) {
        String string = "";
        String string2 = "";
        try {
            while ((string = dataInputStream.readLine()) != null) {
                string2 = String.valueOf(string2) + string + "\n";
            }
            this.statout.print("Prediction finished. Displaying output...");
            Sequence[] sequenceArray = FormatAdapter.toDrawableSequence(FormatAdapter.read("JNET", string2));
            this.insertGaps(this.sequence[0], sequenceArray[0]);
            this.insertGaps(this.sequence[0], sequenceArray[1]);
            System.out.println("ds0 " + sequenceArray[0].sequence);
            System.out.println("ds1 " + sequenceArray[1].sequence);
            String string3 = JnetFile.print(sequenceArray);
            System.out.println(string3);
            sequenceArray[0].name = this.sequence[0].name;
            sequenceArray[0].start = this.sequence[0].start;
            sequenceArray[0].end = this.sequence[0].end;
            sequenceArray[1].name = this.sequence[0].name;
            sequenceArray[1].start = this.sequence[0].start;
            sequenceArray[1].end = this.sequence[0].end;
            DrawableSequence[] drawableSequenceArray = new DrawableSequence[5];
            drawableSequenceArray[0] = sequenceArray[1];
            SecondaryColourScheme secondaryColourScheme = new SecondaryColourScheme();
            secondaryColourScheme.setColours(drawableSequenceArray[0]);
            drawableSequenceArray[1] = new ScoreSequence(this.copySequence((DrawableSequence)sequenceArray[1]), 0, 50, 50, 255);
            drawableSequenceArray[1].name = String.valueOf(drawableSequenceArray[1].name) + ".conf";
            drawableSequenceArray[2] = new ScoreSequence(this.copySequence((DrawableSequence)sequenceArray[1]), 1, 255, 50, 255);
            drawableSequenceArray[2].name = String.valueOf(drawableSequenceArray[2].name) + ".helix";
            drawableSequenceArray[3] = new ScoreSequence(this.copySequence((DrawableSequence)sequenceArray[1]), 2, 255, 255, 50);
            drawableSequenceArray[3].name = String.valueOf(drawableSequenceArray[3].name) + ".sheet";
            drawableSequenceArray[4] = new ScoreSequence(this.copySequence((DrawableSequence)sequenceArray[1]), 3, 50, 255, 255);
            drawableSequenceArray[4].name = String.valueOf(drawableSequenceArray[4].name) + ".turn";
            drawableSequenceArray[0].name = String.valueOf(drawableSequenceArray[0].name) + ".pred";
            AlignFrame alignFrame = null;
            alignFrame = this.parent instanceof AlignFrame ? (AlignFrame)this.parent : new AlignFrame((Object)"Null", (DrawableSequence[])sequenceArray);
            if (alignFrame != null && alignFrame.bp.scorePanel != null) {
                alignFrame.bp.scorePanel.seqPanel.align.addSequence(drawableSequenceArray);
                alignFrame.updateFont();
                return;
            }
        }
        catch (IOException iOException) {
            if (this.parent instanceof AlignFrame) {
                AlignFrame alignFrame = (AlignFrame)this.parent;
                alignFrame.error("ERROR: IOException when contacting Jnet server", true);
            }
            System.out.println("Exception " + iOException);
        }
    }

    public static void main(String[] stringArray) {
        Sequence[] sequenceArray = FormatAdapter.toDrawableSequence(FormatAdapter.read(stringArray[0], "File", stringArray[1]));
        JnetCGI jnetCGI = new JnetCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runjnet", sequenceArray, System.out, null);
        jnetCGI.run();
    }
}

